/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers.tiles;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import java.util.Random;
import java.util.stream.IntStream;
import net.mehvahdjukaar.supplementaries.block.tiles.FireflyJarBlockTile;
import net.mehvahdjukaar.supplementaries.client.renderers.RendererUtil;
import net.mehvahdjukaar.supplementaries.common.Textures;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderState;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.settings.GraphicsFanciness;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Quaternion;

public class SoulJarBlockTileRenderer
extends TileEntityRenderer<FireflyJarBlockTile> {
    private final Minecraft minecraft = Minecraft.func_71410_x();
    public static final RenderMaterial SOUL_MATERIAL = new RenderMaterial(AtlasTexture.field_110575_b, Textures.SOUL_TEXTURE);
    public static final ResourceLocation END_SKY_TEXTURE = new ResourceLocation("textures/environment/end_sky.png");
    public static final ResourceLocation END_PORTAL_TEXTURE = new ResourceLocation("textures/entity/end_portal.png");
    private static final Random RANDOM = new Random(31100L);
    private static final List<RenderType> RENDER_TYPES = (List)IntStream.range(0, 16).mapToObj(i -> RenderType.func_228630_a_((int)(i + 1))).collect(ImmutableList.toImmutableList());

    public SoulJarBlockTileRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        super(rendererDispatcherIn);
    }

    protected int getPasses(double p_191286_1_) {
        if (p_191286_1_ > 36864.0) {
            return 1;
        }
        if (p_191286_1_ > 25600.0) {
            return 3;
        }
        if (p_191286_1_ > 16384.0) {
            return 5;
        }
        if (p_191286_1_ > 9216.0) {
            return 7;
        }
        if (p_191286_1_ > 4096.0) {
            return 9;
        }
        if (p_191286_1_ > 1024.0) {
            return 11;
        }
        if (p_191286_1_ > 576.0) {
            return 13;
        }
        return p_191286_1_ > 256.0 ? 14 : 15;
    }

    private void renderCube(float p_228883_2_, float p_228883_3_, Matrix4f p_228883_4_, IVertexBuilder p_228883_5_) {
        float f = 1.0E-4f;
        float f1 = 0.005f;
        float f2 = 0.5f;
        this.renderFace(p_228883_4_, p_228883_5_, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 1.0f, f, f1, f2, Direction.DOWN);
    }

    private void renderFace(Matrix4f matrix4f, IVertexBuilder builder, float p_228884_4_, float p_228884_5_, float p_228884_6_, float p_228884_7_, float p_228884_8_, float p_228884_9_, float p_228884_10_, float p_228884_11_, float r, float g, float b, Direction p_228884_15_) {
        builder.func_227888_a_(matrix4f, p_228884_4_, p_228884_6_, p_228884_8_).func_227885_a_(r, g, b, 1.0f).func_181675_d();
        builder.func_227888_a_(matrix4f, p_228884_5_, p_228884_6_, p_228884_9_).func_227885_a_(r, g, b, 1.0f).func_181675_d();
        builder.func_227888_a_(matrix4f, p_228884_5_, p_228884_7_, p_228884_10_).func_227885_a_(r, g, b, 1.0f).func_181675_d();
        builder.func_227888_a_(matrix4f, p_228884_4_, p_228884_7_, p_228884_11_).func_227885_a_(r, g, b, 1.0f).func_181675_d();
    }

    public void render(FireflyJarBlockTile tile, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int combinedLightIn, int combinedOverlayIn) {
        if (!tile.soul || this.minecraft.field_71474_y.field_238330_f_ == GraphicsFanciness.FABULOUS) {
            return;
        }
        matrixStackIn.func_227860_a_();
        int lu = combinedLightIn & 0xFFFF;
        int lv = combinedLightIn >> 16 & 0xFFFF;
        matrixStackIn.func_227861_a_(0.5, 0.375, 0.5);
        matrixStackIn.func_227862_a_(0.5f, 0.5f, 0.5f);
        TextureAtlasSprite sprite = (TextureAtlasSprite)this.minecraft.func_228015_a_(AtlasTexture.field_110575_b).apply(Textures.SOUL_TEXTURE);
        IVertexBuilder builder = bufferIn.getBuffer(RenderType.func_228643_e_());
        Quaternion rotation = this.minecraft.func_175598_ae().func_229098_b_();
        matrixStackIn.func_227863_a_(rotation);
        RendererUtil.addQuadSide(builder, matrixStackIn, 0.5f, -0.5f, 0.0f, -0.5f, 0.5f, 0.0f, sprite.func_94209_e(), sprite.func_94206_g(), sprite.func_94212_f(), sprite.func_94210_h(), 1.0f, 1.0f, 1.0f, 1.0f, lu, lv, 0.0f, 1.0f, 0.0f);
        matrixStackIn.func_227865_b_();
    }

    public static final class PortalTexturingState
    extends RenderState.TexturingState {
        private final int iteration;

        public PortalTexturingState(int it) {
            super("portal_texturing", () -> {
                RenderSystem.matrixMode((int)5889);
                RenderSystem.pushMatrix();
                RenderSystem.loadIdentity();
                RenderSystem.multMatrix((Matrix4f)Matrix4f.func_195876_a((double)85.0, (float)((float)Minecraft.func_71410_x().func_228018_at_().func_198109_k() / (float)Minecraft.func_71410_x().func_228018_at_().func_198091_l()), (float)0.05f, (float)10.0f));
                RenderSystem.matrixMode((int)5888);
                RenderSystem.translatef((float)0.5f, (float)0.5f, (float)0.0f);
                RenderSystem.scalef((float)0.5f, (float)0.5f, (float)1.0f);
                RenderSystem.translatef((float)(17.0f / (float)it), (float)((2.0f + (float)it / 1.5f) * ((float)(Util.func_211177_b() % 800000L) / 800000.0f)), (float)0.0f);
                RenderSystem.scalef((float)(4.5f - (float)it / 4.0f), (float)(4.5f - (float)it / 4.0f), (float)1.0f);
                RenderSystem.mulTextureByProjModelView();
                RenderSystem.setupEndPortalTexGen();
            }, () -> {
                RenderSystem.popMatrix();
                RenderSystem.clearTexGen();
            });
            this.iteration = it;
        }
    }
}

