/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.mehvahdjukaar.selene.map.CustomDecorationType;
import net.mehvahdjukaar.selene.map.MapDecorationHandler;
import net.mehvahdjukaar.supplementaries.Supplementaries;
import net.mehvahdjukaar.supplementaries.configs.ConfigHandler;
import net.mehvahdjukaar.supplementaries.configs.ServerConfigs;
import net.mehvahdjukaar.supplementaries.world.data.map.CMDreg;
import net.minecraft.entity.Entity;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.item.FilledMapItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.MerchantOffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.structure.OceanMonumentStructure;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.WoodlandMansionStructure;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.MapData;
import net.minecraft.world.storage.MapDecoration;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;

public class AdventurerMapsHandler {
    private static final int SEARCH_RADIUS = 100;
    private static final List<TradeData> customTrades = new ArrayList<TradeData>();
    private static final Map<Structure<?>, Pair<CustomDecorationType<?, ?>, Integer>> defaultStructureMarkers = new HashMap();
    private static final List<Structure<?>> randomMapPool = Arrays.asList(Structure.field_236373_i_, Structure.field_236372_h_, Structure.field_236374_j_, Structure.field_236383_s_, Structure.field_236369_e_, Structure.field_236370_f_, Structure.field_236366_b_, Structure.field_236367_c_, Structure.field_236377_m_, Structure.field_236371_g_, Structure.field_236379_o_);

    private static CustomDecorationType<?, ?> getVanillaMarker(Structure<?> structure) {
        CustomDecorationType type = (CustomDecorationType)defaultStructureMarkers.get(structure).getLeft();
        if (type == null) {
            type = MapDecorationHandler.GENERIC_STRUCTURE_TYPE;
        }
        return type;
    }

    private static int getVanillaColor(Structure<?> structure) {
        if (defaultStructureMarkers.containsKey(structure)) {
            return (Integer)defaultStructureMarkers.get(structure).getRight();
        }
        return -1;
    }

    public static void loadCustomTrades() {
        if (!customTrades.isEmpty()) {
            return;
        }
        try {
            List<? extends List<String>> tradeData = ConfigHandler.safeGetListString(ServerConfigs.SERVER_SPEC, ServerConfigs.tweaks.CUSTOM_ADVENTURER_MAPS_TRADES);
            for (List<String> list : tradeData) {
                int s = list.size();
                if (s <= 0) continue;
                try {
                    String res = list.get(0);
                    if (res.isEmpty()) continue;
                    ResourceLocation structure = new ResourceLocation(res);
                    int level = 2;
                    int minPrice = 7;
                    int maxPrice = 13;
                    String mapName = null;
                    int mapColor = 0xFFFFFF;
                    ResourceLocation marker = null;
                    if (s > 1) {
                        level = Integer.parseInt(list.get(1));
                    }
                    if (level < 1 || level > 5) {
                        Supplementaries.LOGGER.warn("skipping configs 'custom_adventurer_maps' (" + list.toString() + "): invalid level, must be between 1 and 5");
                        continue;
                    }
                    if (s > 2) {
                        minPrice = Integer.parseInt(list.get(2));
                    }
                    if (s > 3) {
                        maxPrice = Integer.parseInt(list.get(3));
                    }
                    if (s > 4) {
                        mapName = list.get(4);
                    }
                    if (s > 5) {
                        mapColor = Integer.parseInt(list.get(5).replace("0x", ""), 16);
                    }
                    if (s > 6) {
                        marker = new ResourceLocation(list.get(6));
                    }
                    customTrades.add(new TradeData(structure, level, minPrice, maxPrice, mapName, mapColor, marker));
                }
                catch (Exception e) {
                    Supplementaries.LOGGER.warn("wrong formatting for configs 'custom_adventurer_maps'(" + list.toString() + "), skipping it :" + e);
                }
            }
        }
        catch (Exception e) {
            Supplementaries.LOGGER.warn("failed to parse config 'custom_adventurer_maps', skipping them.");
        }
    }

    public static void addTrades(VillagerTradesEvent event) {
        if (event.getType() == VillagerProfession.field_221154_d) {
            Int2ObjectMap trades = event.getTrades();
            for (TradeData data : customTrades) {
                if (data == null) continue;
                try {
                    ((List)trades.get(data.level)).add(new AdventureMapTrade(data));
                }
                catch (Exception e) {
                    Supplementaries.LOGGER.warn("failed to load custom adventurer map trade map for structure " + data.structure.toString());
                }
            }
            if (((Boolean)ServerConfigs.tweaks.RANDOM_ADVENTURER_MAPS.get()).booleanValue()) {
                ((List)trades.get(2)).add(new RandomAdventureMapTrade());
            }
        }
    }

    static {
        defaultStructureMarkers.put(Structure.field_236373_i_, Pair.of(CMDreg.SHIPWRECK_TYPE, (Object)3416079));
        defaultStructureMarkers.put(Structure.field_236371_g_, Pair.of(CMDreg.IGLOO_TYPE, (Object)10075586));
        defaultStructureMarkers.put(Structure.field_236372_h_, Pair.of(CMDreg.RUINED_PORTAL_TYPE, (Object)6238389));
        defaultStructureMarkers.put(Structure.field_236381_q_, Pair.of(CMDreg.VILLAGE_TYPE, (Object)12224341));
        defaultStructureMarkers.put(Structure.field_236377_m_, Pair.of(CMDreg.OCEAN_RUIN_TYPE, (Object)3828045));
        defaultStructureMarkers.put(Structure.field_236366_b_, Pair.of(CMDreg.PILLAGER_OUTPOST_TYPE, (Object)0x1F1100));
        defaultStructureMarkers.put(Structure.field_236370_f_, Pair.of(CMDreg.DESERT_PYRAMID_TYPE, (Object)8416575));
        defaultStructureMarkers.put(Structure.field_236369_e_, Pair.of(CMDreg.JUNGLE_TEMPLE_TYPE, (Object)5400120));
        defaultStructureMarkers.put(Structure.field_236383_s_, Pair.of(CMDreg.BASTION_TYPE, (Object)2894127));
        defaultStructureMarkers.put(Structure.field_236379_o_, Pair.of(CMDreg.END_CITY_TYPE, (Object)10253227));
        defaultStructureMarkers.put((Structure<?>)Structure.field_236374_j_, (Pair<CustomDecorationType<?, ?>, Integer>)Pair.of(CMDreg.SWAMP_HUT_TYPE, (Object)1786143));
        defaultStructureMarkers.put(Structure.field_236378_n_, Pair.of(CMDreg.NETHER_FORTRESS, (Object)3934219));
        defaultStructureMarkers.put(Structure.field_236367_c_, Pair.of(CMDreg.MINESHAFT_TYPE, (Object)0x808080));
    }

    private static class AdventureMapTrade
    implements VillagerTrades.ITrade {
        public final TradeData tradeData;

        private AdventureMapTrade(TradeData data) {
            this.tradeData = data;
        }

        public MerchantOffer func_221182_a(@Nonnull Entity entity2, @Nonnull Random random) {
            int i = random.nextInt(Math.max(1, this.tradeData.maxPrice - this.tradeData.minPrice + 1) + this.tradeData.minPrice);
            ItemStack itemstack = this.createMap(entity2.field_70170_p, entity2.func_233580_cy_());
            if (itemstack.func_190926_b()) {
                return null;
            }
            return new MerchantOffer(new ItemStack((IItemProvider)Items.field_151166_bC, i), new ItemStack((IItemProvider)Items.field_151111_aL), itemstack, 12, Math.max(1, 5 * (this.tradeData.level - 1)), 0.2f);
        }

        private ItemStack createMap(World world, BlockPos pos) {
            Structure structure = (Structure)ForgeRegistries.STRUCTURE_FEATURES.getValue(this.tradeData.structure);
            if (!(world instanceof ServerWorld) || structure == null) {
                return ItemStack.field_190927_a;
            }
            BlockPos toPos = ((ServerWorld)world).func_241117_a_(structure, pos, 100, true);
            if (toPos == null) {
                return ItemStack.field_190927_a;
            }
            ItemStack stack = FilledMapItem.func_195952_a((World)world, (int)toPos.func_177958_n(), (int)toPos.func_177952_p(), (byte)2, (boolean)true, (boolean)true);
            FilledMapItem.func_226642_a_((ServerWorld)((ServerWorld)world), (ItemStack)stack);
            if (structure instanceof OceanMonumentStructure) {
                MapData.func_191094_a((ItemStack)stack, (BlockPos)pos, (String)"+", (MapDecoration.Type)MapDecoration.Type.MONUMENT);
            } else if (structure instanceof WoodlandMansionStructure) {
                MapData.func_191094_a((ItemStack)stack, (BlockPos)pos, (String)"+", (MapDecoration.Type)MapDecoration.Type.MANSION);
            } else {
                int color;
                int n = color = this.tradeData.mapColor == 0xFFFFFF ? AdventurerMapsHandler.getVanillaColor(structure) : this.tradeData.mapColor;
                if (this.tradeData.marker == null) {
                    MapDecorationHandler.addTargetDecoration((ItemStack)stack, (BlockPos)toPos, (CustomDecorationType)AdventurerMapsHandler.getVanillaMarker(structure), (int)color);
                } else {
                    MapDecorationHandler.addTargetDecoration((ItemStack)stack, (BlockPos)toPos, (ResourceLocation)this.tradeData.marker, (int)color);
                }
            }
            TranslationTextComponent name = new TranslationTextComponent(this.tradeData.mapName == null ? "filled_map." + structure.func_143025_a().toLowerCase(Locale.ROOT) : this.tradeData.mapName);
            stack.func_200302_a((ITextComponent)name);
            return stack;
        }
    }

    private static class RandomAdventureMapTrade
    implements VillagerTrades.ITrade {
        private RandomAdventureMapTrade() {
        }

        public MerchantOffer func_221182_a(@Nonnull Entity entity2, @Nonnull Random random) {
            int maxPrice = 13;
            int minPrice = 7;
            int level = 2;
            int i = random.nextInt(maxPrice - minPrice + 1) + minPrice;
            ItemStack itemstack = this.createMap(entity2.field_70170_p, entity2.func_233580_cy_());
            if (itemstack.func_190926_b()) {
                return null;
            }
            return new MerchantOffer(new ItemStack((IItemProvider)Items.field_151166_bC, i), new ItemStack((IItemProvider)Items.field_151111_aL), itemstack, 12, 5, 0.2f);
        }

        private ItemStack createMap(World world, BlockPos pos) {
            Structure structure;
            BlockPos toPos;
            if (!(world instanceof ServerWorld)) {
                return ItemStack.field_190927_a;
            }
            ServerWorld serverWorld = (ServerWorld)world;
            if (!serverWorld.func_73046_m().func_240793_aU_().func_230418_z_().func_236222_c_()) {
                return ItemStack.field_190927_a;
            }
            List pool = randomMapPool.stream().filter(s -> serverWorld.func_72863_F().func_201711_g().func_202090_b().func_205004_a(s)).collect(Collectors.toList());
            int size = pool.size();
            if (size > 0 && (toPos = ((ServerWorld)world).func_241117_a_(structure = (Structure)pool.get(serverWorld.field_73012_v.nextInt(size)), pos, 100, true)) != null) {
                ItemStack stack = FilledMapItem.func_195952_a((World)world, (int)toPos.func_177958_n(), (int)toPos.func_177952_p(), (byte)2, (boolean)true, (boolean)true);
                FilledMapItem.func_226642_a_((ServerWorld)((ServerWorld)world), (ItemStack)stack);
                MapDecorationHandler.addTargetDecoration((ItemStack)stack, (BlockPos)toPos, (CustomDecorationType)AdventurerMapsHandler.getVanillaMarker(structure), (int)7869722);
                stack.func_200302_a((ITextComponent)new TranslationTextComponent("filled_map.adventure"));
                return stack;
            }
            return ItemStack.field_190927_a;
        }
    }

    private static class TradeData {
        public final ResourceLocation structure;
        public final int level;
        public final int minPrice;
        public final int maxPrice;
        public final String mapName;
        public final int mapColor;
        public final ResourceLocation marker;

        private TradeData(ResourceLocation structure, int level, int minPrice, int maxPrice, @Nullable String name, int mapColor, @Nullable ResourceLocation marker) {
            this.structure = structure;
            this.marker = marker;
            this.mapName = name;
            this.mapColor = mapColor;
            this.level = level;
            this.minPrice = minPrice;
            this.maxPrice = maxPrice;
        }
    }
}

