/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.setup;

import net.mehvahdjukaar.selene.fluids.ISoftFluidConsumer;
import net.mehvahdjukaar.selene.fluids.SoftFluidRegistry;
import net.mehvahdjukaar.selene.util.DispenserHelper;
import net.mehvahdjukaar.supplementaries.block.blocks.BambooSpikesBlock;
import net.mehvahdjukaar.supplementaries.block.blocks.PancakeBlock;
import net.mehvahdjukaar.supplementaries.block.tiles.JarBlockTile;
import net.mehvahdjukaar.supplementaries.block.util.CapturedMobsHelper;
import net.mehvahdjukaar.supplementaries.block.util.ILightable;
import net.mehvahdjukaar.supplementaries.common.ModTags;
import net.mehvahdjukaar.supplementaries.common.StaticBlockItem;
import net.mehvahdjukaar.supplementaries.configs.RegistryConfigs;
import net.mehvahdjukaar.supplementaries.configs.ServerConfigs;
import net.mehvahdjukaar.supplementaries.entities.AmethystArrowEntity;
import net.mehvahdjukaar.supplementaries.entities.BombEntity;
import net.mehvahdjukaar.supplementaries.entities.RopeArrowEntity;
import net.mehvahdjukaar.supplementaries.entities.ThrowableBrickEntity;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.DispenserBlock;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.dispenser.IPosition;
import net.minecraft.dispenser.ProjectileDispenseBehavior;
import net.minecraft.entity.Entity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.DirectionalPlaceContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class DispenserStuff {
    public static void registerBehaviors() {
        if (!((Boolean)RegistryConfigs.reg.DISPENSERS.get()).booleanValue()) {
            return;
        }
        if (((Boolean)RegistryConfigs.reg.JAR_ENABLED.get()).booleanValue()) {
            DispenserHelper.registerPlaceBlockBehavior((IItemProvider)((IItemProvider)ModRegistry.SOUL_JAR.get()));
            DispenserHelper.registerPlaceBlockBehavior((IItemProvider)((IItemProvider)ModRegistry.FIREFLY_JAR.get()));
            DispenserHelper.registerPlaceBlockBehavior((IItemProvider)((IItemProvider)ModRegistry.JAR_ITEM.get()));
            DispenserHelper.registerPlaceBlockBehavior((IItemProvider)((IItemProvider)ModRegistry.JAR_TINTED.get()));
            DispenserHelper.registerCustomBehavior((DispenserHelper.AdditionalDispenserBehavior)new DispenserHelper.AddItemToInventoryBehavior(Items.field_151106_aX));
            for (Item i : CapturedMobsHelper.VALID_BUCKETS.keySet()) {
                DispenserHelper.registerCustomBehavior((DispenserHelper.AdditionalDispenserBehavior)new FishBucketJarDispenserBehavior(i));
            }
        }
        DispenserHelper.registerCustomBehavior((DispenserHelper.AdditionalDispenserBehavior)new FlintAndSteelDispenserBehavior(Items.field_151033_d));
        DispenserHelper.registerCustomBehavior((DispenserHelper.AdditionalDispenserBehavior)new BambooSpikesDispenserBehavior(Items.field_185156_bI));
        DispenserHelper.registerCustomBehavior((DispenserHelper.AdditionalDispenserBehavior)new PancakesDispenserBehavior(Items.field_226638_pX_));
        if (ServerConfigs.cached.THROWABLE_BRICKS_ENABLED) {
            for (Item i : ModTags.BRICKS.func_230236_b_()) {
                DispenserHelper.registerCustomBehavior((DispenserHelper.AdditionalDispenserBehavior)new ThrowableBricksDispenserBehavior(i));
            }
        }
        if (((Boolean)RegistryConfigs.reg.FIREFLY_ENABLED.get()).booleanValue()) {
            DispenserHelper.registerSpawnEggBehavior((IItemProvider)((IItemProvider)ModRegistry.FIREFLY_SPAWN_EGG_ITEM.get()));
        }
        if (((Boolean)RegistryConfigs.reg.BOMB_ENABLED.get()).booleanValue()) {
            DispenserBlock.func_199774_a((IItemProvider)((IItemProvider)ModRegistry.BOMB_ITEM.get()), (IDispenseItemBehavior)new BombsDispenserBehavior(false));
            DispenserBlock.func_199774_a((IItemProvider)((IItemProvider)ModRegistry.BOMB_BLUE_ITEM.get()), (IDispenseItemBehavior)new BombsDispenserBehavior(true));
            DispenserBlock.func_199774_a((IItemProvider)((IItemProvider)ModRegistry.BOMB_ITEM_ON.get()), (IDispenseItemBehavior)new BombsDispenserBehavior(false));
            DispenserBlock.func_199774_a((IItemProvider)((IItemProvider)ModRegistry.BOMB_BLUE_ITEM_ON.get()), (IDispenseItemBehavior)new BombsDispenserBehavior(true));
        }
        if (ServerConfigs.cached.PLACEABLE_GUNPOWDER) {
            DispenserHelper.registerCustomBehavior((DispenserHelper.AdditionalDispenserBehavior)new GunpowderBehavior(Items.field_151016_H));
        }
        if (((Boolean)RegistryConfigs.reg.ROPE_ARROW_ENABLED.get()).booleanValue()) {
            DispenserBlock.func_199774_a((IItemProvider)((IItemProvider)ModRegistry.ROPE_ARROW_ITEM.get()), (IDispenseItemBehavior)new ProjectileDispenseBehavior(){

                protected ProjectileEntity func_82499_a(World world, IPosition pos, ItemStack stack) {
                    CompoundNBT com = stack.func_77978_p();
                    int charges = stack.func_77958_k();
                    if (com != null && com.func_74764_b("Damage")) {
                        charges -= com.func_74762_e("Damage");
                    }
                    RopeArrowEntity arrow = new RopeArrowEntity(world, pos.func_82615_a(), pos.func_82617_b(), pos.func_82616_c(), charges);
                    arrow.field_70251_a = AbstractArrowEntity.PickupStatus.ALLOWED;
                    return arrow;
                }
            });
        }
        if (((Boolean)RegistryConfigs.reg.AMETHYST_ARROW_ENABLED.get()).booleanValue()) {
            DispenserBlock.func_199774_a((IItemProvider)((IItemProvider)ModRegistry.AMETHYST_ARROW_ITEM.get()), (IDispenseItemBehavior)new ProjectileDispenseBehavior(){

                protected ProjectileEntity func_82499_a(World world, IPosition pos, ItemStack stack) {
                    AmethystArrowEntity arrow = new AmethystArrowEntity(world, pos.func_82615_a(), pos.func_82617_b(), pos.func_82616_c());
                    arrow.field_70251_a = AbstractArrowEntity.PickupStatus.DISALLOWED;
                    return arrow;
                }
            });
        }
    }

    public static class GunpowderBehavior
    extends DispenserHelper.AdditionalDispenserBehavior {
        protected GunpowderBehavior(Item item2) {
            super(item2);
        }

        protected ActionResult<ItemStack> customBehavior(IBlockSource source, ItemStack stack) {
            Direction direction = (Direction)source.func_189992_e().func_177229_b((Property)DispenserBlock.field_176441_a);
            BlockPos blockpos = source.func_180699_d().func_177972_a(direction);
            Direction direction1 = source.func_197524_h().func_175623_d(blockpos.func_177977_b()) ? direction : Direction.UP;
            ActionResultType result = StaticBlockItem.place((BlockItemUseContext)new DirectionalPlaceContext((World)source.func_197524_h(), blockpos, direction, stack, direction1), (Block)ModRegistry.GUNPOWDER_BLOCK.get());
            if (result.func_226246_a_()) {
                return ActionResult.func_226248_a_((Object)stack);
            }
            return ActionResult.func_226251_d_((Object)stack);
        }
    }

    private static class FishBucketJarDispenserBehavior
    extends DispenserHelper.AdditionalDispenserBehavior {
        protected FishBucketJarDispenserBehavior(Item item2) {
            super(item2);
        }

        protected ActionResult<ItemStack> customBehavior(IBlockSource source, ItemStack stack) {
            BlockPos blockpos;
            ServerWorld world = source.func_197524_h();
            TileEntity te = world.func_175625_s(blockpos = source.func_180699_d().func_177972_a((Direction)source.func_189992_e().func_177229_b((Property)DispenserBlock.field_176441_a)));
            if (te instanceof JarBlockTile) {
                JarBlockTile tile = (JarBlockTile)te;
                if (tile.fluidHolder.isEmpty() && tile.func_191420_l() && tile.mobContainer.interactWithBucket(stack, (World)world, blockpos, null, null)) {
                    tile.func_70296_d();
                    return ActionResult.func_226248_a_((Object)new ItemStack((IItemProvider)Items.field_151133_ar));
                }
                return ActionResult.func_226251_d_((Object)stack);
            }
            return ActionResult.func_226250_c_((Object)stack);
        }
    }

    private static class PancakesDispenserBehavior
    extends DispenserHelper.AdditionalDispenserBehavior {
        protected PancakesDispenserBehavior(Item item2) {
            super(item2);
        }

        protected ActionResult<ItemStack> customBehavior(IBlockSource source, ItemStack stack) {
            BlockPos blockpos;
            ServerWorld world = source.func_197524_h();
            BlockState state = world.func_180495_p(blockpos = source.func_180699_d().func_177972_a((Direction)source.func_189992_e().func_177229_b((Property)DispenserBlock.field_176441_a)));
            Block block2 = state.func_177230_c();
            if (block2 instanceof PancakeBlock) {
                if (((ISoftFluidConsumer)block2).tryAcceptingFluid((World)world, state, blockpos, SoftFluidRegistry.HONEY, null, 1)) {
                    return ActionResult.func_226249_b_((Object)new ItemStack((IItemProvider)Items.field_151069_bo));
                }
                return ActionResult.func_226251_d_((Object)stack);
            }
            return ActionResult.func_226250_c_((Object)stack);
        }
    }

    private static class BambooSpikesDispenserBehavior
    extends DispenserHelper.AdditionalDispenserBehavior {
        protected BambooSpikesDispenserBehavior(Item item2) {
            super(item2);
        }

        protected ActionResult<ItemStack> customBehavior(IBlockSource source, ItemStack stack) {
            BlockPos blockpos;
            ServerWorld world = source.func_197524_h();
            BlockState state = world.func_180495_p(blockpos = source.func_180699_d().func_177972_a((Direction)source.func_189992_e().func_177229_b((Property)DispenserBlock.field_176441_a)));
            if (state.func_177230_c() instanceof BambooSpikesBlock) {
                if (BambooSpikesBlock.tryAddingPotion(state, (IWorld)world, blockpos, stack)) {
                    return ActionResult.func_226248_a_((Object)new ItemStack((IItemProvider)Items.field_151069_bo));
                }
                return ActionResult.func_226251_d_((Object)stack);
            }
            return ActionResult.func_226250_c_((Object)stack);
        }
    }

    private static class BombsDispenserBehavior
    extends ProjectileDispenseBehavior {
        private final boolean blue;

        public BombsDispenserBehavior(boolean blue) {
            this.blue = blue;
        }

        protected ProjectileEntity func_82499_a(World worldIn, IPosition position, ItemStack stackIn) {
            return new BombEntity(worldIn, position.func_82615_a(), position.func_82617_b(), position.func_82616_c(), this.blue);
        }

        protected float func_82498_a() {
            return 11.0f;
        }

        protected float func_82500_b() {
            return 1.3f;
        }
    }

    private static class ThrowableBricksDispenserBehavior
    extends DispenserHelper.AdditionalDispenserBehavior {
        protected ThrowableBricksDispenserBehavior(Item item2) {
            super(item2);
        }

        protected ActionResult<ItemStack> customBehavior(IBlockSource source, ItemStack stack) {
            ServerWorld world = source.func_197524_h();
            IPosition iposition = DispenserBlock.func_149939_a((IBlockSource)source);
            Direction direction = (Direction)source.func_189992_e().func_177229_b((Property)DispenserBlock.field_176441_a);
            ProjectileEntity projectileentity = this.getProjectileEntity((World)world, iposition, stack);
            projectileentity.func_70186_c((double)direction.func_82601_c(), (double)((float)direction.func_96559_d() + 0.1f), (double)direction.func_82599_e(), this.getProjectileVelocity(), this.getProjectileInaccuracy());
            world.func_217376_c((Entity)projectileentity);
            stack.func_190918_g(1);
            return ActionResult.func_226248_a_((Object)stack);
        }

        protected void playSound(IBlockSource source, boolean success) {
            source.func_197524_h().func_184148_a(null, source.func_82615_a() + 0.5, source.func_82617_b() + 0.5, source.func_82616_c() + 0.5, SoundEvents.field_187797_fA, SoundCategory.NEUTRAL, 0.5f, 0.4f / (source.func_197524_h().func_201674_k().nextFloat() * 0.4f + 0.8f));
        }

        protected ProjectileEntity getProjectileEntity(World worldIn, IPosition position, ItemStack stackIn) {
            return new ThrowableBrickEntity(worldIn, position.func_82615_a(), position.func_82617_b(), position.func_82616_c());
        }

        protected float getProjectileInaccuracy() {
            return 7.0f;
        }

        protected float getProjectileVelocity() {
            return 0.9f;
        }
    }

    private static class FlintAndSteelDispenserBehavior
    extends DispenserHelper.AdditionalDispenserBehavior {
        protected FlintAndSteelDispenserBehavior(Item item2) {
            super(item2);
        }

        protected ActionResult<ItemStack> customBehavior(IBlockSource source, ItemStack stack) {
            BlockPos blockpos;
            ServerWorld world = source.func_197524_h();
            BlockState state = world.func_180495_p(blockpos = source.func_180699_d().func_177972_a((Direction)source.func_189992_e().func_177229_b((Property)DispenserBlock.field_176441_a)));
            Block block2 = state.func_177230_c();
            if (block2 instanceof ILightable) {
                if (((ILightable)block2).lightUp(state, blockpos, (IWorld)world, ILightable.FireSound.FLINT_AND_STEEL)) {
                    if (stack.func_96631_a(1, world.field_73012_v, null)) {
                        stack.func_190920_e(0);
                    }
                    return ActionResult.func_226248_a_((Object)stack);
                }
                return ActionResult.func_226251_d_((Object)stack);
            }
            return ActionResult.func_226250_c_((Object)stack);
        }
    }
}

