/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.util;

import cofh.core.item.BlockItemCoFH;
import cofh.core.item.BlockNamedItemCoFH;
import cofh.core.item.CoinItem;
import cofh.core.item.CountedItem;
import cofh.core.item.ItemCoFH;
import cofh.lib.block.impl.crops.CropsBlockCoFH;
import cofh.lib.block.impl.crops.CropsBlockPerennial;
import cofh.lib.block.impl.crops.CropsBlockTall;
import cofh.lib.util.constants.Constants;
import cofh.thermal.core.ThermalCore;
import cofh.thermal.lib.common.ThermalFlags;
import cofh.thermal.lib.common.ThermalItemGroups;
import cofh.thermal.lib.item.BlockItemAugmentable;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.BooleanSupplier;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.PressurePlateBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.SoundType;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.TrapDoorBlock;
import net.minecraft.block.WoodButtonBlock;
import net.minecraft.block.material.Material;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Rarity;
import net.minecraftforge.fml.RegistryObject;

public class RegistrationHelper {
    public static void registerBlock(String name, Supplier<Block> sup) {
        RegistrationHelper.registerBlock(name, sup, "thermal");
    }

    public static void registerBlock(String name, Supplier<Block> sup, BooleanSupplier showInGroups) {
        RegistrationHelper.registerBlock(name, sup, showInGroups, "thermal");
    }

    public static void registerBlock(String name, Supplier<Block> sup, ItemGroup group, BooleanSupplier showInGroups) {
        RegistrationHelper.registerBlock(name, sup, group, showInGroups, "thermal");
    }

    public static void registerBlock(String name, Supplier<Block> sup, Rarity rarity) {
        RegistrationHelper.registerBlock(name, sup, rarity, "thermal");
    }

    public static void registerBlock(String name, Supplier<Block> sup, Rarity rarity, BooleanSupplier showInGroups) {
        RegistrationHelper.registerBlock(name, sup, rarity, showInGroups, "thermal");
    }

    public static void registerBlock(String name, Supplier<Block> sup, ItemGroup group, Rarity rarity, BooleanSupplier showInGroups) {
        RegistrationHelper.registerBlock(name, sup, group, rarity, showInGroups, "thermal");
    }

    public static void registerBlock(String name, Supplier<Block> sup, String modId) {
        RegistrationHelper.registerBlock(name, sup, ThermalItemGroups.THERMAL_BLOCKS, Rarity.COMMON, Constants.TRUE, modId);
    }

    public static void registerBlock(String name, Supplier<Block> sup, ItemGroup group, String modId) {
        RegistrationHelper.registerBlock(name, sup, group, Rarity.COMMON, Constants.TRUE, modId);
    }

    public static void registerBlock(String name, Supplier<Block> sup, BooleanSupplier showInGroups, String modId) {
        RegistrationHelper.registerBlock(name, sup, ThermalItemGroups.THERMAL_BLOCKS, Rarity.COMMON, showInGroups, modId);
    }

    public static void registerBlock(String name, Supplier<Block> sup, ItemGroup group, BooleanSupplier showInGroups, String modId) {
        RegistrationHelper.registerBlock(name, sup, group, Rarity.COMMON, showInGroups, modId);
    }

    public static void registerBlock(String name, Supplier<Block> sup, Rarity rarity, String modId) {
        RegistrationHelper.registerBlock(name, sup, ThermalItemGroups.THERMAL_BLOCKS, rarity, Constants.TRUE, modId);
    }

    public static void registerBlock(String name, Supplier<Block> sup, ItemGroup group, Rarity rarity, String modId) {
        RegistrationHelper.registerBlock(name, sup, group, rarity, Constants.TRUE, modId);
    }

    public static void registerBlock(String name, Supplier<Block> sup, Rarity rarity, BooleanSupplier showInGroups, String modId) {
        RegistrationHelper.registerBlock(name, sup, ThermalItemGroups.THERMAL_BLOCKS, rarity, showInGroups, modId);
    }

    public static void registerBlock(String name, Supplier<Block> sup, ItemGroup group, Rarity rarity, BooleanSupplier showInGroups, String modId) {
        RegistrationHelper.registerBlockAndItem(name, sup, () -> new BlockItemCoFH((Block)ThermalCore.BLOCKS.get(name), new Item.Properties().func_200916_a(group).func_208103_a(rarity)).setShowInGroups(showInGroups).setModId(modId));
    }

    public static void registerBlockOnly(String name, Supplier<Block> sup) {
        ThermalCore.BLOCKS.register(name, sup);
    }

    public static void registerBlockAndItem(String name, Supplier<Block> blockSup, Supplier<Item> itemSup) {
        ThermalCore.BLOCKS.register(name, blockSup);
        ThermalCore.ITEMS.register(name, itemSup);
    }

    public static void registerAugmentableBlock(String name, Supplier<Block> sup, IntSupplier numSlots, BiPredicate<ItemStack, List<ItemStack>> validAugment, BooleanSupplier showInGroups) {
        RegistrationHelper.registerAugmentableBlock(name, sup, numSlots, validAugment, showInGroups, "thermal");
    }

    public static void registerAugmentableBlock(String name, Supplier<Block> sup, IntSupplier numSlots, BiPredicate<ItemStack, List<ItemStack>> validAugment, String modId) {
        RegistrationHelper.registerAugmentableBlock(name, sup, numSlots, validAugment, ThermalItemGroups.THERMAL_DEVICES, Rarity.COMMON, Constants.TRUE, modId);
    }

    public static void registerAugmentableBlock(String name, Supplier<Block> sup, IntSupplier numSlots, BiPredicate<ItemStack, List<ItemStack>> validAugment, BooleanSupplier showInGroups, String modId) {
        RegistrationHelper.registerAugmentableBlock(name, sup, numSlots, validAugment, ThermalItemGroups.THERMAL_DEVICES, Rarity.COMMON, showInGroups, modId);
    }

    public static void registerAugmentableBlock(String name, Supplier<Block> sup, IntSupplier numSlots, BiPredicate<ItemStack, List<ItemStack>> validAugment, ItemGroup group, Rarity rarity, BooleanSupplier showInGroups, String modId) {
        ThermalCore.BLOCKS.register(name, sup);
        ThermalCore.ITEMS.register(name, () -> new BlockItemAugmentable((Block)ThermalCore.BLOCKS.get(name), new Item.Properties().func_200916_a(group).func_208103_a(rarity)).setNumSlots(numSlots).setAugValidator(validAugment).setShowInGroups(showInGroups).setModId(modId));
    }

    public static void registerWoodBlockSet(String woodName, Material material, MaterialColor color, float hardness, float resistance, SoundType soundType, String modId) {
        RegistrationHelper.registerBlock(woodName + "_planks", () -> new Block(AbstractBlock.Properties.func_200949_a((Material)material, (MaterialColor)color).func_200948_a(hardness, resistance).func_200947_a(soundType)), modId);
        RegistrationHelper.registerBlock(woodName + "_slab", () -> new SlabBlock(AbstractBlock.Properties.func_200949_a((Material)material, (MaterialColor)color).func_200948_a(hardness, resistance).func_200947_a(soundType)), modId);
        RegistrationHelper.registerBlock(woodName + "_stairs", () -> new StairsBlock(() -> ((Block)ThermalCore.BLOCKS.get(woodName + "_planks")).func_176223_P(), AbstractBlock.Properties.func_200949_a((Material)material, (MaterialColor)color).func_200948_a(hardness, resistance).func_200947_a(soundType)), modId);
        RegistrationHelper.registerBlock(woodName + "_door", () -> new DoorBlock(AbstractBlock.Properties.func_200949_a((Material)material, (MaterialColor)color).func_200943_b(resistance).func_200947_a(soundType).func_226896_b_()), modId);
        RegistrationHelper.registerBlock(woodName + "_trapdoor", () -> new TrapDoorBlock(AbstractBlock.Properties.func_200949_a((Material)material, (MaterialColor)color).func_200943_b(resistance).func_200947_a(soundType).func_226896_b_().func_235827_a_((state, reader, pos, entityType) -> false)), modId);
        RegistrationHelper.registerBlock(woodName + "_button", () -> new WoodButtonBlock(AbstractBlock.Properties.func_200945_a((Material)Material.field_151594_q).func_200942_a().func_200943_b(0.5f).func_200947_a(soundType)), modId);
        RegistrationHelper.registerBlock(woodName + "_pressure_plate", () -> new PressurePlateBlock(PressurePlateBlock.Sensitivity.EVERYTHING, AbstractBlock.Properties.func_200949_a((Material)material, (MaterialColor)color).func_200942_a().func_200943_b(0.5f).func_200947_a(soundType)), modId);
        RegistrationHelper.registerBlock(woodName + "_fence", () -> new FenceBlock(AbstractBlock.Properties.func_200949_a((Material)material, (MaterialColor)color).func_200948_a(hardness, resistance).func_200947_a(soundType)), modId);
        RegistrationHelper.registerBlock(woodName + "_fence_gate", () -> new FenceGateBlock(AbstractBlock.Properties.func_200949_a((Material)material, (MaterialColor)color).func_200948_a(hardness, resistance).func_200947_a(soundType)), modId);
    }

    public static RegistryObject<Item> registerItem(String name, Supplier<Item> sup) {
        return ThermalCore.ITEMS.register(name, sup);
    }

    public static RegistryObject<Item> registerItem(String name, ItemGroup group) {
        return RegistrationHelper.registerItem(name, group, Rarity.COMMON);
    }

    public static RegistryObject<Item> registerItem(String name, ItemGroup group, Rarity rarity) {
        return RegistrationHelper.registerItem(name, () -> new ItemCoFH(new Item.Properties().func_200916_a(group).func_208103_a(rarity)));
    }

    public static void registerMetalSet(String prefix, ItemGroup group, Rarity rarity) {
        RegistrationHelper.registerMetalSet(prefix, group, rarity, Constants.TRUE, false, false);
    }

    public static void registerMetalSet(String prefix, ItemGroup group, Rarity rarity, BooleanSupplier showInGroups) {
        RegistrationHelper.registerMetalSet(prefix, group, rarity, showInGroups, false, false);
    }

    public static void registerMetalSet(String prefix, ItemGroup group, BooleanSupplier showInGroups) {
        RegistrationHelper.registerMetalSet(prefix, group, Rarity.COMMON, showInGroups, false, false);
    }

    public static void registerAlloySet(String prefix, ItemGroup group, Rarity rarity) {
        RegistrationHelper.registerMetalSet(prefix, group, rarity, Constants.TRUE, false, true);
    }

    public static void registerAlloySet(String prefix, ItemGroup group, Rarity rarity, BooleanSupplier showInGroups) {
        RegistrationHelper.registerMetalSet(prefix, group, rarity, showInGroups, false, true);
    }

    public static void registerAlloySet(String prefix, ItemGroup group, BooleanSupplier showInGroups) {
        RegistrationHelper.registerMetalSet(prefix, group, Rarity.COMMON, showInGroups, false, true);
    }

    public static void registerVanillaMetalSet(String prefix, ItemGroup group) {
        RegistrationHelper.registerMetalSet(prefix, group, Rarity.COMMON, Constants.TRUE, true, false);
    }

    public static void registerMetalSet(String prefix, ItemGroup group, Rarity rarity, BooleanSupplier showInGroups, boolean vanilla, boolean alloy) {
        if (!vanilla) {
            ThermalCore.ITEMS.register(prefix + "_ingot", () -> new ItemCoFH(new Item.Properties().func_200916_a(group).func_208103_a(rarity)).setShowInGroups(showInGroups));
            ThermalCore.ITEMS.register(prefix + "_nugget", () -> new ItemCoFH(new Item.Properties().func_200916_a(group).func_208103_a(rarity)).setShowInGroups(showInGroups));
        }
        ThermalCore.ITEMS.register(prefix + "_dust", () -> new ItemCoFH(new Item.Properties().func_200916_a(group).func_208103_a(rarity)).setShowInGroups(showInGroups));
        ThermalCore.ITEMS.register(prefix + "_gear", () -> new ItemCoFH(new Item.Properties().func_200916_a(group).func_208103_a(rarity)).setShowInGroups(showInGroups));
        ThermalCore.ITEMS.register(prefix + "_plate", () -> new CountedItem(new Item.Properties().func_200916_a(group).func_208103_a(rarity)).setShowInGroups(() -> ThermalFlags.getFlag(ThermalFlags.FLAG_PLATES).getAsBoolean() && showInGroups.getAsBoolean()));
        ThermalCore.ITEMS.register(prefix + "_coin", () -> new CoinItem(new Item.Properties().func_200916_a(group).func_208103_a(rarity)).setShowInGroups(() -> ThermalFlags.getFlag(ThermalFlags.FLAG_COINS).getAsBoolean() && showInGroups.getAsBoolean()));
    }

    public static void registerGemSet(String prefix, ItemGroup group, Rarity rarity, BooleanSupplier showInGroups) {
        RegistrationHelper.registerGemSet(prefix, group, rarity, showInGroups, false);
    }

    public static void registerGemSet(String prefix, ItemGroup group, BooleanSupplier showInGroups) {
        RegistrationHelper.registerGemSet(prefix, group, Rarity.COMMON, showInGroups, false);
    }

    public static void registerVanillaGemSet(String prefix, ItemGroup group) {
        RegistrationHelper.registerGemSet(prefix, group, Rarity.COMMON, Constants.TRUE, true);
    }

    public static void registerGemSet(String prefix, ItemGroup group, Rarity rarity, BooleanSupplier showInGroups, boolean vanilla) {
        if (!vanilla) {
            ThermalCore.ITEMS.register(prefix, () -> new ItemCoFH(new Item.Properties().func_200916_a(group).func_208103_a(rarity)).setShowInGroups(showInGroups));
        }
        ThermalCore.ITEMS.register(prefix + "_dust", () -> new ItemCoFH(new Item.Properties().func_200916_a(group).func_208103_a(rarity)).setShowInGroups(showInGroups));
        ThermalCore.ITEMS.register(prefix + "_gear", () -> new ItemCoFH(new Item.Properties().func_200916_a(group).func_208103_a(rarity)).setShowInGroups(showInGroups));
    }

    public static void registerAnnual(String id) {
        ThermalCore.BLOCKS.register(id, () -> new CropsBlockCoFH(AbstractBlock.Properties.func_200945_a((Material)Material.field_151585_k).func_200942_a().func_200944_c().func_200948_a(0.0f, 0.0f).func_200947_a(SoundType.field_222472_s)).crop((Supplier)ThermalCore.ITEMS.getSup(id)).seed((Supplier)ThermalCore.ITEMS.getSup(RegistrationHelper.seeds(id))));
    }

    public static void registerTallAnnual(String id) {
        ThermalCore.BLOCKS.register(id, () -> new CropsBlockTall(AbstractBlock.Properties.func_200945_a((Material)Material.field_151585_k).func_200942_a().func_200944_c().func_200948_a(0.0f, 0.0f).func_200947_a(SoundType.field_222472_s)).crop((Supplier)ThermalCore.ITEMS.getSup(id)).seed((Supplier)ThermalCore.ITEMS.getSup(RegistrationHelper.seeds(id))));
    }

    public static void registerPerennial(String id) {
        RegistrationHelper.registerPerennial(id, 7);
    }

    public static void registerPerennial(String id, int postHarvestAge) {
        ThermalCore.BLOCKS.register(id, () -> new CropsBlockPerennial(AbstractBlock.Properties.func_200945_a((Material)Material.field_151585_k).func_200942_a().func_200944_c().func_200948_a(0.0f, 0.0f).func_200947_a(SoundType.field_222472_s)).postHarvestAge(postHarvestAge).crop((Supplier)ThermalCore.ITEMS.getSup(id)).seed((Supplier)ThermalCore.ITEMS.getSup(RegistrationHelper.seeds(id))));
    }

    public static void registerCropAndSeed(String id) {
        RegistrationHelper.registerCropAndSeed(id, ThermalItemGroups.THERMAL_FOODS);
    }

    public static void registerCropAndSeed(String id, Food food) {
        RegistrationHelper.registerCropAndSeed(id, ThermalItemGroups.THERMAL_FOODS, food);
    }

    public static void registerCropAndSeed(String id, ItemGroup group) {
        RegistrationHelper.registerCropAndSeed(id, group, null);
    }

    public static void registerCropAndSeed(String id, ItemGroup group, Food food) {
        if (food != null) {
            ThermalCore.ITEMS.register(id, () -> new ItemCoFH(new Item.Properties().func_200916_a(group).func_221540_a(food)).setModId("thermal_cultivation"));
        } else {
            ThermalCore.ITEMS.register(id, () -> new ItemCoFH(new Item.Properties().func_200916_a(group)).setModId("thermal_cultivation"));
        }
        ThermalCore.ITEMS.register(RegistrationHelper.seeds(id), () -> new BlockNamedItemCoFH((Block)ThermalCore.BLOCKS.get(id), new Item.Properties().func_200916_a(group)).setModId("thermal_cultivation"));
    }

    public static void registerSpores(String id) {
        RegistrationHelper.registerSpores(id, ThermalItemGroups.THERMAL_FOODS);
    }

    public static void registerSpores(String id, ItemGroup group) {
        ThermalCore.ITEMS.register(RegistrationHelper.spores(id), () -> new BlockNamedItemCoFH((Block)ThermalCore.BLOCKS.get(id), new Item.Properties().func_200916_a(group)).setModId("thermal_cultivation"));
    }

    public static String deepslate(String id) {
        return "deepslate_" + id;
    }

    public static String block(String id) {
        return id + "_block";
    }

    public static String seeds(String id) {
        return id + "_seeds";
    }

    public static String spores(String id) {
        return id + "_spores";
    }

    private static /* synthetic */ ItemCoFH lambda$registerMetalSet$14(ItemGroup group, Rarity rarity, BooleanSupplier showInGroups) {
        return new ItemCoFH(new Item.Properties().func_200916_a(group).func_208103_a(rarity)).setShowInGroups(showInGroups);
    }
}

