/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.renderer.model;

import com.google.common.collect.Lists;
import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.util.Pair;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.model.Variant;
import net.minecraft.client.renderer.model.WeightedBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class VariantList
implements IUnbakedModel {
    private final List<Variant> field_188115_a;

    public VariantList(List<Variant> p_i46568_1_) {
        this.field_188115_a = p_i46568_1_;
    }

    public List<Variant> func_188114_a() {
        return this.field_188115_a;
    }

    public boolean equals(Object p_equals_1_) {
        if (this == p_equals_1_) {
            return true;
        }
        if (p_equals_1_ instanceof VariantList) {
            VariantList variantlist = (VariantList)p_equals_1_;
            return this.field_188115_a.equals(variantlist.field_188115_a);
        }
        return false;
    }

    public int hashCode() {
        return this.field_188115_a.hashCode();
    }

    @Override
    public Collection<ResourceLocation> func_187965_e() {
        return this.func_188114_a().stream().map(Variant::func_188046_a).collect(Collectors.toSet());
    }

    @Override
    public Collection<RenderMaterial> func_225614_a_(Function<ResourceLocation, IUnbakedModel> p_225614_1_, Set<Pair<String, String>> p_225614_2_) {
        return this.func_188114_a().stream().map(Variant::func_188046_a).distinct().flatMap(p_228831_2_ -> ((IUnbakedModel)p_225614_1_.apply((ResourceLocation)p_228831_2_)).func_225614_a_(p_225614_1_, p_225614_2_).stream()).collect(Collectors.toSet());
    }

    @Override
    @Nullable
    public IBakedModel func_225613_a_(ModelBakery p_225613_1_, Function<RenderMaterial, TextureAtlasSprite> p_225613_2_, IModelTransform p_225613_3_, ResourceLocation p_225613_4_) {
        if (this.func_188114_a().isEmpty()) {
            return null;
        }
        WeightedBakedModel.Builder weightedbakedmodel$builder = new WeightedBakedModel.Builder();
        for (Variant variant : this.func_188114_a()) {
            IBakedModel ibakedmodel = p_225613_1_.getBakedModel(variant.func_188046_a(), (IModelTransform)variant, p_225613_2_);
            weightedbakedmodel$builder.func_177677_a(ibakedmodel, variant.func_188047_d());
        }
        return weightedbakedmodel$builder.func_209614_a();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Deserializer
    implements JsonDeserializer<VariantList> {
        public VariantList deserialize(JsonElement p_deserialize_1_, Type p_deserialize_2_, JsonDeserializationContext p_deserialize_3_) throws JsonParseException {
            ArrayList list = Lists.newArrayList();
            if (p_deserialize_1_.isJsonArray()) {
                JsonArray jsonarray = p_deserialize_1_.getAsJsonArray();
                if (jsonarray.size() == 0) {
                    throw new JsonParseException("Empty variant array");
                }
                for (JsonElement jsonelement : jsonarray) {
                    list.add(p_deserialize_3_.deserialize(jsonelement, Variant.class));
                }
            } else {
                list.add(p_deserialize_3_.deserialize(p_deserialize_1_, Variant.class));
            }
            return new VariantList(list);
        }
    }
}

