/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.entity.monster;

import com.mojang.serialization.DynamicOps;
import java.time.LocalDate;
import java.time.temporal.ChronoField;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.ai.goal.BreakBlockGoal;
import net.minecraft.entity.ai.goal.BreakDoorGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MoveThroughVillageGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.ai.goal.ZombieAttackGoal;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.ZombieVillagerEntity;
import net.minecraft.entity.monster.ZombifiedPiglinEntity;
import net.minecraft.entity.passive.ChickenEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.passive.TurtleEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.GroundPathHelper;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.GameRules;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.spawner.WorldEntitySpawner;
import net.minecraftforge.common.ForgeConfig;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.entity.living.ZombieEvent;
import net.minecraftforge.eventbus.api.Event;

public class ZombieEntity
extends MonsterEntity {
    private static final UUID field_110187_bq = UUID.fromString("B9766B59-9566-4402-BC1F-2EE2A276D836");
    private static final AttributeModifier field_110188_br = new AttributeModifier(field_110187_bq, "Baby speed boost", 0.5, AttributeModifier.Operation.MULTIPLY_BASE);
    private static final DataParameter<Boolean> field_184737_bv = EntityDataManager.func_187226_a(ZombieEntity.class, DataSerializers.field_187198_h);
    private static final DataParameter<Integer> field_184738_bw = EntityDataManager.func_187226_a(ZombieEntity.class, DataSerializers.field_187192_b);
    private static final DataParameter<Boolean> field_204709_bA = EntityDataManager.func_187226_a(ZombieEntity.class, DataSerializers.field_187198_h);
    private static final Predicate<Difficulty> field_213699_bC = p_213697_0_ -> p_213697_0_ == Difficulty.HARD;
    private final BreakDoorGoal field_146075_bs = new BreakDoorGoal((MobEntity)((Object)this), field_213699_bC);
    private boolean field_146076_bu;
    private int field_204707_bD;
    private int field_204708_bE;

    public ZombieEntity(EntityType<? extends ZombieEntity> p_i48549_1_, World p_i48549_2_) {
        super(p_i48549_1_, p_i48549_2_);
    }

    public ZombieEntity(World p_i1745_1_) {
        this(EntityType.field_200725_aD, p_i1745_1_);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(4, (Goal)new AttackTurtleEggGoal((CreatureEntity)this, 1.0, 3));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)((Object)this), PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)((Object)this)));
        this.func_175456_n();
    }

    protected void func_175456_n() {
        this.field_70714_bg.func_75776_a(2, (Goal)new ZombieAttackGoal(this, 1.0, false));
        this.field_70714_bg.func_75776_a(6, (Goal)new MoveThroughVillageGoal((CreatureEntity)this, 1.0, true, 4, this::func_146072_bX));
        this.field_70714_bg.func_75776_a(7, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]).func_220794_a(new Class[]{ZombifiedPiglinEntity.class}));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)((Object)this), PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)((Object)this), AbstractVillagerEntity.class, false));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)((Object)this), IronGolemEntity.class, true));
        this.field_70715_bh.func_75776_a(5, (Goal)new NearestAttackableTargetGoal((MobEntity)((Object)this), TurtleEntity.class, 10, true, false, TurtleEntity.field_203029_bx));
    }

    public static AttributeModifierMap.MutableAttribute func_234342_eQ_() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233819_b_, 35.0).func_233815_a_(Attributes.field_233821_d_, 0.23f).func_233815_a_(Attributes.field_233823_f_, 3.0).func_233815_a_(Attributes.field_233826_i_, 2.0).func_233814_a_(Attributes.field_233829_l_);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(field_184737_bv, false);
        this.func_184212_Q().func_187214_a(field_184738_bw, 0);
        this.func_184212_Q().func_187214_a(field_204709_bA, false);
    }

    public boolean func_204706_dD() {
        return this.func_184212_Q().func_187225_a(field_204709_bA);
    }

    public boolean func_146072_bX() {
        return this.field_146076_bu;
    }

    public void func_146070_a(boolean p_146070_1_) {
        if (this.func_204900_dz() && GroundPathHelper.func_242319_a((MobEntity)((Object)this))) {
            if (this.field_146076_bu != p_146070_1_) {
                this.field_146076_bu = p_146070_1_;
                ((GroundPathNavigator)this.func_70661_as()).func_179688_b(p_146070_1_);
                if (p_146070_1_) {
                    this.field_70714_bg.func_75776_a(1, (Goal)this.field_146075_bs);
                } else {
                    this.field_70714_bg.func_85156_a((Goal)this.field_146075_bs);
                }
            }
        } else if (this.field_146076_bu) {
            this.field_70714_bg.func_85156_a((Goal)this.field_146075_bs);
            this.field_146076_bu = false;
        }
    }

    protected boolean func_204900_dz() {
        return true;
    }

    public boolean func_70631_g_() {
        return this.func_184212_Q().func_187225_a(field_184737_bv);
    }

    protected int func_70693_a(PlayerEntity p_70693_1_) {
        if (this.func_70631_g_()) {
            this.field_70728_aV = (int)((float)this.field_70728_aV * 2.5f);
        }
        return super.func_70693_a(p_70693_1_);
    }

    public void func_82227_f(boolean p_82227_1_) {
        this.func_184212_Q().func_187227_b(field_184737_bv, p_82227_1_);
        if (this.field_70170_p != null && !this.field_70170_p.field_72995_K) {
            ModifiableAttributeInstance modifiableattributeinstance = this.func_110148_a(Attributes.field_233821_d_);
            modifiableattributeinstance.func_111124_b(field_110188_br);
            if (p_82227_1_) {
                modifiableattributeinstance.func_233767_b_(field_110188_br);
            }
        }
    }

    public void func_184206_a(DataParameter<?> p_184206_1_) {
        if (field_184737_bv.equals(p_184206_1_)) {
            this.func_213323_x_();
        }
        super.func_184206_a(p_184206_1_);
    }

    protected boolean func_204703_dA() {
        return true;
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K && this.func_70089_S() && !this.func_175446_cd()) {
            if (this.func_204706_dD()) {
                --this.field_204708_bE;
                if (this.field_204708_bE < 0 && ForgeEventFactory.canLivingConvert((LivingEntity)((Object)this), EntityType.field_200725_aD, timer -> {
                    this.field_204708_bE = timer;
                })) {
                    this.func_207302_dI();
                }
            } else if (this.func_204703_dA()) {
                if (this.func_208600_a(FluidTags.field_206959_a)) {
                    ++this.field_204707_bD;
                    if (this.field_204707_bD >= 600) {
                        this.func_204704_a(300);
                    }
                } else {
                    this.field_204707_bD = -1;
                }
            }
        }
        super.func_70071_h_();
    }

    public void func_70636_d() {
        if (this.func_70089_S()) {
            boolean flag;
            boolean bl = flag = this.func_190730_o() && this.func_204609_dp();
            if (flag) {
                ItemStack itemstack = this.func_184582_a(EquipmentSlotType.HEAD);
                if (!itemstack.func_190926_b()) {
                    if (itemstack.func_77984_f()) {
                        itemstack.func_196085_b(itemstack.func_77952_i() + this.field_70146_Z.nextInt(2));
                        if (itemstack.func_77952_i() >= itemstack.func_77958_k()) {
                            this.func_213361_c(EquipmentSlotType.HEAD);
                            this.func_184201_a(EquipmentSlotType.HEAD, ItemStack.field_190927_a);
                        }
                    }
                    flag = false;
                }
                if (flag) {
                    this.func_70015_d(8);
                }
            }
        }
        super.func_70636_d();
    }

    private void func_204704_a(int p_204704_1_) {
        this.field_204708_bE = p_204704_1_;
        this.func_184212_Q().func_187227_b(field_204709_bA, true);
    }

    protected void func_207302_dI() {
        this.func_234341_c_(EntityType.field_204724_o);
        if (!this.func_174814_R()) {
            this.field_70170_p.func_217378_a(null, 1040, this.func_233580_cy_(), 0);
        }
    }

    protected void func_234341_c_(EntityType<? extends ZombieEntity> p_234341_1_) {
        ZombieEntity zombieentity = (ZombieEntity)((Object)this.func_233656_b_(p_234341_1_, true));
        if (zombieentity != null) {
            zombieentity.func_207304_a(zombieentity.field_70170_p.func_175649_E(zombieentity.func_233580_cy_()).func_180170_c());
            zombieentity.func_146070_a(zombieentity.func_204900_dz() && this.func_146072_bX());
            ForgeEventFactory.onLivingConvert((LivingEntity)((Object)this), (LivingEntity)((Object)zombieentity));
        }
    }

    protected boolean func_190730_o() {
        return true;
    }

    public boolean func_70097_a(DamageSource p_70097_1_, float p_70097_2_) {
        int k;
        int j;
        int i;
        ZombieEvent.SummonAidEvent event;
        if (!super.func_70097_a(p_70097_1_, p_70097_2_)) {
            return false;
        }
        if (!(this.field_70170_p instanceof ServerWorld)) {
            return false;
        }
        ServerWorld serverworld = (ServerWorld)this.field_70170_p;
        LivingEntity livingentity = this.func_70638_az();
        if (livingentity == null && p_70097_1_.func_76346_g() instanceof LivingEntity) {
            livingentity = (LivingEntity)p_70097_1_.func_76346_g();
        }
        if ((event = ForgeEventFactory.fireZombieSummonAid((ZombieEntity)this, (World)this.field_70170_p, (int)(i = MathHelper.func_76128_c((double)this.func_226277_ct_())), (int)(j = MathHelper.func_76128_c((double)this.func_226278_cu_())), (int)(k = MathHelper.func_76128_c((double)this.func_226281_cx_())), (LivingEntity)livingentity, (double)this.func_110148_a(Attributes.field_233829_l_).func_111126_e())).getResult() == Event.Result.DENY) {
            return true;
        }
        if (event.getResult() == Event.Result.ALLOW || livingentity != null && this.field_70170_p.func_175659_aa() == Difficulty.HARD && (double)this.field_70146_Z.nextFloat() < this.func_110148_a(Attributes.field_233829_l_).func_111126_e() && this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223601_d)) {
            ZombieEntity zombieentity = event.getCustomSummonedAid() != null && event.getResult() == Event.Result.ALLOW ? event.getCustomSummonedAid() : EntityType.field_200725_aD.func_200721_a(this.field_70170_p);
            for (int l = 0; l < 50; ++l) {
                int i1 = i + MathHelper.func_76136_a((Random)this.field_70146_Z, (int)7, (int)40) * MathHelper.func_76136_a((Random)this.field_70146_Z, (int)-1, (int)1);
                int j1 = j + MathHelper.func_76136_a((Random)this.field_70146_Z, (int)7, (int)40) * MathHelper.func_76136_a((Random)this.field_70146_Z, (int)-1, (int)1);
                int k1 = k + MathHelper.func_76136_a((Random)this.field_70146_Z, (int)7, (int)40) * MathHelper.func_76136_a((Random)this.field_70146_Z, (int)-1, (int)1);
                BlockPos blockpos = new BlockPos(i1, j1, k1);
                EntityType entitytype = zombieentity.func_200600_R();
                EntitySpawnPlacementRegistry.PlacementType entityspawnplacementregistry$placementtype = EntitySpawnPlacementRegistry.func_209344_a(entitytype);
                if (!WorldEntitySpawner.func_209382_a(entityspawnplacementregistry$placementtype, (IWorldReader)((Object)this.field_70170_p), blockpos, entitytype) || !EntitySpawnPlacementRegistry.func_223515_a(entitytype, (IServerWorld)serverworld, SpawnReason.REINFORCEMENT, blockpos, this.field_70170_p.field_73012_v)) continue;
                zombieentity.func_70107_b(i1, j1, k1);
                if (this.field_70170_p.func_217358_a(i1, j1, k1, 7.0) || !this.field_70170_p.func_226668_i_((Entity)((Object)zombieentity)) || !this.field_70170_p.func_226669_j_((Entity)((Object)zombieentity)) || this.field_70170_p.func_72953_d(zombieentity.func_174813_aQ())) continue;
                if (livingentity != null) {
                    zombieentity.func_70624_b(livingentity);
                }
                zombieentity.func_213386_a((IServerWorld)serverworld, this.field_70170_p.func_175649_E(zombieentity.func_233580_cy_()), SpawnReason.REINFORCEMENT, null, null);
                serverworld.func_242417_l((Entity)((Object)zombieentity));
                this.func_110148_a(Attributes.field_233829_l_).func_233769_c_(new AttributeModifier("Zombie reinforcement caller charge", (double)-0.05f, AttributeModifier.Operation.ADDITION));
                zombieentity.func_110148_a(Attributes.field_233829_l_).func_233769_c_(new AttributeModifier("Zombie reinforcement callee charge", (double)-0.05f, AttributeModifier.Operation.ADDITION));
                break;
            }
        }
        return true;
    }

    public boolean func_70652_k(Entity p_70652_1_) {
        boolean flag = super.func_70652_k(p_70652_1_);
        if (flag) {
            float f = this.field_70170_p.func_175649_E(this.func_233580_cy_()).func_180168_b();
            if (this.func_184614_ca().func_190926_b() && this.func_70027_ad() && this.field_70146_Z.nextFloat() < f * 0.3f) {
                p_70652_1_.func_70015_d(2 * (int)f);
            }
        }
        return flag;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187899_gZ;
    }

    protected SoundEvent func_184601_bQ(DamageSource p_184601_1_) {
        return SoundEvents.field_187934_hh;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187930_hd;
    }

    protected SoundEvent func_190731_di() {
        return SoundEvents.field_187939_hm;
    }

    protected void func_180429_a(BlockPos p_180429_1_, BlockState p_180429_2_) {
        this.func_184185_a(this.func_190731_di(), 0.15f, 1.0f);
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223223_b_;
    }

    protected void func_180481_a(DifficultyInstance p_180481_1_) {
        super.func_180481_a(p_180481_1_);
        float f = this.field_70146_Z.nextFloat();
        float f2 = this.field_70170_p.func_175659_aa() == Difficulty.HARD ? 0.05f : 0.01f;
        if (f < f2) {
            int i = this.field_70146_Z.nextInt(3);
            if (i == 0) {
                this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack(Items.field_151040_l));
            } else {
                this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack(Items.field_151037_a));
            }
        }
    }

    public void func_213281_b(CompoundNBT p_213281_1_) {
        super.func_213281_b(p_213281_1_);
        p_213281_1_.func_74757_a("IsBaby", this.func_70631_g_());
        p_213281_1_.func_74757_a("CanBreakDoors", this.func_146072_bX());
        p_213281_1_.func_74768_a("InWaterTime", this.func_70090_H() ? this.field_204707_bD : -1);
        p_213281_1_.func_74768_a("DrownedConversionTime", this.func_204706_dD() ? this.field_204708_bE : -1);
    }

    public void func_70037_a(CompoundNBT p_70037_1_) {
        super.func_70037_a(p_70037_1_);
        this.func_82227_f(p_70037_1_.func_74767_n("IsBaby"));
        this.func_146070_a(p_70037_1_.func_74767_n("CanBreakDoors"));
        this.field_204707_bD = p_70037_1_.func_74762_e("InWaterTime");
        if (p_70037_1_.func_150297_b("DrownedConversionTime", 99) && p_70037_1_.func_74762_e("DrownedConversionTime") > -1) {
            this.func_204704_a(p_70037_1_.func_74762_e("DrownedConversionTime"));
        }
    }

    public void func_241847_a(ServerWorld p_241847_1_, LivingEntity p_241847_2_) {
        super.func_241847_a(p_241847_1_, p_241847_2_);
        if ((p_241847_1_.func_175659_aa() == Difficulty.NORMAL || p_241847_1_.func_175659_aa() == Difficulty.HARD) && p_241847_2_ instanceof VillagerEntity && ForgeEventFactory.canLivingConvert((LivingEntity)p_241847_2_, EntityType.field_200727_aF, timer -> {})) {
            if (p_241847_1_.func_175659_aa() != Difficulty.HARD && this.field_70146_Z.nextBoolean()) {
                return;
            }
            VillagerEntity villagerentity = (VillagerEntity)((Object)p_241847_2_);
            ZombieVillagerEntity zombievillagerentity = (ZombieVillagerEntity)((Object)villagerentity.func_233656_b_(EntityType.field_200727_aF, false));
            zombievillagerentity.func_213386_a((IServerWorld)p_241847_1_, p_241847_1_.func_175649_E(zombievillagerentity.func_233580_cy_()), SpawnReason.CONVERSION, new GroupData(false, true), null);
            zombievillagerentity.func_213792_a(villagerentity.func_213700_eh());
            zombievillagerentity.func_223727_a((INBT)villagerentity.func_223722_es().func_234058_a_((DynamicOps)NBTDynamicOps.field_210820_a).getValue());
            zombievillagerentity.func_213790_g(villagerentity.func_213706_dY().func_222199_a());
            zombievillagerentity.func_213789_a(villagerentity.func_213708_dV());
            ForgeEventFactory.onLivingConvert((LivingEntity)p_241847_2_, (LivingEntity)((Object)zombievillagerentity));
            if (!this.func_174814_R()) {
                p_241847_1_.func_217378_a(null, 1026, this.func_233580_cy_(), 0);
            }
        }
    }

    protected float func_213348_b(Pose p_213348_1_, EntitySize p_213348_2_) {
        return this.func_70631_g_() ? 0.93f : 1.74f;
    }

    public boolean func_175448_a(ItemStack p_175448_1_) {
        return p_175448_1_.func_77973_b() == Items.field_151110_aK && this.func_70631_g_() && this.func_184218_aH() ? false : super.func_175448_a(p_175448_1_);
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld p_213386_1_, DifficultyInstance p_213386_2_, SpawnReason p_213386_3_, @Nullable ILivingEntityData p_213386_4_, @Nullable CompoundNBT p_213386_5_) {
        p_213386_4_ = super.func_213386_a(p_213386_1_, p_213386_2_, p_213386_3_, p_213386_4_, p_213386_5_);
        float f = p_213386_2_.func_180170_c();
        this.func_98053_h(this.field_70146_Z.nextFloat() < 0.55f * f);
        if (p_213386_4_ == null) {
            p_213386_4_ = new GroupData(ZombieEntity.func_241399_a_(p_213386_1_.func_201674_k()), true);
        }
        if (p_213386_4_ instanceof GroupData) {
            GroupData zombieentity$groupdata = (GroupData)p_213386_4_;
            if (zombieentity$groupdata.field_142048_a) {
                this.func_82227_f(true);
                if (zombieentity$groupdata.field_241400_b_) {
                    if ((double)p_213386_1_.func_201674_k().nextFloat() < 0.05) {
                        List list = p_213386_1_.func_175647_a(ChickenEntity.class, this.func_174813_aQ().func_72314_b(5.0, 3.0, 5.0), EntityPredicates.field_152785_b);
                        if (!list.isEmpty()) {
                            ChickenEntity chickenentity = (ChickenEntity)list.get(0);
                            chickenentity.func_152117_i(true);
                            this.func_184220_m((Entity)chickenentity);
                        }
                    } else if ((double)p_213386_1_.func_201674_k().nextFloat() < 0.05) {
                        ChickenEntity chickenentity1 = EntityType.field_200795_i.func_200721_a(this.field_70170_p);
                        chickenentity1.func_70012_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.field_70177_z, 0.0f);
                        chickenentity1.func_213386_a(p_213386_1_, p_213386_2_, SpawnReason.JOCKEY, (ILivingEntityData)null, (CompoundNBT)null);
                        chickenentity1.func_152117_i(true);
                        this.func_184220_m((Entity)chickenentity1);
                        p_213386_1_.func_217376_c((Entity)chickenentity1);
                    }
                }
            }
            this.func_146070_a(this.func_204900_dz() && this.field_70146_Z.nextFloat() < f * 0.1f);
            this.func_180481_a(p_213386_2_);
            this.func_180483_b(p_213386_2_);
        }
        if (this.func_184582_a(EquipmentSlotType.HEAD).func_190926_b()) {
            LocalDate localdate = LocalDate.now();
            int i = localdate.get(ChronoField.DAY_OF_MONTH);
            int j = localdate.get(ChronoField.MONTH_OF_YEAR);
            if (j == 10 && i == 31 && this.field_70146_Z.nextFloat() < 0.25f) {
                this.func_184201_a(EquipmentSlotType.HEAD, new ItemStack(this.field_70146_Z.nextFloat() < 0.1f ? Blocks.field_196628_cT : Blocks.field_196625_cS));
                this.field_184655_bs[EquipmentSlotType.HEAD.func_188454_b()] = 0.0f;
            }
        }
        this.func_207304_a(f);
        return p_213386_4_;
    }

    public static boolean func_241399_a_(Random p_241399_0_) {
        return (double)p_241399_0_.nextFloat() < (Double)ForgeConfig.SERVER.zombieBabyChance.get();
    }

    protected void func_207304_a(float p_207304_1_) {
        this.func_230291_eT_();
        this.func_110148_a(Attributes.field_233820_c_).func_233769_c_(new AttributeModifier("Random spawn bonus", this.field_70146_Z.nextDouble() * (double)0.05f, AttributeModifier.Operation.ADDITION));
        double d0 = this.field_70146_Z.nextDouble() * 1.5 * (double)p_207304_1_;
        if (d0 > 1.0) {
            this.func_110148_a(Attributes.field_233819_b_).func_233769_c_(new AttributeModifier("Random zombie-spawn bonus", d0, AttributeModifier.Operation.MULTIPLY_TOTAL));
        }
        if (this.field_70146_Z.nextFloat() < p_207304_1_ * 0.05f) {
            this.func_110148_a(Attributes.field_233829_l_).func_233769_c_(new AttributeModifier("Leader zombie bonus", this.field_70146_Z.nextDouble() * 0.25 + 0.5, AttributeModifier.Operation.ADDITION));
            this.func_110148_a(Attributes.field_233818_a_).func_233769_c_(new AttributeModifier("Leader zombie bonus", this.field_70146_Z.nextDouble() * 3.0 + 1.0, AttributeModifier.Operation.MULTIPLY_TOTAL));
            this.func_146070_a(this.func_204900_dz());
        }
    }

    protected void func_230291_eT_() {
        this.func_110148_a(Attributes.field_233829_l_).func_111128_a(this.field_70146_Z.nextDouble() * (Double)ForgeConfig.SERVER.zombieBaseSummonChance.get());
    }

    public double func_70033_W() {
        return this.func_70631_g_() ? 0.0 : -0.45;
    }

    protected void func_213333_a(DamageSource p_213333_1_, int p_213333_2_, boolean p_213333_3_) {
        ItemStack itemstack;
        CreeperEntity creeperentity;
        super.func_213333_a(p_213333_1_, p_213333_2_, p_213333_3_);
        Entity entity = p_213333_1_.func_76346_g();
        if (entity instanceof CreeperEntity && (creeperentity = (CreeperEntity)((Object)entity)).func_70650_aV() && !(itemstack = this.func_190732_dj()).func_190926_b()) {
            creeperentity.func_175493_co();
            this.func_199701_a_(itemstack);
        }
    }

    protected ItemStack func_190732_dj() {
        return new ItemStack(Items.field_196186_dz);
    }

    public static class GroupData
    implements ILivingEntityData {
        public final boolean field_142048_a;
        public final boolean field_241400_b_;

        public GroupData(boolean p_i231567_1_, boolean p_i231567_2_) {
            this.field_142048_a = p_i231567_1_;
            this.field_241400_b_ = p_i231567_2_;
        }
    }

    class AttackTurtleEggGoal
    extends BreakBlockGoal {
        AttackTurtleEggGoal(CreatureEntity p_i50465_2_, double p_i50465_3_, int p_i50465_5_) {
            super(Blocks.field_203213_jA, p_i50465_2_, p_i50465_3_, p_i50465_5_);
        }

        @Override
        public void func_203114_b(IWorld p_203114_1_, BlockPos p_203114_2_) {
            p_203114_1_.func_184133_a((PlayerEntity)null, p_203114_2_, SoundEvents.field_203276_jU, SoundCategory.HOSTILE, 0.5f, 0.9f + ZombieEntity.this.field_70146_Z.nextFloat() * 0.2f);
        }

        @Override
        public void func_203116_c(World p_203116_1_, BlockPos p_203116_2_) {
            p_203116_1_.func_184133_a(null, p_203116_2_, SoundEvents.field_203281_iz, SoundCategory.BLOCKS, 0.7f, 0.9f + p_203116_1_.field_73012_v.nextFloat() * 0.2f);
        }

        public double func_203110_f() {
            return 1.14;
        }
    }
}

