/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.lang.reflect.Type;
import javax.annotation.Nullable;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocationException;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.StringUtils;

public class ResourceLocation
implements Comparable<ResourceLocation> {
    public static final Codec<ResourceLocation> field_240908_a_ = Codec.STRING.comapFlatMap(ResourceLocation::func_240911_c_, ResourceLocation::toString).stable();
    private static final SimpleCommandExceptionType field_200118_c = new SimpleCommandExceptionType((Message)new TranslationTextComponent("argument.id.invalid"));
    protected final String field_110626_a;
    protected final String field_110625_b;

    protected ResourceLocation(String[] p_i47923_1_) {
        this.field_110626_a = StringUtils.isEmpty((CharSequence)p_i47923_1_[0]) ? "minecraft" : p_i47923_1_[0];
        this.field_110625_b = p_i47923_1_[1];
        if (!ResourceLocation.func_217858_d(this.field_110626_a)) {
            throw new ResourceLocationException("Non [a-z0-9_.-] character in namespace of location: " + this.field_110626_a + ':' + this.field_110625_b);
        }
        if (!ResourceLocation.func_217856_c(this.field_110625_b)) {
            throw new ResourceLocationException("Non [a-z0-9/._-] character in path of location: " + this.field_110626_a + ':' + this.field_110625_b);
        }
    }

    public ResourceLocation(String p_i1293_1_) {
        this(ResourceLocation.func_195823_b(p_i1293_1_, ':'));
    }

    public ResourceLocation(String p_i1292_1_, String p_i1292_2_) {
        this(new String[]{p_i1292_1_, p_i1292_2_});
    }

    public static ResourceLocation func_195828_a(String p_195828_0_, char p_195828_1_) {
        return new ResourceLocation(ResourceLocation.func_195823_b(p_195828_0_, p_195828_1_));
    }

    @Nullable
    public static ResourceLocation func_208304_a(String p_208304_0_) {
        try {
            return new ResourceLocation(p_208304_0_);
        }
        catch (ResourceLocationException resourcelocationexception) {
            return null;
        }
    }

    protected static String[] func_195823_b(String p_195823_0_, char p_195823_1_) {
        String[] astring = new String[]{"minecraft", p_195823_0_};
        int i = p_195823_0_.indexOf(p_195823_1_);
        if (i >= 0) {
            astring[1] = p_195823_0_.substring(i + 1, p_195823_0_.length());
            if (i >= 1) {
                astring[0] = p_195823_0_.substring(0, i);
            }
        }
        return astring;
    }

    private static DataResult<ResourceLocation> func_240911_c_(String p_240911_0_) {
        try {
            return DataResult.success((Object)new ResourceLocation(p_240911_0_));
        }
        catch (ResourceLocationException resourcelocationexception) {
            return DataResult.error((String)("Not a valid resource location: " + p_240911_0_ + " " + resourcelocationexception.getMessage()));
        }
    }

    public String func_110623_a() {
        return this.field_110625_b;
    }

    public String func_110624_b() {
        return this.field_110626_a;
    }

    public String toString() {
        return this.field_110626_a + ':' + this.field_110625_b;
    }

    public boolean equals(Object p_equals_1_) {
        if (this == p_equals_1_) {
            return true;
        }
        if (!(p_equals_1_ instanceof ResourceLocation)) {
            return false;
        }
        ResourceLocation resourcelocation = (ResourceLocation)p_equals_1_;
        return this.field_110626_a.equals(resourcelocation.field_110626_a) && this.field_110625_b.equals(resourcelocation.field_110625_b);
    }

    public int hashCode() {
        return 31 * this.field_110626_a.hashCode() + this.field_110625_b.hashCode();
    }

    @Override
    public int compareTo(ResourceLocation p_compareTo_1_) {
        int i = this.field_110625_b.compareTo(p_compareTo_1_.field_110625_b);
        if (i == 0) {
            i = this.field_110626_a.compareTo(p_compareTo_1_.field_110626_a);
        }
        return i;
    }

    public int compareNamespaced(ResourceLocation o) {
        int ret = this.field_110626_a.compareTo(o.field_110626_a);
        return ret != 0 ? ret : this.field_110625_b.compareTo(o.field_110625_b);
    }

    public static ResourceLocation func_195826_a(StringReader p_195826_0_) throws CommandSyntaxException {
        int i = p_195826_0_.getCursor();
        while (p_195826_0_.canRead() && ResourceLocation.func_195824_a(p_195826_0_.peek())) {
            p_195826_0_.skip();
        }
        String s = p_195826_0_.getString().substring(i, p_195826_0_.getCursor());
        try {
            return new ResourceLocation(s);
        }
        catch (ResourceLocationException resourcelocationexception) {
            p_195826_0_.setCursor(i);
            throw field_200118_c.createWithContext((ImmutableStringReader)p_195826_0_);
        }
    }

    public static boolean func_195824_a(char p_195824_0_) {
        return p_195824_0_ >= '0' && p_195824_0_ <= '9' || p_195824_0_ >= 'a' && p_195824_0_ <= 'z' || p_195824_0_ == '_' || p_195824_0_ == ':' || p_195824_0_ == '/' || p_195824_0_ == '.' || p_195824_0_ == '-';
    }

    private static boolean func_217856_c(String p_217856_0_) {
        for (int i = 0; i < p_217856_0_.length(); ++i) {
            if (ResourceLocation.func_240909_b_(p_217856_0_.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static boolean func_217858_d(String p_217858_0_) {
        for (int i = 0; i < p_217858_0_.length(); ++i) {
            if (ResourceLocation.func_240910_c_(p_217858_0_.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean func_240909_b_(char p_240909_0_) {
        return p_240909_0_ == '_' || p_240909_0_ == '-' || p_240909_0_ >= 'a' && p_240909_0_ <= 'z' || p_240909_0_ >= '0' && p_240909_0_ <= '9' || p_240909_0_ == '/' || p_240909_0_ == '.';
    }

    private static boolean func_240910_c_(char p_240910_0_) {
        return p_240910_0_ == '_' || p_240910_0_ == '-' || p_240910_0_ >= 'a' && p_240910_0_ <= 'z' || p_240910_0_ >= '0' && p_240910_0_ <= '9' || p_240910_0_ == '.';
    }

    @OnlyIn(value=Dist.CLIENT)
    public static boolean func_217855_b(String p_217855_0_) {
        String[] astring = ResourceLocation.func_195823_b(p_217855_0_, ':');
        return ResourceLocation.func_217858_d(StringUtils.isEmpty((CharSequence)astring[0]) ? "minecraft" : astring[0]) && ResourceLocation.func_217856_c(astring[1]);
    }

    public static class Serializer
    implements JsonDeserializer<ResourceLocation>,
    JsonSerializer<ResourceLocation> {
        public ResourceLocation deserialize(JsonElement p_deserialize_1_, Type p_deserialize_2_, JsonDeserializationContext p_deserialize_3_) throws JsonParseException {
            return new ResourceLocation(JSONUtils.func_151206_a((JsonElement)p_deserialize_1_, (String)"location"));
        }

        public JsonElement serialize(ResourceLocation p_serialize_1_, Type p_serialize_2_, JsonSerializationContext p_serialize_3_) {
            return new JsonPrimitive(p_serialize_1_.toString());
        }
    }
}

