/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.config;

import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public class CommonConfig {
    public final ForgeConfigSpec.DoubleValue lavaOpacity;
    public final ForgeConfigSpec.BooleanValue shadersCompat;
    public final ForgeConfigSpec.BooleanValue neutralBoneSerpents;
    public final ForgeConfigSpec.BooleanValue lavaBottleEnabled;
    public final ForgeConfigSpec.BooleanValue spidersAttackFlies;
    public final ForgeConfigSpec.BooleanValue wolvesAttackMoose;
    public final ForgeConfigSpec.BooleanValue polarBearsAttackSeals;
    public final ForgeConfigSpec.BooleanValue bananasDropFromLeaves;
    public final ForgeConfigSpec.IntValue bananaChance;
    public final ForgeConfigSpec.IntValue grizzlyBearSpawnWeight;
    public final ForgeConfigSpec.IntValue grizzlyBearSpawnRolls;
    public final ForgeConfigSpec.IntValue roadrunnerSpawnWeight;
    public final ForgeConfigSpec.IntValue roadrunnerSpawnRolls;
    public final ForgeConfigSpec.IntValue boneSerpentSpawnWeight;
    public final ForgeConfigSpec.IntValue boneSeprentSpawnRolls;
    public final ForgeConfigSpec.IntValue gazelleSpawnWeight;
    public final ForgeConfigSpec.IntValue gazelleSpawnRolls;
    public final ForgeConfigSpec.IntValue crocodileSpawnWeight;
    public final ForgeConfigSpec.IntValue crocSpawnRolls;
    public final ForgeConfigSpec.IntValue flySpawnWeight;
    public final ForgeConfigSpec.IntValue flySpawnRolls;
    public final ForgeConfigSpec.IntValue hummingbirdSpawnWeight;
    public final ForgeConfigSpec.IntValue hummingbirdSpawnRolls;
    public final ForgeConfigSpec.IntValue orcaSpawnWeight;
    public final ForgeConfigSpec.IntValue orcaSpawnRolls;
    public final ForgeConfigSpec.IntValue sunbirdSpawnWeight;
    public final ForgeConfigSpec.IntValue sunbirdSpawnRolls;
    public final ForgeConfigSpec.IntValue gorillaSpawnWeight;
    public final ForgeConfigSpec.IntValue gorillaSpawnRolls;
    public final ForgeConfigSpec.IntValue crimsonMosquitoSpawnWeight;
    public final ForgeConfigSpec.IntValue crimsonMosquitoSpawnRolls;
    public final ForgeConfigSpec.IntValue rattlesnakeSpawnWeight;
    public final ForgeConfigSpec.IntValue rattlesnakeSpawnRolls;
    public final ForgeConfigSpec.IntValue endergradeSpawnWeight;
    public final ForgeConfigSpec.IntValue endergradeSpawnRolls;
    public final ForgeConfigSpec.IntValue hammerheadSharkSpawnWeight;
    public final ForgeConfigSpec.IntValue hammerheadSharkSpawnRolls;
    public final ForgeConfigSpec.IntValue lobsterSpawnWeight;
    public final ForgeConfigSpec.IntValue lobsterSpawnRolls;
    public final ForgeConfigSpec.IntValue komodoDragonSpawnWeight;
    public final ForgeConfigSpec.IntValue komodoDragonSpawnRolls;
    public final ForgeConfigSpec.IntValue capuchinMonkeySpawnWeight;
    public final ForgeConfigSpec.IntValue capuchinMonkeySpawnRolls;
    public final ForgeConfigSpec.IntValue caveCentipedeSpawnWeight;
    public final ForgeConfigSpec.IntValue caveCentipedeSpawnRolls;
    public final ForgeConfigSpec.IntValue caveCentipedeSpawnHeight;
    public final ForgeConfigSpec.IntValue warpedToadSpawnWeight;
    public final ForgeConfigSpec.IntValue warpedToadSpawnRolls;
    public final ForgeConfigSpec.IntValue mooseSpawnWeight;
    public final ForgeConfigSpec.IntValue mooseSpawnRolls;
    public final ForgeConfigSpec.IntValue mimicubeSpawnWeight;
    public final ForgeConfigSpec.IntValue mimicubeSpawnRolls;
    public final ForgeConfigSpec.IntValue raccoonSpawnWeight;
    public final ForgeConfigSpec.IntValue raccoonSpawnRolls;
    public final ForgeConfigSpec.IntValue blobfishSpawnWeight;
    public final ForgeConfigSpec.IntValue blobfishSpawnRolls;
    public final ForgeConfigSpec.IntValue blobfishSpawnHeight;
    public final ForgeConfigSpec.IntValue sealSpawnWeight;
    public final ForgeConfigSpec.IntValue sealSpawnRolls;
    public final ForgeConfigSpec.IntValue cockroachSpawnWeight;
    public final ForgeConfigSpec.IntValue cockroachSpawnRolls;
    public final ForgeConfigSpec.IntValue shoebillSpawnWeight;
    public final ForgeConfigSpec.IntValue shoebillSpawnRolls;
    public final ForgeConfigSpec.IntValue elephantSpawnWeight;
    public final ForgeConfigSpec.IntValue elephantSpawnRolls;
    public final ForgeConfigSpec.IntValue soulVultureSpawnWeight;
    public final ForgeConfigSpec.IntValue soulVultureSpawnRolls;
    public final ForgeConfigSpec.IntValue snowLeopardSpawnWeight;
    public final ForgeConfigSpec.IntValue snowLeopardSpawnRolls;
    public final ForgeConfigSpec.IntValue spectreSpawnWeight;
    public final ForgeConfigSpec.IntValue spectreSpawnRolls;
    public final ForgeConfigSpec.IntValue crowSpawnWeight;
    public final ForgeConfigSpec.IntValue crowSpawnRolls;
    public final ForgeConfigSpec.IntValue alligatorSnappingTurtleSpawnWeight;
    public final ForgeConfigSpec.IntValue alligatorSnappingTurtleSpawnRolls;
    public final ForgeConfigSpec.IntValue mungusSpawnWeight;
    public final ForgeConfigSpec.IntValue mungusSpawnRolls;
    public final ForgeConfigSpec.IntValue mantisShrimpSpawnWeight;
    public final ForgeConfigSpec.IntValue mantisShrimpSpawnRolls;
    public final ForgeConfigSpec.IntValue gusterSpawnWeight;
    public final ForgeConfigSpec.IntValue gusterSpawnRolls;
    public final ForgeConfigSpec.IntValue warpedMoscoSpawnWeight;
    public final ForgeConfigSpec.IntValue warpedMoscoSpawnRolls;
    public final ForgeConfigSpec.IntValue straddlerSpawnWeight;
    public final ForgeConfigSpec.IntValue straddlerSpawnRolls;
    public final ForgeConfigSpec.IntValue stradpoleSpawnWeight;
    public final ForgeConfigSpec.IntValue stradpoleSpawnRolls;
    public final ForgeConfigSpec.IntValue emuSpawnWeight;
    public final ForgeConfigSpec.IntValue emuSpawnRolls;
    public final ForgeConfigSpec.IntValue platypusSpawnWeight;
    public final ForgeConfigSpec.IntValue platypusSpawnRolls;
    public final ForgeConfigSpec.IntValue dropbearSpawnWeight;
    public final ForgeConfigSpec.IntValue dropbearSpawnRolls;
    public final ForgeConfigSpec.IntValue tasmanianDevilSpawnWeight;
    public final ForgeConfigSpec.IntValue tasmanianDevilSpawnRolls;
    public final ForgeConfigSpec.IntValue kangarooSpawnWeight;
    public final ForgeConfigSpec.IntValue kangarooSpawnRolls;
    public final ForgeConfigSpec.IntValue cachalotWhaleSpawnWeight;
    public final ForgeConfigSpec.IntValue cachalotWhaleSpawnRolls;
    public final ForgeConfigSpec.IntValue enderiophageSpawnWeight;
    public final ForgeConfigSpec.IntValue enderiophageSpawnRolls;
    public final ForgeConfigSpec.IntValue baldEagleSpawnWeight;
    public final ForgeConfigSpec.IntValue baldEagleSpawnRolls;
    public final ForgeConfigSpec.IntValue tigerSpawnWeight;
    public final ForgeConfigSpec.IntValue tigerSpawnRolls;
    public final ForgeConfigSpec.IntValue tarantulaHawkSpawnWeight;
    public final ForgeConfigSpec.IntValue tarantulaHawkSpawnRolls;
    public final ForgeConfigSpec.IntValue voidWormSpawnWeight;
    public final ForgeConfigSpec.IntValue voidWormSpawnRolls;
    public final ForgeConfigSpec.IntValue frilledSharkSpawnWeight;
    public final ForgeConfigSpec.IntValue frilledSharkSpawnRolls;
    public final ForgeConfigSpec.IntValue mimicOctopusSpawnWeight;
    public final ForgeConfigSpec.IntValue mimicOctopusSpawnRolls;
    public final ForgeConfigSpec.IntValue seagullSpawnWeight;
    public final ForgeConfigSpec.IntValue seagullSpawnRolls;
    public final ForgeConfigSpec.BooleanValue giveBookOnStartup;
    public final ForgeConfigSpec.BooleanValue mimicubeSpawnInEndCity;
    public final ForgeConfigSpec.BooleanValue mimicreamRepair;
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> mimicreamBlacklist;
    public final ForgeConfigSpec.BooleanValue raccoonStealFromChests;
    public final ForgeConfigSpec.BooleanValue fishOilMeme;
    public final ForgeConfigSpec.BooleanValue soulVultureSpawnOnFossil;
    public final ForgeConfigSpec.BooleanValue acaciaBlossomsDropFromLeaves;
    public final ForgeConfigSpec.BooleanValue wanderingTraderOffers;
    public final ForgeConfigSpec.IntValue mungusBiomeTransformationType;
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> mungusBiomeMatches;
    public ForgeConfigSpec.BooleanValue limitGusterSpawnsToWeather;
    public ForgeConfigSpec.BooleanValue warpedMoscoTransformation;
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> warpedMoscoMobTriggers;
    public final ForgeConfigSpec.BooleanValue straddleboardEnchants;
    public final ForgeConfigSpec.BooleanValue emuTargetSkeletons;
    public final ForgeConfigSpec.DoubleValue emuPantsDodgeChance;
    public final ForgeConfigSpec.DoubleValue leafcutterAntFungusGrowChance;
    public final ForgeConfigSpec.IntValue leafcutterAntRepopulateFeedings;
    public final ForgeConfigSpec.IntValue leafcutterAntColonySize;
    public final ForgeConfigSpec.DoubleValue leafcutterAntBreakLeavesChance;
    public final ForgeConfigSpec.BooleanValue beachedCachalotWhales;
    public final ForgeConfigSpec.DoubleValue cachalotVolume;
    public final ForgeConfigSpec.IntValue beachedCachalotWhaleSpawnChance;
    public final ForgeConfigSpec.IntValue beachedCachalotWhaleSpawnDelay;
    public final ForgeConfigSpec.DoubleValue leafcutterAnthillSpawnChance;
    public final ForgeConfigSpec.BooleanValue falconryTeleportsBack;
    public final ForgeConfigSpec.BooleanValue fireproofTarantulaHawk;
    public final ForgeConfigSpec.BooleanValue voidWormSummonable;
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> voidWormSpawnDimensions;
    public final ForgeConfigSpec.DoubleValue voidWormDamageModifier;
    public final ForgeConfigSpec.DoubleValue voidWormMaxHealth;
    public final ForgeConfigSpec.BooleanValue seagullStealing;
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> seagullStealingBlacklist;
    public final ForgeConfigSpec.BooleanValue clingingFlipEffect;

    public CommonConfig(ForgeConfigSpec.Builder builder) {
        builder.push("general");
        this.giveBookOnStartup = CommonConfig.buildBoolean(builder, "giveBookOnStartup", "all", true, "Whether all players should get an Animal Dictionary when joining the world for the first time.");
        this.lavaOpacity = CommonConfig.buildDouble(builder, "lavaVisionOpacity", "all", 0.65, 0.01, 1.0, "Lava Opacity for the Lava Vision Potion.");
        this.shadersCompat = CommonConfig.buildBoolean(builder, "shadersCompat", "all", false, "Whether to disable certain aspects of the Lava Vision Potion. Enable if issues with shaders persist.");
        this.bananasDropFromLeaves = CommonConfig.buildBoolean(builder, "bananasDropFromLeaves", "all", true, "Whether bananas should drop from blocks tagged with #alexsmobs:drops_bananas");
        this.bananaChance = CommonConfig.buildInt(builder, "bananaChance", "all", AMConfig.bananaChance, 0, Integer.MAX_VALUE, "1 out of this number chance for leaves to drop a banana when broken. Fortune is automatically factored in");
        this.spidersAttackFlies = CommonConfig.buildBoolean(builder, "spidersAttackFlies", "all", true, "Whether spiders should target fly mobs.");
        this.wolvesAttackMoose = CommonConfig.buildBoolean(builder, "wolvesAttackMoose", "all", true, "Whether wolves should target moose mobs.");
        this.polarBearsAttackSeals = CommonConfig.buildBoolean(builder, "polarBearsAttackSeals", "all", true, "Whether polar bears should target seal mobs.");
        this.lavaBottleEnabled = CommonConfig.buildBoolean(builder, "lavaBottleEnabled", "all", true, "Whether lava can be bottled with a right click of a glass bottle.");
        this.neutralBoneSerpents = CommonConfig.buildBoolean(builder, "neutralBoneSerpents", "all", false, "Whether bone serpents are neutral or hostile.");
        this.caveCentipedeSpawnHeight = CommonConfig.buildInt(builder, "caveCentipedeSpawnHeight", "all", AMConfig.caveCentipedeSpawnHeight, 0, 256, "Maximum world y-level that cave centipedes can spawn at");
        this.blobfishSpawnHeight = CommonConfig.buildInt(builder, "blobfishSpawnHeight", "all", AMConfig.blobfishSpawnHeight, 0, 256, "Maximum world y-level that blobfish can spawn at");
        this.mimicubeSpawnInEndCity = CommonConfig.buildBoolean(builder, "mimicubeSpawnInEndCity", "all", true, "Whether mimicubes spawns should be restricted solely to the end city structure or to whatever biome is specified in their respective biome config.");
        this.mimicreamRepair = CommonConfig.buildBoolean(builder, "mimicreamRepair", "all", true, "Whether mimicream can be used to duplicate items.");
        this.mimicreamBlacklist = builder.comment("Blacklist for items that mimicream cannot make a copy of. Ex: \"minecraft:stone_sword\", \"alexsmobs:blood_sprayer\"").defineList("mimicreamBlacklist", (List)Lists.newArrayList((Object[])new String[]{"alexsmobs:blood_sprayer", "alexsmobs:hemolymph_blaster"}), o -> o instanceof String);
        this.raccoonStealFromChests = CommonConfig.buildBoolean(builder, "raccoonStealFromChests", "all", true, "Whether wild raccoons steal food from chests.");
        this.fishOilMeme = CommonConfig.buildBoolean(builder, "fishOilMeme", "all", true, "Whether fish oil gives players a special levitation effect.");
        this.soulVultureSpawnOnFossil = CommonConfig.buildBoolean(builder, "soulVultureSpawnOnFossil", "all", true, "Whether soul vulture spawns should be restricted solely to the nether fossil structure or to whatever biome is specified in their respective biome config.");
        this.acaciaBlossomsDropFromLeaves = CommonConfig.buildBoolean(builder, "acaciaBlossomsDropFromLeaves", "all", true, "Whether acacia blossoms should drop from blocks tagged with #alexsmobs:drops_acacia_blossoms");
        this.wanderingTraderOffers = CommonConfig.buildBoolean(builder, "wanderingTraderOffers", "all", true, "Whether wandering traders offer items like acacia blossoms, mosquito larva, crocodile egg, etc.");
        this.mungusBiomeTransformationType = CommonConfig.buildInt(builder, "mungusBiomeTransformationType", "all", AMConfig.mungusBiomeTransformationType, 0, 2, "0 = no mungus biome transformation. 1 = mungus changes blocks, but not chunk's biome. 2 = mungus transforms blocks and biome of chunk.");
        this.mungusBiomeMatches = builder.comment("List of all mungus mushrooms, biome transformations and surface blocks. Each is seperated by a |. Add an entry with a block registry name, biome registry name, and block registry name(for the ground).").defineList("mungusBiomeMatches", AMConfig.mungusBiomeMatches, o -> o instanceof String);
        this.limitGusterSpawnsToWeather = CommonConfig.buildBoolean(builder, "limitGusterSpawnsToWeather", "all", true, "Whether guster spawns are limited to when it is raining/thundering.");
        this.warpedMoscoTransformation = CommonConfig.buildBoolean(builder, "warpedMoscoTransformation", "all", true, "Whether Crimson Mosquitoes can transform into Warped Moscos if attacking a Mungus or any listed creature.");
        this.warpedMoscoMobTriggers = builder.comment("List of extra(non mungus) mobs that will trigger a crimson mosquito to become a warped mosquito. Ex: \"minecraft:mooshroom\", \"alexsmobs:warped_toad\"").defineList("warpedMoscoMobTriggers", (List)Lists.newArrayList((Object[])new String[]{""}), o -> o instanceof String);
        this.straddleboardEnchants = CommonConfig.buildBoolean(builder, "straddleboardEnchants", "all", true, "True if straddleboard enchants are enabled.");
        this.emuTargetSkeletons = CommonConfig.buildBoolean(builder, "emuTargetSkeletons", "all", true, "Whether emu should target skeletons.");
        this.emuPantsDodgeChance = CommonConfig.buildDouble(builder, "emuPantsDodgeChance", "all", 0.45, 0.0, 1.0, "Percent chance for emu leggings to dodge projectile attacks.");
        this.cachalotVolume = CommonConfig.buildDouble(builder, "cachalotVolume", "all", 3.0, 0.0, 10.0, "Relative volume of cachalot whales compared to other animals. Note that irl they are the loudest animal. Turn this down if you find their clicks annoying.");
        this.leafcutterAntFungusGrowChance = CommonConfig.buildDouble(builder, "leafcutterAntFungusGrowChance", "all", 0.3, 0.0, 1.0, "Percent chance for fungus to grow per each leaf a leafcutter ant returns to the colony.");
        this.leafcutterAntRepopulateFeedings = CommonConfig.buildInt(builder, "leafcutterAntRepopulateFeedings", "all", AMConfig.leafcutterAntRepopulateFeedings, 2, 100000, "How many feedings of leaves does a leafcutter colony need in order to regain a worker ant, if below half the max members.");
        this.leafcutterAntColonySize = CommonConfig.buildInt(builder, "leafcutterAntColonySize", "all", AMConfig.leafcutterAntColonySize, 2, 100000, "Max number of ant entities allowed inside a leafcutter anthill.");
        this.leafcutterAntBreakLeavesChance = CommonConfig.buildDouble(builder, "leafcutterAntBreakLeavesChance", "all", 0.2, 0.0, 1.0, "Percent chance for leafcutter ants to break leaves blocks when harvesting. Set to zero so that they can not break any blocks.");
        this.falconryTeleportsBack = CommonConfig.buildBoolean(builder, "falconryTeleportsBack", "all", false, "Makes eagles teleport back to their owner if they get stuck during controlled flight. Useful for when playing with the Optifine mod, since this mod is the fault of many issues with the falconry system.");
        this.fireproofTarantulaHawk = CommonConfig.buildBoolean(builder, "fireproofTarantulaHawk", "all", false, "Makes Tarantula Hawks fireproof, perfect if you also want these guys to spawn in the nether.");
        this.voidWormSpawnDimensions = builder.comment("List of dimensions in which spawning void worms via mysterious worm items is allowed.").defineList("voidWormSpawnDimensions", (List)Lists.newArrayList((Object[])new String[]{"minecraft:the_end"}), o -> o instanceof String);
        this.voidWormDamageModifier = CommonConfig.buildDouble(builder, "voidWormDamageModifier", "all", 1.0, 0.0, 100.0, "All void worm damage is scaled to this.");
        this.voidWormMaxHealth = CommonConfig.buildDouble(builder, "voidWormMaxHealth", "all", 160.0, 0.0, 1000000.0, "Max Health of the void worm boss.");
        this.voidWormSummonable = CommonConfig.buildBoolean(builder, "voidWormSummonable", "all", true, "Whether the void worm boss is summonable or not, via the mysterious worm item.");
        this.seagullStealing = CommonConfig.buildBoolean(builder, "seagullStealing", "all", true, "Whether seagulls should steal food out of players' hotbar slots.");
        this.seagullStealingBlacklist = builder.comment("List of items that seagulls cannot take from players.").defineList("seagullStealingBlacklist", (List)Lists.newArrayList(), o -> o instanceof String);
        this.clingingFlipEffect = CommonConfig.buildBoolean(builder, "clingingFlipEffect", "all", false, "Whether the Clinging Potion effect should flip the screen. Warning: may cause nausea.");
        builder.push("spawning");
        this.grizzlyBearSpawnWeight = CommonConfig.buildInt(builder, "grizzlyBearSpawnWeight", "spawns", AMConfig.grizzlyBearSpawnWeight, 0, 1000, "Spawn Weight, added to a pool of other mobs for each biome. Higher number = higher chance of spawning. 0 = disable spawn");
        this.grizzlyBearSpawnRolls = CommonConfig.buildInt(builder, "grizzlyBearSpawnRolls", "spawns", AMConfig.grizzlyBearSpawnRolls, 0, Integer.MAX_VALUE, "Random roll chance to enable mob spawning. Higher number = lower chance of spawning");
        this.roadrunnerSpawnWeight = CommonConfig.buildInt(builder, "roadrunnerSpawnWeight", "spawns", AMConfig.roadrunnerSpawnWeight, 0, 1000, "Spawn Weight, added to a pool of other mobs for each biome. Higher number = higher chance of spawning. 0 = disable spawn");
        this.roadrunnerSpawnRolls = CommonConfig.buildInt(builder, "roadrunnerSpawnRolls", "spawns", AMConfig.roadrunnerSpawnRolls, 0, Integer.MAX_VALUE, "Random roll chance to enable mob spawning. Higher number = lower chance of spawning");
        this.boneSerpentSpawnWeight = CommonConfig.buildInt(builder, "boneSerpentSpawnWeight", "spawns", AMConfig.boneSerpentSpawnWeight, 0, 1000, "Spawn Weight, added to a pool of other mobs for each biome. Higher number = higher chance of spawning. 0 = disable spawn");
        this.boneSeprentSpawnRolls = CommonConfig.buildInt(builder, "boneSeprentSpawnRolls", "spawns", AMConfig.boneSeprentSpawnRolls, 0, Integer.MAX_VALUE, "Random roll chance to enable mob spawning. Higher number = lower chance of spawning");
        this.gazelleSpawnWeight = CommonConfig.buildInt(builder, "gazelleSpawnWeight", "spawns", AMConfig.gazelleSpawnWeight, 0, 1000, "Spawn Weight, added to a pool of other mobs for each biome. Higher number = higher chance of spawning. 0 = disable spawn");
        this.gazelleSpawnRolls = CommonConfig.buildInt(builder, "gazelleSpawnRolls", "spawns", AMConfig.gazelleSpawnRolls, 0, Integer.MAX_VALUE, "Random roll chance to enable mob spawning. Higher number = lower chance of spawning");
        this.crocodileSpawnWeight = CommonConfig.buildInt(builder, "crocodileSpawnWeight", "spawns", AMConfig.crocodileSpawnWeight, 0, 1000, "Spawn Weight, added to a pool of other mobs for each biome. Higher number = higher chance of spawning. 0 = disable spawn");
        this.crocSpawnRolls = CommonConfig.buildInt(builder, "crocSpawnRolls", "spawns", AMConfig.crocSpawnRolls, 0, Integer.MAX_VALUE, "Random roll chance to enable mob spawning. Higher number = lower chance of spawning");
        this.flySpawnWeight = CommonConfig.buildInt(builder, "flySpawnWeight", "spawns", AMConfig.flySpawnWeight, 0, 1000, "Spawn Weight, added to a pool of other mobs for each biome. Higher number = higher chance of spawning. 0 = disable spawn");
        this.flySpawnRolls = CommonConfig.buildInt(builder, "flySpawnRolls", "spawns", AMConfig.flySpawnRolls, 0, Integer.MAX_VALUE, "Random roll chance to enable mob spawning. Higher number = lower chance of spawning");
        this.hummingbirdSpawnWeight = CommonConfig.buildInt(builder, "hummingbirdSpawnWeight", "spawns", AMConfig.hummingbirdSpawnWeight, 0, 1000, "Spawn Weight, added to a pool of other mobs for each biome. Higher number = higher chance of spawning. 0 = disable spawn");
        this.hummingbirdSpawnRolls = CommonConfig.buildInt(builder, "hummingbirdSpawnRolls", "spawns", AMConfig.flySpawnRolls, 0, Integer.MAX_VALUE, "Random roll chance to enable mob spawning. Higher number = lower chance of spawning");
        this.orcaSpawnWeight = CommonConfig.buildInt(builder, "orcaSpawnWeight", "spawns", AMConfig.orcaSpawnWeight, 0, 1000, "Spawn Weight, added to a pool of other mobs for each biome. Higher number = higher chance of spawning. 0 = disable spawn");
        this.orcaSpawnRolls = CommonConfig.buildInt(builder, "orcaSpawnRolls", "spawns", AMConfig.orcaSpawnRolls, 0, Integer.MAX_VALUE, "Random roll chance to enable mob spawning. Higher number = lower chance of spawning");
        this.sunbirdSpawnWeight = CommonConfig.buildInt(builder, "sunbirdSpawnWeight", "spawns", AMConfig.sunbirdSpawnWeight, 0, 1000, "Spawn Weight, added to a pool of other mobs for each biome. Higher number = higher chance of spawning. 0 = disable spawn");
        this.sunbirdSpawnRolls = CommonConfig.buildInt(builder, "sunbirdSpawnRolls", "spawns", AMConfig.sunbirdSpawnRolls, 0, Integer.MAX_VALUE, "Random roll chance to enable mob spawning. Higher number = lower chance of spawning");
        this.gorillaSpawnWeight = CommonConfig.buildInt(builder, "gorillaSpawnWeight", "spawns", AMConfig.gorillaSpawnWeight, 0, 1000, "Spawn Weight, added to a pool of other mobs for each biome. Higher number = higher chance of spawning. 0 = disable spawn");
        this.gorillaSpawnRolls = CommonConfig.buildInt(builder, "gorillaSpawnRolls", "spawns", AMConfig.gorillaSpawnRolls, 0, Integer.MAX_VALUE, "Random roll chance to enable mob spawning. Higher number = lower chance of spawning");
        this.crimsonMosquitoSpawnWeight = CommonConfig.buildInt(builder, "crimsonMosquitoSpawnWeight", "spawns", AMConfig.crimsonMosquitoSpawnWeight, 0, 1000, "Spawn Weight, added to a pool of other mobs for each biome. Higher number = higher chance of spawning. 0 = disable spawn");
        this.crimsonMosquitoSpawnRolls = CommonConfig.buildInt(builder, "crimsonMosquitoSpawnRolls", "spawns", AMConfig.crimsonMosquitoSpawnRolls, 0, Integer.MAX_VALUE, "Random roll chance to enable mob spawning. Higher number = lower chance of spawning");
        this.rattlesnakeSpawnWeight = CommonConfig.buildInt(builder, "rattlesnakeSpawnWeight", "spawns", AMConfig.rattlesnakeSpawnWeight, 0, 1000, "Spawn Weight, added to a pool of other mobs for each biome. Higher number = higher chance of spawning. 0 = disable spawn");
        this.rattlesnakeSpawnRolls = CommonConfig.buildInt(builder, "rattlesnakeSpawnRolls", "spawns", AMConfig.rattlesnakeSpawnRolls, 0, Integer.MAX_VALUE, "Random roll chance to enable mob spawning. Higher number = lower chance of spawning");
        this.endergradeSpawnWeight = CommonConfig.buildInt(builder, "endergradeSpawnWeight", "spawns", AMConfig.endergradeSpawnWeight, 0, 1000, "Spawn Weight, added to a pool of other mobs for each biome. Higher number = higher chance of spawning. 0 = disable spawn");
        this.endergradeSpawnRolls = CommonConfig.buildInt(builder, "endergradeSpawnRolls", "spawns", AMConfig.endergradeSpawnRolls, 0, Integer.MAX_VALUE, "Random roll chance to enable mob spawning. Higher number = lower chance of spawning");
        this.hammerheadSharkSpawnWeight = CommonConfig.buildInt(builder, "hammerheadSharkSpawnWeight", "spawns", AMConfig.hammerheadSharkSpawnWeight, 0, 1000, "Spawn Weight, added to a pool of other mobs for each biome. Higher number = higher chance of spawning. 0 = disable spawn");
        this.hammerheadSharkSpawnRolls = CommonConfig.buildInt(builder, "hammerheadSharkSpawnRolls", "spawns", AMConfig.hammerheadSharkSpawnRolls, 0, Integer.MAX_VALUE, "Random roll chance to enable mob spawning. Higher number = lower chance of spawning");
        this.lobsterSpawnWeight = CommonConfig.buildInt(builder, "lobsterSpawnWeight", "spawns", AMConfig.lobsterSpawnWeight, 0, 1000, "Spawn Weight, added to a pool of other mobs for each biome. Higher number = higher chance of spawning. 0 = disable spawn");
        this.lobsterSpawnRolls = CommonConfig.buildInt(builder, "lobsterSpawnRolls", "spawns", AMConfig.lobsterSpawnRolls, 0, Integer.MAX_VALUE, "Random roll chance to enable mob spawning. Higher number = lower chance of spawning");
        this.komodoDragonSpawnWeight = CommonConfig.buildInt(builder, "komodoDragonSpawnWeight", "spawns", AMConfig.komodoDragonSpawnWeight, 0, 1000, "Spawn Weight, added to a pool of other mobs for each biome. Higher number = higher chance of spawning. 0 = disable spawn");
        this.komodoDragonSpawnRolls = CommonConfig.buildInt(builder, "komodoDragonSpawnRolls", "spawns", AMConfig.komodoDragonSpawnRolls, 0, Integer.MAX_VALUE, "Random roll chance to enable mob spawning. Higher number = lower chance of spawning");
        this.capuchinMonkeySpawnWeight = CommonConfig.buildInt(builder, "capuchinMonkeySpawnWeight", "spawns", AMConfig.capuchinMonkeySpawnWeight, 0, 1000, "Spawn Weight, added to a pool of other mobs for each biome. Higher number = higher chance of spawning. 0 = disable spawn");
        this.capuchinMonkeySpawnRolls = CommonConfig.buildInt(builder, "capuchinMonkeySpawnRolls", "spawns", AMConfig.capuchinMonkeySpawnRolls, 0, Integer.MAX_VALUE, "Random roll chance to enable mob spawning. Higher number = lower chance of spawning");
        this.caveCentipedeSpawnWeight = CommonConfig.buildInt(builder, "caveCentipedeSpawnWeight", "spawns", AMConfig.caveCentipedeSpawnWeight, 0, 1000, "Spawn Weight, added to a pool of other mobs for each biome. Higher number = higher chance of spawning. 0 = disable spawn");
        this.caveCentipedeSpawnRolls = CommonConfig.buildInt(builder, "caveCentipedeSpawnRolls", "spawns", AMConfig.caveCentipedeSpawnRolls, 0, Integer.MAX_VALUE, "Random roll chance to enable mob spawning. Higher number = lower chance of spawning");
        this.warpedToadSpawnWeight = CommonConfig.buildInt(builder, "warpedToadSpawnWeight", "spawns", AMConfig.warpedToadSpawnWeight, 0, 1000, "Spawn Weight, added to a pool of other mobs for each biome. Higher number = higher chance of spawning. 0 = disable spawn");
        this.warpedToadSpawnRolls = CommonConfig.buildInt(builder, "warpedToadSpawnRolls", "spawns", AMConfig.warpedToadSpawnRolls, 0, Integer.MAX_VALUE, "Random roll chance to enable mob spawning. Higher number = lower chance of spawning");
        this.mooseSpawnWeight = CommonConfig.buildInt(builder, "mooseSpawnWeight", "spawns", AMConfig.mooseSpawnWeight, 0, 1000, "Spawn Weight, added to a pool of other mobs for each biome. Higher number = higher chance of spawning. 0 = disable spawn");
        this.mooseSpawnRolls = CommonConfig.buildInt(builder, "mooseSpawnRolls", "spawns", AMConfig.mooseSpawnRolls, 0, Integer.MAX_VALUE, "Random roll chance to enable mob spawning. Higher number = lower chance of spawning");
        this.mimicubeSpawnWeight = CommonConfig.buildInt(builder, "mimicubeSpawnWeight", "spawns", AMConfig.mimicubeSpawnWeight, 0, 1000, "Spawn Weight, added to a pool of other mobs for each biome. Higher number = higher chance of spawning. 0 = disable spawn");
        this.mimicubeSpawnRolls = CommonConfig.buildInt(builder, "mimicubeSpawnRolls", "spawns", AMConfig.mimicubeSpawnRolls, 0, Integer.MAX_VALUE, "Random roll chance to enable mob spawning. Higher number = lower chance of spawning");
        this.raccoonSpawnWeight = CommonConfig.buildInt(builder, "raccoonSpawnWeight", "spawns", AMConfig.raccoonSpawnWeight, 0, 1000, "Spawn Weight, added to a pool of other mobs for each biome. Higher number = higher chance of spawning. 0 = disable spawn");
        this.raccoonSpawnRolls = CommonConfig.buildInt(builder, "raccoonSpawnRolls", "spawns", AMConfig.raccoonSpawnRolls, 0, Integer.MAX_VALUE, "Random roll chance to enable mob spawning. Higher number = lower chance of spawning");
        this.blobfishSpawnWeight = CommonConfig.buildInt(builder, "blobfishSpawnWeight", "spawns", AMConfig.blobfishSpawnWeight, 0, 1000, "Spawn Weight, added to a pool of other mobs for each biome. Higher number = higher chance of spawning. 0 = disable spawn");
        this.blobfishSpawnRolls = CommonConfig.buildInt(builder, "blobfishSpawnRolls", "spawns", AMConfig.blobfishSpawnRolls, 0, Integer.MAX_VALUE, "Random roll chance to enable mob spawning. Higher number = lower chance of spawning");
        this.sealSpawnWeight = CommonConfig.buildInt(builder, "sealSpawnWeight", "spawns", AMConfig.sealSpawnWeight, 0, 1000, "Spawn Weight, added to a pool of other mobs for each biome. Higher number = higher chance of spawning. 0 = disable spawn");
        this.sealSpawnRolls = CommonConfig.buildInt(builder, "sealSpawnRolls", "spawns", AMConfig.sealSpawnRolls, 0, Integer.MAX_VALUE, "Random roll chance to enable mob spawning. Higher number = lower chance of spawning");
        this.cockroachSpawnWeight = CommonConfig.buildInt(builder, "cockroachSpawnWeight", "spawns", AMConfig.cockroachSpawnWeight, 0, 1000, "Spawn Weight, added to a pool of other mobs for each biome. Higher number = higher chance of spawning. 0 = disable spawn");
        this.cockroachSpawnRolls = CommonConfig.buildInt(builder, "cockroachSpawnRolls", "spawns", AMConfig.cockroachSpawnRolls, 0, Integer.MAX_VALUE, "Random roll chance to enable mob spawning. Higher number = lower chance of spawning");
        this.shoebillSpawnWeight = CommonConfig.buildInt(builder, "shoebillSpawnWeight", "spawns", AMConfig.shoebillSpawnWeight, 0, 1000, "Spawn Weight, added to a pool of other mobs for each biome. Higher number = higher chance of spawning. 0 = disable spawn");
        this.shoebillSpawnRolls = CommonConfig.buildInt(builder, "shoebillSpawnRolls", "spawns", AMConfig.shoebillSpawnRolls, 0, Integer.MAX_VALUE, "Random roll chance to enable mob spawning. Higher number = lower chance of spawning");
        this.elephantSpawnWeight = CommonConfig.buildInt(builder, "elephantSpawnWeight", "spawns", AMConfig.elephantSpawnWeight, 0, 1000, "Spawn Weight, added to a pool of other mobs for each biome. Higher number = higher chance of spawning. 0 = disable spawn");
        this.elephantSpawnRolls = CommonConfig.buildInt(builder, "elephantSpawnRolls", "spawns", AMConfig.elephantSpawnRolls, 0, Integer.MAX_VALUE, "Random roll chance to enable mob spawning. Higher number = lower chance of spawning");
        this.soulVultureSpawnWeight = CommonConfig.buildInt(builder, "soulVultureSpawnWeight", "spawns", AMConfig.soulVultureSpawnWeight, 0, 1000, "Spawn Weight, added to a pool of other mobs for each biome. Higher number = higher chance of spawning. 0 = disable spawn");
        this.soulVultureSpawnRolls = CommonConfig.buildInt(builder, "soulVultureSpawnRolls", "spawns", AMConfig.soulVultureSpawnRolls, 0, Integer.MAX_VALUE, "Random roll chance to enable mob spawning. Higher number = lower chance of spawning");
        this.snowLeopardSpawnWeight = CommonConfig.buildInt(builder, "snowLeopardSpawnWeight", "spawns", AMConfig.snowLeopardSpawnWeight, 0, 1000, "Spawn Weight, added to a pool of other mobs for each biome. Higher number = higher chance of spawning. 0 = disable spawn");
        this.snowLeopardSpawnRolls = CommonConfig.buildInt(builder, "snowLeopardSpawnRolls", "spawns", AMConfig.snowLeopardSpawnRolls, 0, Integer.MAX_VALUE, "Random roll chance to enable mob spawning. Higher number = lower chance of spawning");
        this.spectreSpawnWeight = CommonConfig.buildInt(builder, "spectreSpawnWeight", "spawns", AMConfig.spectreSpawnWeight, 0, 1000, "Spawn Weight, added to a pool of other mobs for each biome. Higher number = higher chance of spawning. 0 = disable spawn");
        this.spectreSpawnRolls = CommonConfig.buildInt(builder, "spectreSpawnRolls", "spawns", AMConfig.spectreSpawnRolls, 0, Integer.MAX_VALUE, "Random roll chance to enable mob spawning. Higher number = lower chance of spawning");
        this.crowSpawnWeight = CommonConfig.buildInt(builder, "crowSpawnWeight", "spawns", AMConfig.crowSpawnWeight, 0, 1000, "Spawn Weight, added to a pool of other mobs for each biome. Higher number = higher chance of spawning. 0 = disable spawn");
        this.crowSpawnRolls = CommonConfig.buildInt(builder, "crowSpawnRolls", "spawns", AMConfig.crowSpawnRolls, 0, Integer.MAX_VALUE, "Random roll chance to enable mob spawning. Higher number = lower chance of spawning");
        this.alligatorSnappingTurtleSpawnWeight = CommonConfig.buildInt(builder, "alligatorSnappingTurtleSpawnWeight", "spawns", AMConfig.alligatorSnappingTurtleSpawnWeight, 0, 1000, "Spawn Weight, added to a pool of other mobs for each biome. Higher number = higher chance of spawning. 0 = disable spawn");
        this.alligatorSnappingTurtleSpawnRolls = CommonConfig.buildInt(builder, "alligatorSnappingTurtleSpawnRolls", "spawns", AMConfig.alligatorSnappingTurtleSpawnRolls, 0, Integer.MAX_VALUE, "Random roll chance to enable mob spawning. Higher number = lower chance of spawning");
        this.mungusSpawnWeight = CommonConfig.buildInt(builder, "mungusSpawnWeight", "spawns", AMConfig.mungusSpawnWeight, 0, 1000, "Spawn Weight, added to a pool of other mobs for each biome. Higher number = higher chance of spawning. 0 = disable spawn");
        this.mungusSpawnRolls = CommonConfig.buildInt(builder, "mungusSpawnRolls", "spawns", AMConfig.mungusSpawnRolls, 0, Integer.MAX_VALUE, "Random roll chance to enable mob spawning. Higher number = lower chance of spawning");
        this.mantisShrimpSpawnWeight = CommonConfig.buildInt(builder, "mantisShrimpSpawnWeight", "spawns", AMConfig.mantisShrimpSpawnWeight, 0, 1000, "Spawn Weight, added to a pool of other mobs for each biome. Higher number = higher chance of spawning. 0 = disable spawn");
        this.mantisShrimpSpawnRolls = CommonConfig.buildInt(builder, "mantisShrimpSpawnRolls", "spawns", AMConfig.mantisShrimpSpawnRolls, 0, Integer.MAX_VALUE, "Random roll chance to enable mob spawning. Higher number = lower chance of spawning");
        this.gusterSpawnWeight = CommonConfig.buildInt(builder, "gusterSpawnWeight", "spawns", AMConfig.gusterSpawnWeight, 0, 1000, "Spawn Weight, added to a pool of other mobs for each biome. Higher number = higher chance of spawning. 0 = disable spawn");
        this.gusterSpawnRolls = CommonConfig.buildInt(builder, "gusterSpawnRolls", "spawns", AMConfig.gusterSpawnRolls, 0, Integer.MAX_VALUE, "Random roll chance to enable mob spawning. Higher number = lower chance of spawning");
        this.warpedMoscoSpawnWeight = CommonConfig.buildInt(builder, "warpedMoscoSpawnWeight", "spawns", AMConfig.warpedMoscoSpawnWeight, 0, 1000, "Spawn Weight, added to a pool of other mobs for each biome. Higher number = higher chance of spawning. 0 = disable spawn. NOTE: By default the warped mosco doesn't spawn in any biomes.");
        this.warpedMoscoSpawnRolls = CommonConfig.buildInt(builder, "warpedMoscoSpawnRolls", "spawns", AMConfig.warpedMoscoSpawnRolls, 0, Integer.MAX_VALUE, "Random roll chance to enable mob spawning. Higher number = lower chance of spawning");
        this.straddlerSpawnWeight = CommonConfig.buildInt(builder, "straddlerSpawnWeight", "spawns", AMConfig.straddlerSpawnWeight, 0, 1000, "Spawn Weight, added to a pool of other mobs for each biome. Higher number = higher chance of spawning. 0 = disable spawn");
        this.straddlerSpawnRolls = CommonConfig.buildInt(builder, "straddlerSpawnRolls", "spawns", AMConfig.straddlerSpawnRolls, 0, Integer.MAX_VALUE, "Random roll chance to enable mob spawning. Higher number = lower chance of spawning");
        this.stradpoleSpawnWeight = CommonConfig.buildInt(builder, "stradpoleSpawnWeight", "spawns", AMConfig.stradpoleSpawnWeight, 0, 1000, "Spawn Weight, added to a pool of other mobs for each biome. Higher number = higher chance of spawning. 0 = disable spawn");
        this.stradpoleSpawnRolls = CommonConfig.buildInt(builder, "stradpoleSpawnRolls", "spawns", AMConfig.stradpoleSpawnRolls, 0, Integer.MAX_VALUE, "Random roll chance to enable mob spawning. Higher number = lower chance of spawning");
        this.emuSpawnWeight = CommonConfig.buildInt(builder, "emuSpawnWeight", "spawns", AMConfig.emuSpawnWeight, 0, 1000, "Spawn Weight, added to a pool of other mobs for each biome. Higher number = higher chance of spawning. 0 = disable spawn");
        this.emuSpawnRolls = CommonConfig.buildInt(builder, "emuSpawnRolls", "spawns", AMConfig.emuSpawnRolls, 0, Integer.MAX_VALUE, "Random roll chance to enable mob spawning. Higher number = lower chance of spawning");
        this.platypusSpawnWeight = CommonConfig.buildInt(builder, "platypusSpawnWeight", "spawns", AMConfig.platypusSpawnWeight, 0, 1000, "Spawn Weight, added to a pool of other mobs for each biome. Higher number = higher chance of spawning. 0 = disable spawn");
        this.platypusSpawnRolls = CommonConfig.buildInt(builder, "platypusSpawnRolls", "spawns", AMConfig.platypusSpawnRolls, 0, Integer.MAX_VALUE, "Random roll chance to enable mob spawning. Higher number = lower chance of spawning");
        this.dropbearSpawnWeight = CommonConfig.buildInt(builder, "dropbearSpawnWeight", "spawns", AMConfig.dropbearSpawnWeight, 0, 1000, "Spawn Weight, added to a pool of other mobs for each biome. Higher number = higher chance of spawning. 0 = disable spawn");
        this.dropbearSpawnRolls = CommonConfig.buildInt(builder, "dropbearSpawnRolls", "spawns", AMConfig.dropbearSpawnRolls, 0, Integer.MAX_VALUE, "Random roll chance to enable mob spawning. Higher number = lower chance of spawning");
        this.tasmanianDevilSpawnWeight = CommonConfig.buildInt(builder, "tasmanianDevilSpawnWeight", "spawns", AMConfig.tasmanianDevilSpawnWeight, 0, 1000, "Spawn Weight, added to a pool of other mobs for each biome. Higher number = higher chance of spawning. 0 = disable spawn");
        this.tasmanianDevilSpawnRolls = CommonConfig.buildInt(builder, "tasmanianDevilSpawnRolls", "spawns", AMConfig.tasmanianDevilSpawnRolls, 0, Integer.MAX_VALUE, "Random roll chance to enable mob spawning. Higher number = lower chance of spawning");
        this.kangarooSpawnWeight = CommonConfig.buildInt(builder, "kangarooSpawnWeight", "spawns", AMConfig.kangarooSpawnWeight, 0, 1000, "Spawn Weight, added to a pool of other mobs for each biome. Higher number = higher chance of spawning. 0 = disable spawn");
        this.kangarooSpawnRolls = CommonConfig.buildInt(builder, "kangarooSpawnRolls", "spawns", AMConfig.kangarooSpawnRolls, 0, Integer.MAX_VALUE, "Random roll chance to enable mob spawning. Higher number = lower chance of spawning");
        this.cachalotWhaleSpawnWeight = CommonConfig.buildInt(builder, "cachalotWhaleSpawnWeight", "spawns", AMConfig.cachalotWhaleSpawnWeight, 0, 1000, "Spawn Weight, added to a pool of other mobs for each biome. Higher number = higher chance of spawning. 0 = disable spawn");
        this.cachalotWhaleSpawnRolls = CommonConfig.buildInt(builder, "cachalotWhaleSpawnRolls", "spawns", AMConfig.cachalotWhaleSpawnRolls, 0, Integer.MAX_VALUE, "Random roll chance to enable mob spawning. Higher number = lower chance of spawning");
        this.enderiophageSpawnWeight = CommonConfig.buildInt(builder, "enderiophageSpawnWeight", "spawns", AMConfig.enderiophageSpawnWeight, 0, 1000, "Spawn Weight, added to a pool of other mobs for each biome. Higher number = higher chance of spawning. 0 = disable spawn");
        this.enderiophageSpawnRolls = CommonConfig.buildInt(builder, "enderiophageSpawnRolls", "spawns", AMConfig.enderiophageSpawnRolls, 0, Integer.MAX_VALUE, "Random roll chance to enable mob spawning. Higher number = lower chance of spawning");
        this.baldEagleSpawnWeight = CommonConfig.buildInt(builder, "baldEagleSpawnWeight", "spawns", AMConfig.baldEagleSpawnWeight, 0, 1000, "Spawn Weight, added to a pool of other mobs for each biome. Higher number = higher chance of spawning. 0 = disable spawn");
        this.baldEagleSpawnRolls = CommonConfig.buildInt(builder, "baldEagleSpawnRolls", "spawns", AMConfig.baldEagleSpawnRolls, 0, Integer.MAX_VALUE, "Random roll chance to enable mob spawning. Higher number = lower chance of spawning");
        this.tigerSpawnWeight = CommonConfig.buildInt(builder, "tigerSpawnWeight", "spawns", AMConfig.tigerSpawnWeight, 0, 1000, "Spawn Weight, added to a pool of other mobs for each biome. Higher number = higher chance of spawning. 0 = disable spawn");
        this.tigerSpawnRolls = CommonConfig.buildInt(builder, "tigerSpawnRolls", "spawns", AMConfig.tigerSpawnRolls, 0, Integer.MAX_VALUE, "Random roll chance to enable mob spawning. Higher number = lower chance of spawning");
        this.tarantulaHawkSpawnWeight = CommonConfig.buildInt(builder, "tarantulaHawkSpawnWeight", "spawns", AMConfig.tarantulaHawkSpawnWeight, 0, 1000, "Spawn Weight, added to a pool of other mobs for each biome. Higher number = higher chance of spawning. 0 = disable spawn");
        this.tarantulaHawkSpawnRolls = CommonConfig.buildInt(builder, "tarantulaHawkSpawnRolls", "spawns", AMConfig.tarantulaHawkSpawnRolls, 0, Integer.MAX_VALUE, "Random roll chance to enable mob spawning. Higher number = lower chance of spawning");
        this.voidWormSpawnWeight = CommonConfig.buildInt(builder, "voidWormSpawnWeight", "spawns", AMConfig.voidWormSpawnWeight, 0, 1000, "Spawn Weight, added to a pool of other mobs for each biome. Higher number = higher chance of spawning. 0 = disable spawn");
        this.voidWormSpawnRolls = CommonConfig.buildInt(builder, "voidWormSpawnRolls", "spawns", AMConfig.voidWormSpawnRolls, 0, Integer.MAX_VALUE, "Random roll chance to enable mob spawning. Higher number = lower chance of spawning");
        this.frilledSharkSpawnWeight = CommonConfig.buildInt(builder, "frilledSharkSpawnWeight", "spawns", AMConfig.frilledSharkSpawnWeight, 0, 1000, "Spawn Weight, added to a pool of other mobs for each biome. Higher number = higher chance of spawning. 0 = disable spawn");
        this.frilledSharkSpawnRolls = CommonConfig.buildInt(builder, "frilledSharkSpawnRolls", "spawns", AMConfig.frilledSharkSpawnRolls, 0, Integer.MAX_VALUE, "Random roll chance to enable mob spawning. Higher number = lower chance of spawning");
        this.mimicOctopusSpawnWeight = CommonConfig.buildInt(builder, "mimicOctopusSpawnWeight", "spawns", AMConfig.mimicOctopusSpawnWeight, 0, 1000, "Spawn Weight, added to a pool of other mobs for each biome. Higher number = higher chance of spawning. 0 = disable spawn");
        this.mimicOctopusSpawnRolls = CommonConfig.buildInt(builder, "mimicOctopusSpawnRolls", "spawns", AMConfig.mimicOctopusSpawnRolls, 0, Integer.MAX_VALUE, "Random roll chance to enable mob spawning. Higher number = lower chance of spawning");
        this.seagullSpawnWeight = CommonConfig.buildInt(builder, "seagullSpawnWeight", "spawns", AMConfig.seagullSpawnWeight, 0, 1000, "Spawn Weight, added to a pool of other mobs for each biome. Higher number = higher chance of spawning. 0 = disable spawn");
        this.seagullSpawnRolls = CommonConfig.buildInt(builder, "seagullSpawnRolls", "spawns", AMConfig.seagullSpawnRolls, 0, Integer.MAX_VALUE, "Random roll chance to enable mob spawning. Higher number = lower chance of spawning");
        builder.push("uniqueSpawning");
        this.beachedCachalotWhales = CommonConfig.buildBoolean(builder, "beachedCachalotWhales", "spawns", true, "Whether to enable beached cachalot whales to spawn on beaches during thunder storms.");
        this.beachedCachalotWhaleSpawnChance = CommonConfig.buildInt(builder, "beachedCachalotWhaleSpawnChance", "spawns", AMConfig.beachedCachalotWhaleSpawnChance, 0, 100, "Percent chance increase for each failed attempt to spawn a beached cachalot whale. Higher value = more spawns.");
        this.beachedCachalotWhaleSpawnDelay = CommonConfig.buildInt(builder, "beachedCachalotWhaleSpawnDelay", "spawns", AMConfig.beachedCachalotWhaleSpawnDelay, 0, Integer.MAX_VALUE, "Delay (in ticks) between attempts to spawn beached cachalot whales. Default is a single day. Works like wandering traders.");
        this.leafcutterAnthillSpawnChance = CommonConfig.buildDouble(builder, "leafcutterAnthillSpawnChance", "all", AMConfig.leafcutterAnthillSpawnChance, 0.0, 1.0, "Percent chance for leafcutter anthills to spawn as world gen in each chunk. Set to zero to disable spawning.");
    }

    private static ForgeConfigSpec.BooleanValue buildBoolean(ForgeConfigSpec.Builder builder, String name, String catagory, boolean defaultValue, String comment) {
        return builder.comment(comment).translation(name).define(name, defaultValue);
    }

    private static ForgeConfigSpec.IntValue buildInt(ForgeConfigSpec.Builder builder, String name, String catagory, int defaultValue, int min, int max, String comment) {
        return builder.comment(comment).translation(name).defineInRange(name, defaultValue, min, max);
    }

    private static ForgeConfigSpec.DoubleValue buildDouble(ForgeConfigSpec.Builder builder, String name, String catagory, double defaultValue, double min, double max, String comment) {
        return builder.comment(comment).translation(name).defineInRange(name, defaultValue, min, max);
    }
}

