/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.config.AMConfig;
import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.ai.DirectPathNavigator;
import com.github.alexthe666.alexsmobs.entity.ai.EntityAINearestTarget3D;
import com.github.alexthe666.alexsmobs.entity.ai.GroundPathNavigatorWide;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import com.github.alexthe666.alexsmobs.misc.AMTagRegistry;
import java.util.EnumSet;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.piglin.AbstractPiglinEntity;
import net.minecraft.entity.passive.IFlyingAnimal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class EntitySoulVulture
extends MonsterEntity
implements IFlyingAnimal {
    public static final ResourceLocation SOUL_LOOT = new ResourceLocation("alexsmobs", "entities/soul_vulture_heart");
    private static final DataParameter<Boolean> FLYING = EntityDataManager.func_187226_a(EntitySoulVulture.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> TACKLING = EntityDataManager.func_187226_a(EntitySoulVulture.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Optional<BlockPos>> PERCH_POS = EntityDataManager.func_187226_a(EntitySoulVulture.class, (IDataSerializer)DataSerializers.field_187201_k);
    private static final DataParameter<Integer> SOUL_LEVEL = EntityDataManager.func_187226_a(EntitySoulVulture.class, (IDataSerializer)DataSerializers.field_187192_b);
    public float prevFlyProgress;
    public float flyProgress;
    public float prevTackleProgress;
    public float tackleProgress;
    private boolean isLandNavigator;
    private int perchSearchCooldown = 0;
    private int landingCooldown = 0;
    private int tackleCooldown = 0;

    protected EntitySoulVulture(EntityType type, World worldIn) {
        super(type, worldIn);
        this.switchNavigator(true);
    }

    public CreatureAttribute func_70668_bt() {
        return CreatureAttribute.field_223223_b_;
    }

    @Nullable
    protected ResourceLocation func_184647_J() {
        return this.getSoulLevel() > 2 ? SOUL_LOOT : super.func_184647_J();
    }

    public boolean func_213380_a(IWorld worldIn, SpawnReason spawnReasonIn) {
        return AMEntityRegistry.rollSpawn(AMConfig.soulVultureSpawnRolls, this.func_70681_au(), spawnReasonIn);
    }

    public static boolean canVultureSpawn(EntityType<? extends MobEntity> typeIn, IServerWorld worldIn, SpawnReason reason, BlockPos pos, Random randomIn) {
        BlockPos blockpos = pos.func_177977_b();
        boolean spawnBlock = BlockTags.func_199896_a().func_199910_a(AMTagRegistry.SOUL_VULTURE_SPAWNS).func_230235_a_((Object)worldIn.func_180495_p(blockpos).func_177230_c());
        return reason == SpawnReason.SPAWNER || spawnBlock && EntitySoulVulture.func_223315_a(AMEntityRegistry.SOUL_VULTURE, (IWorld)worldIn, (SpawnReason)reason, (BlockPos)pos, (Random)randomIn);
    }

    protected SoundEvent func_184639_G() {
        return AMSoundRegistry.SOUL_VULTURE_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return AMSoundRegistry.SOUL_VULTURE_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return AMSoundRegistry.SOUL_VULTURE_HURT;
    }

    public static AttributeModifierMap.MutableAttribute bakeAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 12.0).func_233815_a_(Attributes.field_233819_b_, 18.0).func_233815_a_(Attributes.field_233823_f_, 4.0).func_233815_a_(Attributes.field_233821_d_, 0.25);
    }

    public boolean isPerchBlock(BlockPos pos, BlockState state) {
        return this.field_70170_p.func_175623_d(pos.func_177984_a()) && this.field_70170_p.func_175623_d(pos.func_177981_b(2)) && BlockTags.func_199896_a().func_199910_a(AMTagRegistry.SOUL_VULTURE_PERCHES).func_230235_a_((Object)state.func_177230_c());
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new AICirclePerch(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new AIFlyRandom(this));
        this.field_70714_bg.func_75776_a(3, (Goal)new AITackleMelee(this));
        this.field_70714_bg.func_75776_a(4, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 20.0f));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[]{EntitySoulVulture.class}));
        this.field_70715_bh.func_75776_a(2, new EntityAINearestTarget3D<PlayerEntity>((MobEntity)this, PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(2, new EntityAINearestTarget3D<AbstractPiglinEntity>((MobEntity)this, AbstractPiglinEntity.class, true));
        this.field_70715_bh.func_75776_a(3, new EntityAINearestTarget3D<AbstractVillagerEntity>((MobEntity)this, AbstractVillagerEntity.class, true));
    }

    private void switchNavigator(boolean onLand) {
        if (onLand) {
            this.field_70765_h = new MovementController((MobEntity)this);
            this.field_70699_by = new GroundPathNavigatorWide((MobEntity)this, this.field_70170_p);
            this.isLandNavigator = true;
        } else {
            this.field_70765_h = new MoveHelper(this);
            this.field_70699_by = new DirectPathNavigator((MobEntity)this, this.field_70170_p);
            this.isLandNavigator = false;
        }
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(FLYING, (Object)false);
        this.field_70180_af.func_187214_a(TACKLING, (Object)false);
        this.field_70180_af.func_187214_a(PERCH_POS, Optional.empty());
        this.field_70180_af.func_187214_a(SOUL_LEVEL, (Object)0);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("Flying", this.isFlying());
        if (this.getPerchPos() != null) {
            compound.func_74768_a("PerchX", this.getPerchPos().func_177958_n());
            compound.func_74768_a("PerchY", this.getPerchPos().func_177956_o());
            compound.func_74768_a("PerchZ", this.getPerchPos().func_177952_p());
        }
        compound.func_74768_a("SoulLevel", this.getSoulLevel());
        compound.func_74768_a("LandingCooldown", this.landingCooldown);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setFlying(compound.func_74767_n("Flying"));
        this.setSoulLevel(compound.func_74762_e("SoulLevel"));
        this.landingCooldown = compound.func_74762_e("LandingCooldown");
        if (compound.func_74764_b("PerchX") && compound.func_74764_b("PerchY") && compound.func_74764_b("PerchZ")) {
            this.setPerchPos(new BlockPos(compound.func_74762_e("PerchX"), compound.func_74762_e("PerchY"), compound.func_74762_e("PerchZ")));
        }
    }

    public boolean isFlying() {
        return (Boolean)this.field_70180_af.func_187225_a(FLYING);
    }

    public void setFlying(boolean flying) {
        this.field_70180_af.func_187227_b(FLYING, (Object)flying);
    }

    public boolean isTackling() {
        return (Boolean)this.field_70180_af.func_187225_a(TACKLING);
    }

    public void setTackling(boolean tackling) {
        this.field_70180_af.func_187227_b(TACKLING, (Object)tackling);
    }

    public BlockPos getPerchPos() {
        return ((Optional)this.field_70180_af.func_187225_a(PERCH_POS)).orElse(null);
    }

    public void setPerchPos(BlockPos pos) {
        this.field_70180_af.func_187227_b(PERCH_POS, Optional.ofNullable(pos));
    }

    public int getSoulLevel() {
        return (Integer)this.field_70180_af.func_187225_a(SOUL_LEVEL);
    }

    public void setSoulLevel(int tackling) {
        this.field_70180_af.func_187227_b(SOUL_LEVEL, (Object)tackling);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.prevTackleProgress = this.tackleProgress;
        this.prevFlyProgress = this.flyProgress;
        if (!this.field_70170_p.field_72995_K) {
            if (this.perchSearchCooldown > 0) {
                --this.perchSearchCooldown;
            }
            if (this.func_70638_az() != null && this.func_70638_az().func_70089_S()) {
                this.setPerchPos(this.func_70638_az().func_233580_cy_().func_177981_b(7));
            } else if (this.getPerchPos() != null && !this.isPerchBlock(this.getPerchPos(), this.field_70170_p.func_180495_p(this.getPerchPos()))) {
                this.setPerchPos(null);
            }
            if (this.getPerchPos() == null && this.perchSearchCooldown == 0) {
                this.perchSearchCooldown = 20 + this.field_70146_Z.nextInt(20);
                this.setPerchPos(this.findNewPerchPos());
            }
            if (!this.isFlying() && this.landingCooldown == 0 && (this.getPerchPos() == null || this.shouldLeavePerch(this.getPerchPos()))) {
                this.setFlying(true);
            }
            if (!this.isFlying() && this.func_70638_az() != null) {
                this.setFlying(true);
            }
            if (this.landingCooldown > 0 && this.isFlying() && this.func_233570_aj_() && this.func_70638_az() == null) {
                this.setFlying(false);
            }
        }
        if (this.isFlying() && this.isLandNavigator) {
            this.switchNavigator(false);
        }
        if (!this.isFlying() && !this.isLandNavigator) {
            this.switchNavigator(true);
        }
        if (this.isFlying() && this.flyProgress < 5.0f) {
            this.flyProgress += 1.0f;
        }
        if (!this.isFlying() && this.flyProgress > 0.0f) {
            this.flyProgress -= 1.0f;
        }
        if (this.isTackling() && this.tackleProgress < 5.0f) {
            this.tackleProgress += 1.0f;
        }
        if (!this.isTackling() && this.tackleProgress > 0.0f) {
            this.tackleProgress -= 1.0f;
        }
        if (this.landingCooldown > 0) {
            --this.landingCooldown;
        }
        if (this.tackleCooldown > 0) {
            --this.tackleCooldown;
        }
        if (this.isFlying()) {
            this.func_189654_d(true);
        } else {
            this.func_189654_d(false);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 68) {
            for (int i = 0; i < 6 + this.field_70146_Z.nextInt(3); ++i) {
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_239812_C_, this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf()) - (double)this.func_213311_cf() * 0.5, this.func_226278_cu_() + (double)(this.func_213302_cg() * 0.5f) + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg() * 0.5f), this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf()) - (double)this.func_213311_cf() * 0.5, d0, d1, d2);
            }
        } else {
            super.func_70103_a(id);
        }
    }

    public BlockPos findNewPerchPos() {
        BlockState beneathState = this.field_70170_p.func_180495_p(this.func_226270_aj_());
        if (this.isPerchBlock(this.func_226270_aj_(), beneathState)) {
            return this.func_226270_aj_();
        }
        BlockPos blockpos = null;
        Random random = new Random();
        int range = 14;
        for (int i = 0; i < 15; ++i) {
            BlockPos blockpos1 = this.func_233580_cy_().func_177982_a(random.nextInt(range) - range / 2, 3, random.nextInt(range) - range / 2);
            while (this.field_70170_p.func_175623_d(blockpos1) && blockpos1.func_177956_o() > 1) {
                blockpos1 = blockpos1.func_177977_b();
            }
            if (!this.isPerchBlock(blockpos1, this.field_70170_p.func_180495_p(blockpos1))) continue;
            blockpos = blockpos1;
        }
        return blockpos;
    }

    private boolean shouldLeavePerch(BlockPos perchPos) {
        return this.func_195048_a(Vector3d.func_237489_a_((Vector3i)perchPos)) > 13.0 || this.landingCooldown == 0;
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    protected void func_184231_a(double y, boolean onGroundIn, BlockState state, BlockPos pos) {
    }

    public boolean shouldSwoop() {
        return this.func_70638_az() != null && this.tackleCooldown == 0;
    }

    public boolean isTargetBlocked(Vector3d target) {
        Vector3d Vector3d2 = new Vector3d(this.func_226277_ct_(), this.func_226280_cw_(), this.func_226281_cx_());
        return this.field_70170_p.func_217299_a(new RayTraceContext(Vector3d2, target, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this)).func_216346_c() != RayTraceResult.Type.MISS;
    }

    private class AITackleMelee
    extends Goal {
        private final EntitySoulVulture vulture;

        public AITackleMelee(EntitySoulVulture vulture) {
            this.vulture = vulture;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            if (this.vulture.func_70638_az() != null && this.vulture.shouldSwoop()) {
                this.vulture.setFlying(true);
                return true;
            }
            return false;
        }

        public void func_75251_c() {
            this.vulture.setTackling(false);
        }

        public void func_75246_d() {
            if (this.vulture.isFlying()) {
                this.vulture.setTackling(true);
            } else {
                this.vulture.setTackling(false);
            }
            if (this.vulture.func_70638_az() != null) {
                float f;
                this.vulture.func_70605_aq().func_75642_a(this.vulture.func_70638_az().func_226277_ct_(), this.vulture.func_70638_az().func_226278_cu_() + (double)this.vulture.func_70638_az().func_70047_e(), this.vulture.func_70638_az().func_226281_cx_(), 2.0);
                double d0 = this.vulture.func_226277_ct_() - this.vulture.func_70638_az().func_226277_ct_();
                double d2 = this.vulture.func_226281_cx_() - this.vulture.func_70638_az().func_226281_cx_();
                double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
                this.vulture.field_70761_aq = this.vulture.field_70177_z = (f = (float)(MathHelper.func_181159_b((double)d2, (double)d0) * 57.2957763671875) - 90.0f);
                if (this.vulture.func_174813_aQ().func_72314_b((double)0.3f, (double)0.3f, (double)0.3f).func_72326_a(this.vulture.func_70638_az().func_174813_aQ()) && this.vulture.tackleCooldown == 0) {
                    EntitySoulVulture.this.tackleCooldown = 100 + EntitySoulVulture.this.field_70146_Z.nextInt(200);
                    float dmg = (float)this.vulture.func_110148_a(Attributes.field_233823_f_).func_111126_e();
                    if (this.vulture.func_70638_az().func_70097_a(DamageSource.func_76358_a((LivingEntity)this.vulture), dmg) && this.vulture.func_110143_aJ() < this.vulture.func_110138_aP() - dmg && this.vulture.getSoulLevel() < 5) {
                        this.vulture.setSoulLevel(this.vulture.getSoulLevel() + 1);
                        this.vulture.func_70691_i(dmg);
                        this.vulture.field_70170_p.func_72960_a((Entity)this.vulture, (byte)68);
                    }
                    this.func_75251_c();
                }
            }
        }
    }

    private class AIFlyRandom
    extends Goal {
        private final EntitySoulVulture vulture;
        private BlockPos target = null;

        public AIFlyRandom(EntitySoulVulture vulture) {
            this.vulture = vulture;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            if (this.vulture.getPerchPos() != null || this.vulture.shouldSwoop()) {
                return false;
            }
            MovementController movementcontroller = this.vulture.func_70605_aq();
            if (!movementcontroller.func_75640_a() || this.target == null) {
                this.target = this.getBlockInViewVulture();
                if (this.target != null) {
                    this.vulture.func_70605_aq().func_75642_a((double)this.target.func_177958_n() + 0.5, (double)this.target.func_177956_o() + 0.5, (double)this.target.func_177952_p() + 0.5, 1.0);
                }
                return true;
            }
            return false;
        }

        public boolean func_75253_b() {
            if (this.vulture.getPerchPos() != null || this.vulture.shouldSwoop()) {
                return false;
            }
            return this.target != null && this.vulture.func_195048_a(Vector3d.func_237489_a_((Vector3i)this.target)) > 2.4 && this.vulture.func_70605_aq().func_75640_a() && !this.vulture.field_70123_F;
        }

        public void func_75251_c() {
            this.target = null;
        }

        public void func_75246_d() {
            if (this.target == null) {
                this.target = this.getBlockInViewVulture();
            }
            if (this.target != null) {
                this.vulture.func_70605_aq().func_75642_a((double)this.target.func_177958_n() + 0.5, (double)this.target.func_177956_o() + 0.5, (double)this.target.func_177952_p() + 0.5, 1.0);
                if (this.vulture.func_195048_a(Vector3d.func_237489_a_((Vector3i)this.target)) < 2.5) {
                    this.target = null;
                }
            }
        }

        public BlockPos getBlockInViewVulture() {
            float radius = -9.45f - (float)this.vulture.func_70681_au().nextInt(10);
            float neg = this.vulture.func_70681_au().nextBoolean() ? 1.0f : -1.0f;
            float renderYawOffset = this.vulture.field_70761_aq;
            float angle = (float)Math.PI / 180 * renderYawOffset + 3.15f + this.vulture.func_70681_au().nextFloat() * neg;
            double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
            double extraZ = radius * MathHelper.func_76134_b((float)angle);
            BlockPos radialPos = new BlockPos(this.vulture.func_226277_ct_() + extraX, this.vulture.func_226278_cu_(), this.vulture.func_226281_cx_() + extraZ);
            while (EntitySoulVulture.this.field_70170_p.func_175623_d(radialPos) && radialPos.func_177956_o() > 2) {
                radialPos = radialPos.func_177977_b();
            }
            BlockPos newPos = radialPos.func_177981_b(this.vulture.func_226278_cu_() - (double)radialPos.func_177956_o() > 16.0 ? 4 : this.vulture.func_70681_au().nextInt(5) + 5);
            if (!this.vulture.isTargetBlocked(Vector3d.func_237489_a_((Vector3i)newPos)) && this.vulture.func_195048_a(Vector3d.func_237489_a_((Vector3i)newPos)) > 6.0) {
                return newPos;
            }
            return null;
        }
    }

    class MoveHelper
    extends MovementController {
        private final EntitySoulVulture parentEntity;

        public MoveHelper(EntitySoulVulture bird) {
            super((MobEntity)bird);
            this.parentEntity = bird;
        }

        public void func_75641_c() {
            if (this.field_188491_h == MovementController.Action.MOVE_TO) {
                Vector3d vector3d = new Vector3d(this.field_75646_b - this.parentEntity.func_226277_ct_(), this.field_75647_c - this.parentEntity.func_226278_cu_(), this.field_75644_d - this.parentEntity.func_226281_cx_());
                double d5 = vector3d.func_72433_c();
                if (d5 < 0.3) {
                    this.field_188491_h = MovementController.Action.WAIT;
                    this.parentEntity.func_213317_d(this.parentEntity.func_213322_ci().func_186678_a(0.5));
                } else {
                    double d0 = this.field_75646_b - this.parentEntity.func_226277_ct_();
                    double d1 = this.field_75647_c - this.parentEntity.func_226278_cu_();
                    double d2 = this.field_75644_d - this.parentEntity.func_226281_cx_();
                    double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
                    this.parentEntity.func_213317_d(this.parentEntity.func_213322_ci().func_178787_e(vector3d.func_186678_a(this.field_75645_e * 0.05 / d5)));
                    Vector3d vector3d1 = this.parentEntity.func_213322_ci();
                    this.parentEntity.field_70761_aq = this.parentEntity.field_70177_z = -((float)MathHelper.func_181159_b((double)vector3d1.field_72450_a, (double)vector3d1.field_72449_c)) * 57.295776f;
                }
            }
        }

        private boolean func_220673_a(Vector3d p_220673_1_, int p_220673_2_) {
            AxisAlignedBB axisalignedbb = this.parentEntity.func_174813_aQ();
            for (int i = 1; i < p_220673_2_; ++i) {
                if (this.parentEntity.field_70170_p.func_226665_a__((Entity)this.parentEntity, axisalignedbb = axisalignedbb.func_191194_a(p_220673_1_))) continue;
                return false;
            }
            return true;
        }
    }

    class AICirclePerch
    extends Goal {
        private final EntitySoulVulture vulture;
        float speed = 1.0f;
        float circlingTime = 0.0f;
        float circleDistance = 5.0f;
        float maxCirclingTime = 80.0f;
        boolean clockwise = false;
        private BlockPos targetPos;
        private int yLevel = 1;

        public AICirclePerch(EntitySoulVulture vulture) {
            this.vulture = vulture;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            return !this.vulture.shouldSwoop() && this.vulture.isFlying() && this.vulture.getPerchPos() != null;
        }

        public void func_75249_e() {
            this.circlingTime = 0.0f;
            this.speed = 0.8f + EntitySoulVulture.this.field_70146_Z.nextFloat() * 0.4f;
            this.yLevel = this.vulture.field_70146_Z.nextInt(3);
            this.maxCirclingTime = 360 + this.vulture.field_70146_Z.nextInt(80);
            this.circleDistance = 5.0f + this.vulture.field_70146_Z.nextFloat() * 5.0f;
            this.clockwise = this.vulture.field_70146_Z.nextBoolean();
        }

        public void func_75251_c() {
            this.circlingTime = 0.0f;
            this.speed = 0.8f + EntitySoulVulture.this.field_70146_Z.nextFloat() * 0.4f;
            this.yLevel = this.vulture.field_70146_Z.nextInt(3);
            this.maxCirclingTime = 360 + this.vulture.field_70146_Z.nextInt(80);
            this.circleDistance = 5.0f + this.vulture.field_70146_Z.nextFloat() * 5.0f;
            this.clockwise = this.vulture.field_70146_Z.nextBoolean();
            this.vulture.tackleCooldown = 0;
        }

        public void func_75246_d() {
            BlockPos encircle = this.vulture.getPerchPos();
            double localSpeed = this.speed;
            if (this.vulture.func_70638_az() != null) {
                localSpeed *= 1.55;
            }
            if (encircle != null) {
                this.circlingTime += 1.0f;
                if (this.circlingTime > 360.0f) {
                    this.vulture.func_70605_aq().func_75642_a((double)encircle.func_177958_n() + 0.5, (double)encircle.func_177956_o() + 1.1, (double)encircle.func_177952_p() + 0.5, localSpeed);
                    if (this.vulture.field_70124_G || this.vulture.func_70092_e((double)encircle.func_177958_n() + 0.5, (double)encircle.func_177956_o() + 1.1, (double)encircle.func_177952_p() + 0.5) < 1.0) {
                        this.vulture.setFlying(false);
                        this.vulture.func_213317_d(Vector3d.field_186680_a);
                        this.vulture.landingCooldown = 400 + EntitySoulVulture.this.field_70146_Z.nextInt(1200);
                        this.func_75251_c();
                    }
                } else {
                    BlockPos circlePos = this.getVultureCirclePos(encircle);
                    if (circlePos != null) {
                        this.vulture.func_70605_aq().func_75642_a((double)circlePos.func_177958_n() + 0.5, (double)circlePos.func_177956_o() + 0.5, (double)circlePos.func_177952_p() + 0.5, localSpeed);
                    }
                }
            }
        }

        public boolean func_75253_b() {
            return this.func_75250_a();
        }

        public BlockPos getVultureCirclePos(BlockPos target) {
            float angle = 0.05235988f * (this.clockwise ? -this.circlingTime : this.circlingTime);
            double extraX = this.circleDistance * MathHelper.func_76126_a((float)angle);
            double extraZ = this.circleDistance * MathHelper.func_76134_b((float)angle);
            BlockPos pos = new BlockPos((double)target.func_177958_n() + extraX, (double)(target.func_177956_o() + 1 + this.yLevel), (double)target.func_177952_p() + extraZ);
            if (this.vulture.field_70170_p.func_175623_d(pos)) {
                return pos;
            }
            return null;
        }
    }
}

