/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.alexsmobs.entity;

import com.github.alexthe666.alexsmobs.entity.AMEntityRegistry;
import com.github.alexthe666.alexsmobs.entity.ITargetsDroppedItems;
import com.github.alexthe666.alexsmobs.entity.ai.CreatureAITargetItems;
import com.github.alexthe666.alexsmobs.misc.AMSoundRegistry;
import com.github.alexthe666.citadel.animation.Animation;
import com.github.alexthe666.citadel.animation.AnimationHandler;
import com.github.alexthe666.citadel.animation.IAnimatedEntity;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.ChickenEntity;
import net.minecraft.entity.passive.RabbitEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class EntityTasmanianDevil
extends AnimalEntity
implements IAnimatedEntity,
ITargetsDroppedItems {
    private int animationTick;
    private Animation currentAnimation;
    public static final Animation ANIMATION_HOWL = Animation.create((int)40);
    public static final Animation ANIMATION_ATTACK = Animation.create((int)8);
    private static final DataParameter<Boolean> BASKING = EntityDataManager.func_187226_a(EntityTasmanianDevil.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> SITTING = EntityDataManager.func_187226_a(EntityTasmanianDevil.class, (IDataSerializer)DataSerializers.field_187198_h);
    public float prevBaskProgress;
    public float prevSitProgress;
    public float baskProgress;
    public float sitProgress;
    private int sittingTime;
    private int maxSitTime;
    private int scareMobsTime = 0;

    protected EntityTasmanianDevil(EntityType type, World world) {
        super(type, world);
    }

    public boolean shouldMove() {
        return !this.isSitting() && !this.isBasking();
    }

    protected SoundEvent func_184639_G() {
        return AMSoundRegistry.TASMANIAN_DEVIL_IDLE;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return AMSoundRegistry.TASMANIAN_DEVIL_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return AMSoundRegistry.TASMANIAN_DEVIL_HURT;
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new MeleeAttackGoal((CreatureEntity)this, 1.5, true));
        this.field_70714_bg.func_75776_a(2, (Goal)new TemptGoal((CreatureEntity)this, 1.1, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151078_bh}), false){

            public void func_75246_d() {
                super.func_75246_d();
                if (EntityTasmanianDevil.this.getAnimation() == IAnimatedEntity.NO_ANIMATION) {
                    EntityTasmanianDevil.this.setBasking(false);
                    EntityTasmanianDevil.this.setSitting(false);
                }
            }
        });
        this.field_70714_bg.func_75776_a(3, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.0, 60));
        this.field_70714_bg.func_75776_a(4, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[]{EntityTasmanianDevil.class}).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AnimalEntity.class, 120, false, false, p_213487_0_ -> p_213487_0_ instanceof ChickenEntity || p_213487_0_ instanceof RabbitEntity));
        this.field_70715_bh.func_75776_a(3, new CreatureAITargetItems((CreatureEntity)this, false, 30));
    }

    public void func_241847_a(ServerWorld world, LivingEntity entity) {
        if (this.func_70681_au().nextBoolean() && (entity instanceof AnimalEntity || entity.func_70668_bt() == CreatureAttribute.field_223223_b_)) {
            entity.func_199701_a_(new ItemStack((IItemProvider)Items.field_151103_aS));
        }
    }

    public void func_213352_e(Vector3d vec3d) {
        if (!this.shouldMove()) {
            if (this.func_70661_as().func_75505_d() != null) {
                this.func_70661_as().func_75499_g();
            }
            vec3d = Vector3d.field_186680_a;
        }
        super.func_213352_e(vec3d);
    }

    public void setSitting(boolean sit) {
        this.field_70180_af.func_187227_b(SITTING, (Object)sit);
    }

    public boolean isSitting() {
        return (Boolean)this.field_70180_af.func_187225_a(SITTING);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(BASKING, (Object)false);
        this.field_70180_af.func_187214_a(SITTING, (Object)false);
    }

    public boolean isBasking() {
        return (Boolean)this.field_70180_af.func_187225_a(BASKING);
    }

    public void setBasking(boolean basking) {
        this.field_70180_af.func_187227_b(BASKING, (Object)basking);
    }

    public static AttributeModifierMap.MutableAttribute bakeAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233818_a_, 14.0).func_233815_a_(Attributes.field_233819_b_, 32.0).func_233815_a_(Attributes.field_233821_d_, (double)0.3f).func_233815_a_(Attributes.field_233823_f_, 2.0);
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b().func_219971_r() && stack.func_77973_b().func_219967_s() != null && stack.func_77973_b().func_219967_s().func_221467_c() && stack.func_77973_b() != Items.field_151078_bh;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.prevBaskProgress = this.baskProgress;
        this.prevSitProgress = this.sitProgress;
        if (this.isSitting() && this.sitProgress < 5.0f) {
            this.sitProgress += 1.0f;
        }
        if (!this.isSitting() && this.sitProgress > 0.0f) {
            this.sitProgress -= 1.0f;
        }
        if (this.isBasking() && this.baskProgress < 5.0f) {
            this.baskProgress += 1.0f;
        }
        if (!this.isBasking() && this.baskProgress > 0.0f) {
            this.baskProgress -= 1.0f;
        }
        if (!this.field_70170_p.field_72995_K && this.func_70638_az() != null && this.getAnimation() == ANIMATION_ATTACK && this.getAnimationTick() == 5 && this.func_70685_l((Entity)this.func_70638_az())) {
            float f1 = this.field_70177_z * ((float)Math.PI / 180);
            this.func_213317_d(this.func_213322_ci().func_72441_c((double)(-MathHelper.func_76126_a((float)f1) * 0.02f), 0.0, (double)(MathHelper.func_76134_b((float)f1) * 0.02f)));
            this.func_70638_az().func_233627_a_(1.0f, this.func_70638_az().func_226277_ct_() - this.func_226277_ct_(), this.func_70638_az().func_226281_cx_() - this.func_226281_cx_());
            this.func_70638_az().func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)this.func_110148_a(Attributes.field_233823_f_).func_111125_b());
        }
        if (!this.field_70170_p.field_72995_K && (this.isSitting() || this.isBasking()) && ++this.sittingTime > this.maxSitTime) {
            this.setSitting(false);
            this.setBasking(false);
            this.sittingTime = 0;
            this.maxSitTime = 75 + this.field_70146_Z.nextInt(50);
        }
        if (!this.field_70170_p.field_72995_K && this.func_213322_ci().func_189985_c() < 0.03 && this.getAnimation() == NO_ANIMATION && !this.isBasking() && !this.isSitting() && this.field_70146_Z.nextInt(100) == 0) {
            this.sittingTime = 0;
            this.maxSitTime = 100 + this.field_70146_Z.nextInt(550);
            if (this.func_70681_au().nextBoolean()) {
                this.setSitting(true);
                this.setBasking(false);
            } else {
                this.setSitting(false);
                this.setBasking(true);
            }
        }
        if (this.getAnimation() == ANIMATION_HOWL && this.getAnimationTick() == 1) {
            this.func_184185_a(AMSoundRegistry.TASMANIAN_DEVIL_ROAR, this.func_70599_aP() * 2.0f, this.func_70647_i());
        }
        if (this.getAnimation() == ANIMATION_HOWL && this.getAnimationTick() > 3) {
            this.scareMobsTime = 40;
        }
        if (this.scareMobsTime > 0) {
            List list = this.field_70170_p.func_217357_a(MonsterEntity.class, this.func_174813_aQ().func_72314_b(16.0, 8.0, 16.0));
            for (MonsterEntity e : list) {
                Vector3d vec;
                e.func_70624_b(null);
                e.func_70604_c(null);
                if (this.scareMobsTime % 5 != 0 || (vec = RandomPositionGenerator.func_75461_b((CreatureEntity)e, (int)20, (int)7, (Vector3d)this.func_213303_ch())) == null) continue;
                e.func_70661_as().func_75492_a(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, 1.5);
            }
            --this.scareMobsTime;
        }
        if (this.func_70638_az() != null && this.func_70638_az().func_70089_S() && (this.func_70643_av() == null || !this.func_70643_av().func_70089_S())) {
            this.func_70604_c(this.func_70638_az());
        }
        if ((this.isSitting() || this.isBasking()) && (this.func_70638_az() != null || this.func_70880_s())) {
            this.setSitting(false);
            this.setBasking(false);
        }
        AnimationHandler.INSTANCE.updateAnimations((Entity)this);
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        Item item = itemstack.func_77973_b();
        ActionResultType type = super.func_230254_b_(player, hand);
        if (item == Items.field_151078_bh && this.getAnimation() != ANIMATION_HOWL) {
            this.func_184185_a(SoundEvents.field_219634_dx, this.func_70599_aP(), this.func_70647_i());
            this.func_199701_a_(item.getContainerItem(itemstack));
            if (!player.func_184812_l_()) {
                itemstack.func_190918_g(1);
            }
            this.setAnimation(ANIMATION_HOWL);
            return ActionResultType.SUCCESS;
        }
        return type;
    }

    public boolean func_70652_k(Entity entityIn) {
        if (this.getAnimation() == NO_ANIMATION) {
            this.setAnimation(ANIMATION_ATTACK);
        }
        return true;
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int i) {
        this.animationTick = i;
    }

    public Animation getAnimation() {
        return this.currentAnimation;
    }

    public void setAnimation(Animation animation) {
        this.currentAnimation = animation;
        if (animation == ANIMATION_HOWL) {
            this.setSitting(true);
            this.setBasking(false);
            this.maxSitTime = Math.max(25, this.maxSitTime);
        }
    }

    public Animation[] getAnimations() {
        return new Animation[]{ANIMATION_ATTACK, ANIMATION_HOWL};
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld serverWorld, AgeableEntity ageableEntity) {
        return (AgeableEntity)AMEntityRegistry.TASMANIAN_DEVIL.func_200721_a((World)serverWorld);
    }

    @Override
    public boolean canTargetItem(ItemStack stack) {
        return stack.func_77973_b().func_219971_r() && stack.func_77973_b().func_219967_s() != null && stack.func_77973_b().func_219967_s().func_221467_c() || stack.func_77973_b() == Items.field_151103_aS;
    }

    @Override
    public void onGetItem(ItemEntity e) {
        if (e.func_92059_d().func_77973_b() == Items.field_151103_aS) {
            this.dropBonemeal();
            this.func_184185_a(SoundEvents.field_187868_fj, this.func_70599_aP(), this.func_70647_i());
        } else {
            this.func_184185_a(SoundEvents.field_219634_dx, this.func_70599_aP(), this.func_70647_i());
            this.func_70691_i(5.0f);
        }
    }

    public void dropBonemeal() {
        ItemStack stack = new ItemStack((IItemProvider)Items.field_196106_bc);
        for (int i = 0; i < 3 + this.field_70146_Z.nextInt(1); ++i) {
            this.func_199701_a_(stack);
        }
    }
}

