/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.gravestone;

import de.maxhenkel.gravestone.Main;
import de.maxhenkel.gravestone.tileentity.GraveStoneTileEntity;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public class GraveUtils {
    public static final UUID EMPTY_UUID = new UUID(0L, 0L);

    @Nullable
    public static BlockPos getGraveStoneLocation(World world, BlockPos pos) {
        BlockPos.Mutable location = new BlockPos.Mutable(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        if (World.func_189509_E((BlockPos)location) && location.func_177956_o() <= 0) {
            location.func_181079_c(location.func_177958_n(), 1, location.func_177952_p());
        }
        while (!World.func_189509_E((BlockPos)location)) {
            if (GraveUtils.isReplaceable(world, (BlockPos)location)) {
                return location;
            }
            location.func_196234_d(0, 1, 0);
        }
        return null;
    }

    public static boolean isReplaceable(World world, BlockPos pos) {
        Block b = world.func_180495_p(pos).func_177230_c();
        if (world.func_175623_d(pos)) {
            return true;
        }
        return Main.SERVER_CONFIG.replaceableBlocks.stream().anyMatch(arg_0 -> ((Block)b).func_203417_a(arg_0));
    }

    @Nullable
    public static IFormattableTextComponent getDate(long timestamp) {
        if (timestamp <= 0L) {
            return null;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat(new TranslationTextComponent("gui.gravestone.date_format").getString());
        return new StringTextComponent(dateFormat.format(new Date(timestamp)));
    }

    public static boolean canBreakGrave(IWorld world, PlayerEntity player, BlockPos pos) {
        ServerPlayerEntity p;
        if (!((Boolean)Main.SERVER_CONFIG.onlyOwnersCanBreak.get()).booleanValue()) {
            return true;
        }
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof GraveStoneTileEntity)) {
            return true;
        }
        GraveStoneTileEntity grave = (GraveStoneTileEntity)te;
        if (player instanceof ServerPlayerEntity && (p = (ServerPlayerEntity)player).func_211513_k(p.field_71133_b.func_110455_j())) {
            return true;
        }
        UUID uuid = grave.getDeath().getPlayerUUID();
        if (uuid.equals(EMPTY_UUID)) {
            return true;
        }
        return player.func_110124_au().equals(uuid);
    }
}

