/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.block.tiles;

import net.mehvahdjukaar.supplementaries.block.blocks.PulleyBlock;
import net.mehvahdjukaar.supplementaries.block.blocks.SignPostBlock;
import net.mehvahdjukaar.supplementaries.block.blocks.TurnTableBlock;
import net.mehvahdjukaar.supplementaries.configs.ServerConfigs;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.block.BedBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.ChestType;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.Rotation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;

public class TurnTableBlockTile
extends TileEntity
implements ITickableTileEntity {
    private int cooldown = 5;
    private boolean canRotate = false;
    public int cat = 0;

    public TurnTableBlockTile() {
        super((TileEntityType)ModRegistry.TURN_TABLE_TILE.get());
    }

    public void tryRotate() {
        this.canRotate = true;
        this.cooldown = TurnTableBlock.getPeriod(this.func_195044_w());
    }

    public void func_73660_a() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            this.cat = Math.max(this.cat - 1, 0);
            if (this.cooldown == 0) {
                boolean success = this.handleRotation();
                this.cooldown = TurnTableBlock.getPeriod(this.func_195044_w());
                int power = (Integer)this.func_195044_w().func_177229_b((Property)TurnTableBlock.POWER);
                boolean bl = this.canRotate = success && power != 0;
                if (power == 0) {
                    this.field_145850_b.func_180501_a(this.field_174879_c, (BlockState)this.func_195044_w().func_206870_a((Property)TurnTableBlock.ROTATING, (Comparable)Boolean.valueOf(false)), 3);
                }
            } else if (this.canRotate) {
                --this.cooldown;
            }
        }
    }

    private boolean isInBlacklist(BlockState state) {
        if (state.func_177230_c() instanceof BedBlock) {
            return true;
        }
        if (state.func_235901_b_((Property)BlockStateProperties.field_208140_ao) && state.func_177229_b((Property)BlockStateProperties.field_208140_ao) != ChestType.SINGLE) {
            return true;
        }
        if (state.func_235901_b_((Property)BlockStateProperties.field_208181_h) && ((Boolean)state.func_177229_b((Property)BlockStateProperties.field_208181_h)).booleanValue()) {
            return true;
        }
        if (state.func_235901_b_((Property)BlockStateProperties.field_208195_v)) {
            return true;
        }
        return ServerConfigs.cached.TURN_TABLE_BLACKLIST.contains(state.func_177230_c().getRegistryName().toString());
    }

    private boolean doRotateBlocks(BlockState oldstate, BlockState newState, BlockPos pos, Direction mydir) {
        if (newState != oldstate) {
            if (newState.func_196955_c((IWorldReader)this.field_145850_b, pos)) {
                BlockState updatedState = Block.func_199770_b((BlockState)newState, (IWorld)this.field_145850_b, (BlockPos)pos);
                this.field_145850_b.func_180501_a(pos, updatedState, 3);
                this.field_145850_b.func_175695_a(pos, newState.func_177230_c(), mydir.func_176734_d());
                this.field_145850_b.func_184133_a(null, this.func_174877_v(), SoundEvents.field_187632_cP, SoundCategory.BLOCKS, 1.0f, 0.6f);
            }
            return true;
        }
        return false;
    }

    public Vector3d toVector3d(Direction dir) {
        return new Vector3d((double)dir.func_82601_c(), (double)dir.func_96559_d(), (double)dir.func_82599_e());
    }

    public boolean handleRotation() {
        World world = this.field_145850_b;
        BlockPos mypos = this.field_174879_c;
        BlockState state = this.func_195044_w();
        Direction mydir = (Direction)state.func_177229_b((Property)BlockStateProperties.field_208155_H);
        BlockPos targetpos = mypos.func_177972_a(mydir);
        BlockState targetState = world.func_180495_p(targetpos);
        if (this.isInBlacklist(targetState)) {
            return false;
        }
        boolean ccw = (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208188_o) ^ state.func_177229_b((Property)BlockStateProperties.field_208155_H) == Direction.DOWN;
        Rotation rot = ccw ? Rotation.COUNTERCLOCKWISE_90 : Rotation.CLOCKWISE_90;
        try {
            if (mydir.func_176740_k() == Direction.Axis.Y) {
                if (targetState.func_177230_c() instanceof SignPostBlock) {
                    targetState.rotate((IWorld)world, targetpos, rot);
                    return true;
                }
                BlockState rotatedstate = targetState.rotate((IWorld)world, targetpos, rot);
                return this.doRotateBlocks(targetState, rotatedstate, targetpos, mydir);
            }
            if (targetState.func_235901_b_((Property)BlockStateProperties.field_208155_H)) {
                Vector3d targetvec = this.toVector3d((Direction)targetState.func_177229_b((Property)BlockStateProperties.field_208155_H));
                Vector3d myvec = this.toVector3d(mydir);
                if (!ccw) {
                    targetvec.func_216372_d(-1.0, -1.0, -1.0);
                }
                if ((myvec = myvec.func_72431_c(targetvec)).equals((Object)new Vector3d(0.0, 0.0, 0.0))) {
                    return false;
                }
                Direction newdir = Direction.func_210769_a((double)myvec.func_82615_a(), (double)myvec.func_82617_b(), (double)myvec.func_82616_c());
                return this.doRotateBlocks(targetState, (BlockState)targetState.func_206870_a((Property)BlockStateProperties.field_208155_H, (Comparable)newdir), targetpos, mydir);
            }
            if (targetState.func_235901_b_((Property)BlockStateProperties.field_208148_A)) {
                Direction.Axis targetaxis = (Direction.Axis)targetState.func_177229_b((Property)BlockStateProperties.field_208148_A);
                Direction.Axis myaxis = mydir.func_176740_k();
                if (myaxis == targetaxis) {
                    if (myaxis != Direction.Axis.Y && targetState.func_177230_c() instanceof PulleyBlock) {
                        ((PulleyBlock)targetState.func_177230_c()).axisRotate(targetState, targetpos, world, rot, mydir);
                        return true;
                    }
                    return false;
                }
                if (myaxis == Direction.Axis.X) {
                    return this.doRotateBlocks(targetState, (BlockState)targetState.func_206870_a((Property)BlockStateProperties.field_208148_A, (Comparable)(targetaxis == Direction.Axis.Y ? Direction.Axis.Z : Direction.Axis.Y)), targetpos, mydir);
                }
                if (myaxis == Direction.Axis.Z) {
                    return this.doRotateBlocks(targetState, (BlockState)targetState.func_206870_a((Property)BlockStateProperties.field_208148_A, (Comparable)(targetaxis == Direction.Axis.Y ? Direction.Axis.X : Direction.Axis.Y)), targetpos, mydir);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        super.func_230337_a_(state, compound);
        this.cooldown = compound.func_74762_e("Cooldown");
        this.canRotate = compound.func_74767_n("CanRotate");
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        compound.func_74768_a("Cooldown", this.cooldown);
        compound.func_74757_a("CanRotate", this.canRotate);
        return compound;
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 0, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.func_195044_w(), pkt.func_148857_g());
    }
}

