/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.block.util;

import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.item.DyeColor;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.IReorderingProcessor;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class TextHolder {
    public final int size;
    public final ITextComponent[] signText;
    private final IReorderingProcessor[] renderText;
    public DyeColor textColor = DyeColor.BLACK;

    public TextHolder(int size) {
        this.size = size;
        this.renderText = new IReorderingProcessor[size];
        this.signText = new ITextComponent[size];
        for (int i = 0; i < size; ++i) {
            this.signText[i] = new StringTextComponent("");
        }
    }

    public void read(CompoundNBT compound) {
        if (compound.func_74764_b("TextHolder")) {
            CompoundNBT com = compound.func_74775_l("TextHolder");
            this.textColor = DyeColor.func_204271_a((String)com.func_74779_i("Color"), (DyeColor)DyeColor.BLACK);
            for (int i = 0; i < this.size; ++i) {
                String s = com.func_74779_i("Text" + (i + 1));
                IFormattableTextComponent itextcomponent = ITextComponent.Serializer.func_240643_a_((String)(s.isEmpty() ? "\"\"" : s));
                this.signText[i] = itextcomponent;
                this.renderText[i] = null;
            }
        }
        if (compound.func_74764_b("Color")) {
            this.textColor = DyeColor.func_204271_a((String)compound.func_74779_i("Color"), (DyeColor)DyeColor.BLACK);
        }
        for (int i = 0; i < 2; ++i) {
            if (!compound.func_74764_b("Text" + (i + 1))) continue;
            String s = compound.func_74779_i("Text" + (i + 1));
            IFormattableTextComponent itextcomponent = ITextComponent.Serializer.func_240643_a_((String)(s.isEmpty() ? "\"\"" : s));
            this.signText[i] = itextcomponent;
        }
    }

    public CompoundNBT write(CompoundNBT compound) {
        CompoundNBT com = new CompoundNBT();
        com.func_74778_a("Color", this.textColor.func_176762_d());
        for (int i = 0; i < this.size; ++i) {
            String s = ITextComponent.Serializer.func_150696_a((ITextComponent)this.signText[i]);
            com.func_74778_a("Text" + (i + 1), s);
        }
        compound.func_218657_a("TextHolder", (INBT)com);
        return compound;
    }

    public ITextComponent getText(int line) {
        return this.signText[line];
    }

    public void setText(int line, ITextComponent text) {
        this.signText[line] = text;
        this.renderText[line] = null;
    }

    @Nullable
    public IReorderingProcessor getRenderText(int line, Function<ITextComponent, IReorderingProcessor> f) {
        if (this.renderText[line] == null && this.signText[line] != null) {
            this.renderText[line] = f.apply(this.signText[line]);
        }
        return this.renderText[line];
    }

    public boolean setTextColor(DyeColor newColor) {
        if (newColor != this.textColor) {
            this.textColor = newColor;
            return true;
        }
        return false;
    }
}

