/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers.entities;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.mehvahdjukaar.supplementaries.common.SpecialPlayers;
import net.mehvahdjukaar.supplementaries.common.Textures;
import net.mehvahdjukaar.supplementaries.network.NetworkHandler;
import net.mehvahdjukaar.supplementaries.network.PicklePacket;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.PlayerRenderer;
import net.minecraft.client.renderer.entity.layers.ArrowLayer;
import net.minecraft.client.renderer.entity.layers.BeeStingerLayer;
import net.minecraft.client.renderer.entity.layers.BipedArmorLayer;
import net.minecraft.client.renderer.entity.layers.ElytraLayer;
import net.minecraft.client.renderer.entity.layers.HeldItemLayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.CrossbowItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.UseAction;
import net.minecraft.scoreboard.Score;
import net.minecraft.scoreboard.ScoreObjective;
import net.minecraft.scoreboard.Scoreboard;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientChatEvent;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.network.PacketDistributor;

@Mod.EventBusSubscriber(modid="supplementaries", value={Dist.CLIENT})
public class PicklePlayer {
    private static PickleRenderer RENDERER_INSTANCE;
    private static JarredRenderer RENDERER_INSTANCE_JAR;
    private static boolean jarvis;

    @SubscribeEvent
    public static void onLogout(ClientPlayerNetworkEvent.LoggedOutEvent event) {
        PickleData.onPlayerLogOff();
    }

    @SubscribeEvent
    public static void chat(ClientChatEvent event) {
        String m = event.getOriginalMessage();
        UUID id = Minecraft.func_71410_x().field_71439_g.func_146103_bH().getId();
        if (m.startsWith("/jarvis")) {
            jarvis = !jarvis;
            event.setCanceled(true);
            if (jarvis) {
                Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)new StringTextComponent("I am Jarman"), Util.field_240973_b_);
            }
        } else if (PickleData.isDev(id) && m.startsWith("/pickle")) {
            boolean turnOn;
            event.setCanceled(true);
            boolean bl = turnOn = !PickleData.isActive(id);
            if (turnOn) {
                Minecraft.func_71410_x().field_71439_g.func_145747_a((ITextComponent)new StringTextComponent("I turned myself into a pickle!"), Util.field_240973_b_);
            }
            PickleData.set(id, turnOn);
            NetworkHandler.INSTANCE.sendToServer((Object)new PicklePacket(id, turnOn));
        }
    }

    @SubscribeEvent
    public static void onRenderPlayerPre(RenderPlayerEvent.Pre event) {
        UUID id = event.getPlayer().func_146103_bH().getId();
        if (PickleData.isActiveAndTick(id, event.getRenderer())) {
            event.setCanceled(true);
            if (RENDERER_INSTANCE == null) {
                RENDERER_INSTANCE = new PickleRenderer(event.getRenderer().func_177068_d());
            }
            float rot = MathHelper.func_219805_h((float)event.getPlayer().field_70126_B, (float)event.getPlayer().field_70177_z, (float)event.getPartialRenderTick());
            RENDERER_INSTANCE.render((AbstractClientPlayerEntity)event.getPlayer(), rot, event.getPartialRenderTick(), event.getMatrixStack(), event.getBuffers(), event.getLight());
        } else if (jarvis && id.equals(Minecraft.func_71410_x().field_71439_g.func_110124_au())) {
            event.setCanceled(true);
            if (RENDERER_INSTANCE_JAR == null) {
                RENDERER_INSTANCE_JAR = new JarredRenderer(event.getRenderer().func_177068_d());
            }
            float rot = MathHelper.func_219805_h((float)event.getPlayer().field_70126_B, (float)event.getPlayer().field_70177_z, (float)event.getPartialRenderTick());
            RENDERER_INSTANCE_JAR.render((AbstractClientPlayerEntity)event.getPlayer(), rot, event.getPartialRenderTick(), event.getMatrixStack(), event.getBuffers(), event.getLight());
        }
    }

    static {
        jarvis = false;
    }

    public static class PickleData {
        public static final Map<UUID, PickleValues> PICKLE_PLAYERS = new HashMap<UUID, PickleValues>();
        private static final PickleValues DEF;

        public static void onPlayerLogOff() {
            for (PickleValues val : PICKLE_PLAYERS.values()) {
                val.reset();
            }
        }

        public static void onPlayerLogin(PlayerEntity player) {
            for (UUID id : PICKLE_PLAYERS.keySet()) {
                boolean on = PICKLE_PLAYERS.get(id).isOn();
                if (!on) continue;
                NetworkHandler.INSTANCE.send(PacketDistributor.PLAYER.with(() -> (ServerPlayerEntity)player), (Object)new PicklePacket(id, on));
            }
        }

        public static boolean isDev(UUID id) {
            return SpecialPlayers.DEVS.contains(id);
        }

        public static void set(UUID id, boolean on) {
            PICKLE_PLAYERS.getOrDefault(id, DEF).toggle(on);
        }

        public static boolean isActiveAndTick(UUID id, PlayerRenderer renderer) {
            return PICKLE_PLAYERS.getOrDefault(id, DEF).isOnAndTick(renderer);
        }

        public static boolean isActive(UUID id) {
            return PICKLE_PLAYERS.getOrDefault(id, DEF).isOn();
        }

        static {
            for (UUID id : SpecialPlayers.DEVS) {
                PICKLE_PLAYERS.put(id, new PickleValues());
            }
            DEF = new PickleValues();
        }

        public static class PickleValues {
            private State state = State.OFF;
            private float oldShadowSize = 1.0f;

            public void toggle(boolean on) {
                this.state = on ? State.FIRST_ON : State.FIRST_OFF;
            }

            public void reset() {
                this.state = State.OFF;
            }

            public boolean isOnAndTick(PlayerRenderer renderer) {
                switch (this.state) {
                    case ON: {
                        return true;
                    }
                    default: {
                        return false;
                    }
                    case FIRST_ON: {
                        this.oldShadowSize = renderer.field_76989_e;
                        renderer.field_76989_e = 0.0f;
                        this.state = State.ON;
                        return true;
                    }
                    case FIRST_OFF: 
                }
                renderer.field_76989_e = this.oldShadowSize;
                this.state = State.OFF;
                return true;
            }

            public boolean isOn() {
                return this.state == State.ON || this.state == State.FIRST_ON;
            }

            private static enum State {
                ON,
                OFF,
                FIRST_ON,
                FIRST_OFF;

            }
        }
    }

    public static class PickleElytra<T extends LivingEntity, M extends EntityModel<T>>
    extends ElytraLayer<T, M> {
        public PickleElytra(IEntityRenderer<T, M> renderer) {
            super(renderer);
        }

        public void func_225628_a_(MatrixStack matrixStack, IRenderTypeBuffer buffer, int p_225628_3_, T entity2, float p_225628_5_, float p_225628_6_, float p_225628_7_, float p_225628_8_, float p_225628_9_, float p_225628_10_) {
            matrixStack.func_227861_a_(0.0, 0.625, 0.09375);
            matrixStack.func_227862_a_(0.625f, 0.625f, 0.625f);
            super.func_225628_a_(matrixStack, buffer, p_225628_3_, entity2, p_225628_5_, p_225628_6_, p_225628_7_, p_225628_8_, p_225628_9_, p_225628_10_);
        }

        public boolean shouldRender(ItemStack stack, T entity2) {
            if (entity2.func_213453_ef()) {
                return false;
            }
            return super.shouldRender(stack, entity2);
        }
    }

    public static class PickleArmor<T extends LivingEntity, M extends BipedModel<T>, A extends BipedModel<T>>
    extends BipedArmorLayer<T, M, A> {
        public PickleArmor(IEntityRenderer<T, M> renderer, A modelChest) {
            super(renderer, modelChest, modelChest);
        }

        public void func_188359_a(A modelIn, EquipmentSlotType slotIn) {
            boolean head;
            modelIn.func_178719_a(false);
            ((BipedModel)modelIn).field_178720_f.field_78806_j = head = slotIn == EquipmentSlotType.HEAD;
            ((BipedModel)modelIn).field_78116_c.field_78806_j = head;
            ((BipedModel)modelIn).field_78116_c.func_217177_a(((BipedModel)modelIn).field_78115_e);
            ((BipedModel)modelIn).field_78116_c.field_78797_d = 13.0f;
            ((BipedModel)modelIn).field_178720_f.func_217177_a(((BipedModel)modelIn).field_78116_c);
        }

        public void func_225628_a_(MatrixStack p_225628_1_, IRenderTypeBuffer p_225628_2_, int p_225628_3_, T entity2, float p_225628_5_, float p_225628_6_, float p_225628_7_, float p_225628_8_, float p_225628_9_, float p_225628_10_) {
            if (entity2.func_213453_ef()) {
                return;
            }
            super.func_225628_a_(p_225628_1_, p_225628_2_, p_225628_3_, entity2, p_225628_5_, p_225628_6_, p_225628_7_, p_225628_8_, p_225628_9_, p_225628_10_);
        }
    }

    public static class PickleModel<T extends LivingEntity>
    extends PlayerModel<T> {
        public PickleModel() {
            super(0.0f, false);
            this.field_78090_t = 32;
            this.field_78089_u = 32;
            float o = 0.0f;
            this.field_78116_c = new ModelRenderer((Model)this);
            this.field_78116_c.func_78793_a(0.0f, 13.0f, 0.0f);
            this.field_178720_f = new ModelRenderer((Model)this);
            this.field_178720_f.func_217177_a(this.field_78116_c);
            this.field_78115_e = new ModelRenderer((Model)this);
            this.field_78115_e.func_78793_a(0.0f, 0.0f + o, 0.0f);
            this.field_78115_e.func_78784_a(0, 2).func_228303_a_(-4.0f, -2.0f, -4.0f, 8.0f, 14.0f, 8.0f, 0.0f, false);
            this.field_178724_i = new ModelRenderer((Model)this);
            this.field_178724_i.func_78793_a(5.0f, 2.5f + o, 0.0f);
            this.field_178724_i.func_78784_a(2, 18).func_228303_a_(-1.0f, -0.5f, -1.0f, 2.0f, 8.0f, 2.0f, 0.0f, false);
            this.field_178723_h = new ModelRenderer((Model)this);
            this.field_178723_h.func_78793_a(-5.0f, 2.5f + o, 0.0f);
            this.field_178723_h.func_78784_a(16, 18).func_228303_a_(-1.0f, -0.5f, -1.0f, 2.0f, 8.0f, 2.0f, 0.0f, false);
            this.field_178722_k = new ModelRenderer((Model)this);
            this.field_178722_k.func_78793_a(-1.9f, 12.0f + o, 0.0f);
            this.field_178722_k.func_78784_a(0, 24).func_228303_a_(3.85f, 0.0f, -1.0f, 2.0f, 4.0f, 2.0f, 0.0f, true);
            this.field_178721_j = new ModelRenderer((Model)this);
            this.field_178721_j.func_78793_a(1.9f, 12.0f + o, 0.0f);
            this.field_178721_j.func_78784_a(16, 24).func_228303_a_(-5.85f, 0.0f, -1.0f, 2.0f, 4.0f, 2.0f, 0.0f, false);
        }

        public void func_225599_a_(HandSide handSide, MatrixStack matrixStack) {
            matrixStack.func_227861_a_(0.0, 0.5, 0.0);
            ModelRenderer modelrenderer = this.func_187074_a(handSide);
            float f = 1.0f * (float)(handSide == HandSide.RIGHT ? 1 : -1);
            modelrenderer.field_78800_c += f;
            modelrenderer.field_78797_d -= 1.0f;
            modelrenderer.field_78798_e += 1.0f;
            modelrenderer.func_228307_a_(matrixStack);
            modelrenderer.field_78798_e -= 1.0f;
        }

        public void func_225598_a_(MatrixStack matrixStack, IVertexBuilder p_225598_2_, int p_225598_3_, int p_225598_4_, float p_225598_5_, float p_225598_6_, float p_225598_7_, float p_225598_8_) {
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(0.0, this.field_217113_d ? -0.5 : 0.5, 0.0);
            super.func_225598_a_(matrixStack, p_225598_2_, p_225598_3_, p_225598_4_, p_225598_5_, p_225598_6_, p_225598_7_, p_225598_8_);
            matrixStack.func_227865_b_();
        }

        public void func_225597_a_(T player, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            super.func_225597_a_(player, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            if (this.field_205061_a > 0.0f && player.func_213314_bj()) {
                this.field_78115_e.field_78796_g = this.func_205060_a(limbSwing, this.field_78115_e.field_78796_g, -0.10471976f);
            }
        }
    }

    public static class PickleRenderer
    extends LivingRenderer<AbstractClientPlayerEntity, PickleModel<AbstractClientPlayerEntity>> {
        private float axisFacing = 0.0f;
        private boolean wasCrouching = false;

        public PickleRenderer(EntityRendererManager mgr) {
            super(mgr, new PickleModel(), 0.0125f);
            this.field_76987_f = 0.0f;
            this.field_76989_e = 0.0f;
            this.func_177094_a((LayerRenderer)new HeldItemLayer((IEntityRenderer)this));
            this.func_177094_a((LayerRenderer)new PickleArmor(this, new BipedModel(1.0f)));
            this.func_177094_a((LayerRenderer)new ArrowLayer((LivingRenderer)this));
            this.func_177094_a((LayerRenderer)new PickleElytra(this));
            this.func_177094_a((LayerRenderer)new BeeStingerLayer((LivingRenderer)this));
        }

        public ResourceLocation getTextureLocation(AbstractClientPlayerEntity player) {
            return Textures.SEA_PICKLE_RICK;
        }

        protected boolean shouldShowName(AbstractClientPlayerEntity player) {
            return !player.func_213453_ef() && super.func_177070_b((LivingEntity)player);
        }

        protected void scale(AbstractClientPlayerEntity player, MatrixStack stack, float partialTickTime) {
            stack.func_227862_a_(0.5f, 0.5f, 0.5f);
        }

        public void render(AbstractClientPlayerEntity player, float p_225623_2_, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer p_225623_5_, int p_225623_6_) {
            this.setModelProperties(player);
            if (this.wasCrouching) {
                float f = (MathHelper.func_219805_h((float)partialTicks, (float)player.field_70760_ar, (float)player.field_70761_aq) + this.axisFacing) % 360.0f;
                matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(f));
            }
            super.func_225623_a_((LivingEntity)player, p_225623_2_, partialTicks, matrixStack, p_225623_5_, p_225623_6_);
        }

        public Vector3d getRenderOffset(AbstractClientPlayerEntity player, float p_225627_2_) {
            return player.func_213453_ef() ? new Vector3d(0.0, -0.25, 0.0) : new Vector3d(0.0, -0.25, 0.0);
        }

        private void setModelProperties(AbstractClientPlayerEntity player) {
            PlayerModel playermodel = (PlayerModel)this.func_217764_d();
            playermodel.func_178719_a(false);
            boolean c = player.func_213453_ef();
            playermodel.field_78115_e.field_78806_j = true;
            playermodel.field_178724_i.field_78806_j = !c;
            playermodel.field_178723_h.field_78806_j = !c;
            playermodel.field_178722_k.field_78806_j = !c;
            playermodel.field_178721_j.field_78806_j = !c;
            playermodel.field_78116_c.field_78806_j = !c;
            boolean bl = playermodel.field_178720_f.field_78806_j = !c;
            if (this.wasCrouching != c && c) {
                this.axisFacing = -player.func_174811_aO().func_185119_l();
            }
            this.wasCrouching = c;
            BipedModel.ArmPose poseRightArm = PickleRenderer.getArmPose(player, Hand.MAIN_HAND);
            BipedModel.ArmPose poseLeftArm = PickleRenderer.getArmPose(player, Hand.OFF_HAND);
            if (poseRightArm.func_241657_a_()) {
                BipedModel.ArmPose armPose = poseLeftArm = player.func_184592_cb().func_190926_b() ? BipedModel.ArmPose.EMPTY : BipedModel.ArmPose.ITEM;
            }
            if (player.func_184591_cq() == HandSide.RIGHT) {
                playermodel.field_187076_m = poseRightArm;
                playermodel.field_187075_l = poseLeftArm;
            } else {
                playermodel.field_187076_m = poseLeftArm;
                playermodel.field_187075_l = poseRightArm;
            }
        }

        private static BipedModel.ArmPose getArmPose(AbstractClientPlayerEntity player, Hand hand) {
            ItemStack itemstack = player.func_184586_b(hand);
            if (itemstack.func_190926_b()) {
                return BipedModel.ArmPose.EMPTY;
            }
            if (player.func_184600_cs() == hand && player.func_184605_cv() > 0) {
                UseAction useaction = itemstack.func_77975_n();
                if (useaction == UseAction.BLOCK) {
                    return BipedModel.ArmPose.BLOCK;
                }
                if (useaction == UseAction.BOW) {
                    return BipedModel.ArmPose.BOW_AND_ARROW;
                }
                if (useaction == UseAction.SPEAR) {
                    return BipedModel.ArmPose.THROW_SPEAR;
                }
                if (useaction == UseAction.CROSSBOW && hand == player.func_184600_cs()) {
                    return BipedModel.ArmPose.CROSSBOW_CHARGE;
                }
            } else if (!player.field_82175_bq && itemstack.func_77973_b() == Items.field_222114_py && CrossbowItem.func_220012_d((ItemStack)itemstack)) {
                return BipedModel.ArmPose.CROSSBOW_HOLD;
            }
            return BipedModel.ArmPose.ITEM;
        }

        protected void renderNameTag(AbstractClientPlayerEntity player, ITextComponent name, MatrixStack matrixStack, IRenderTypeBuffer buffer, int p_225629_5_) {
            Scoreboard scoreboard;
            ScoreObjective scoreobjective;
            double d0 = this.field_76990_c.func_229099_b_((Entity)player);
            matrixStack.func_227860_a_();
            if (d0 < 100.0 && (scoreobjective = (scoreboard = player.func_96123_co()).func_96539_a(2)) != null) {
                Score score = scoreboard.func_96529_a(player.func_195047_I_(), scoreobjective);
                super.func_225629_a_((Entity)player, (ITextComponent)new StringTextComponent(Integer.toString(score.func_96652_c())).func_240702_b_(" ").func_230529_a_(scoreobjective.func_96678_d()), matrixStack, buffer, p_225629_5_);
                matrixStack.func_227861_a_(0.0, (double)0.25875f, 0.0);
            }
            super.func_225629_a_((Entity)player, name, matrixStack, buffer, p_225629_5_);
            matrixStack.func_227865_b_();
        }

        public void renderRightHand(MatrixStack p_229144_1_, IRenderTypeBuffer p_229144_2_, int p_229144_3_, AbstractClientPlayerEntity p_229144_4_) {
            this.renderHand(p_229144_1_, p_229144_2_, p_229144_3_, p_229144_4_, ((PickleModel)this.field_77045_g).field_178723_h, ((PickleModel)this.field_77045_g).field_178732_b);
        }

        public void renderLeftHand(MatrixStack p_229146_1_, IRenderTypeBuffer p_229146_2_, int p_229146_3_, AbstractClientPlayerEntity p_229146_4_) {
            this.renderHand(p_229146_1_, p_229146_2_, p_229146_3_, p_229146_4_, ((PickleModel)this.field_77045_g).field_178724_i, ((PickleModel)this.field_77045_g).field_178734_a);
        }

        private void renderHand(MatrixStack matrixStack, IRenderTypeBuffer buffer, int p_229145_3_, AbstractClientPlayerEntity player, ModelRenderer p_229145_5_, ModelRenderer p_229145_6_) {
            PlayerModel playermodel = (PlayerModel)this.func_217764_d();
            this.setModelProperties(player);
            playermodel.field_217112_c = 0.0f;
            playermodel.field_228270_o_ = false;
            playermodel.field_205061_a = 0.0f;
            playermodel.func_225597_a_((LivingEntity)player, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
            p_229145_5_.field_78795_f = 0.0f;
            p_229145_5_.func_228308_a_(matrixStack, buffer.getBuffer(RenderType.func_228634_a_((ResourceLocation)player.func_110306_p())), p_229145_3_, OverlayTexture.field_229196_a_);
            p_229145_6_.field_78795_f = 0.0f;
            p_229145_6_.func_228308_a_(matrixStack, buffer.getBuffer(RenderType.func_228644_e_((ResourceLocation)player.func_110306_p())), p_229145_3_, OverlayTexture.field_229196_a_);
        }

        protected void setupRotations(AbstractClientPlayerEntity player, MatrixStack matrixStack, float p_225621_3_, float p_225621_4_, float partialTicks) {
            float f = player.func_205015_b(partialTicks);
            if (player.func_184613_cA()) {
                super.func_225621_a_((LivingEntity)player, matrixStack, p_225621_3_, p_225621_4_, partialTicks);
                float f1 = (float)player.func_184599_cB() + partialTicks;
                float f2 = MathHelper.func_76131_a((float)(f1 * f1 / 100.0f), (float)0.0f, (float)1.0f);
                if (!player.func_204805_cN()) {
                    matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(f2 * (-90.0f - player.field_70125_A)));
                }
                Vector3d vector3d = player.func_70676_i(partialTicks);
                Vector3d vector3d1 = player.func_213322_ci();
                double d0 = Entity.func_213296_b((Vector3d)vector3d1);
                double d1 = Entity.func_213296_b((Vector3d)vector3d);
                if (d0 > 0.0 && d1 > 0.0) {
                    double d2 = (vector3d1.field_72450_a * vector3d.field_72450_a + vector3d1.field_72449_c * vector3d.field_72449_c) / Math.sqrt(d0 * d1);
                    double d3 = vector3d1.field_72450_a * vector3d.field_72449_c - vector3d1.field_72449_c * vector3d.field_72450_a;
                    matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_((float)(Math.signum(d3) * Math.acos(d2))));
                }
            } else if (f > 0.0f) {
                super.func_225621_a_((LivingEntity)player, matrixStack, p_225621_3_, p_225621_4_, partialTicks);
                float f3 = player.func_70090_H() ? -90.0f - player.field_70125_A : -90.0f;
                float f4 = MathHelper.func_219799_g((float)f, (float)0.0f, (float)f3);
                matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(f4));
                if (player.func_213314_bj()) {
                    matrixStack.func_227861_a_(0.0, -0.25, 0.25);
                }
            } else {
                super.func_225621_a_((LivingEntity)player, matrixStack, p_225621_3_, p_225621_4_, partialTicks);
            }
        }
    }

    public static class JarredModel<T extends LivingEntity>
    extends PlayerModel<T> {
        private final ModelRenderer eyeLeft;
        private final ModelRenderer eyeRight;

        public JarredModel() {
            super(0.0f, false);
            this.field_78090_t = 64;
            this.field_78089_u = 64;
            this.field_78115_e = new ModelRenderer((Model)this);
            this.field_78115_e.func_78793_a(0.0f, 0.0f, 0.0f);
            this.field_78115_e.func_78784_a(0, 0).func_228303_a_(-5.0f, -2.0f, -5.0f, 10.0f, 14.0f, 10.0f, 0.0f, false);
            this.field_78115_e.func_78784_a(40, 0).func_228303_a_(-3.0f, -4.0f, -3.0f, 6.0f, 3.0f, 6.0f, 0.0f, false);
            this.field_78115_e.func_78784_a(0, 24).func_228303_a_(-4.0f, 0.0f, -4.0f, 8.0f, 11.0f, 8.0f, 0.0f, false);
            this.field_178722_k = new ModelRenderer((Model)this);
            this.field_178722_k.func_78793_a(-1.9f, 12.0f, 0.0f);
            this.field_178722_k.func_78784_a(51, 1).func_228303_a_(3.9f, 0.0f, -1.0f, 1.0f, 5.0f, 2.0f, 0.0f, true);
            this.field_178721_j = new ModelRenderer((Model)this);
            this.field_178721_j.func_78793_a(1.9f, 12.0f, 0.0f);
            this.field_178721_j.func_78784_a(46, 1).func_228303_a_(-4.9f, 0.0f, -1.0f, 1.0f, 5.0f, 2.0f, 0.0f, false);
            this.field_78116_c = new ModelRenderer((Model)this);
            this.eyeRight = new ModelRenderer((Model)this);
            this.eyeLeft = new ModelRenderer((Model)this);
            this.field_78116_c.func_78793_a(0.0f, 5.0f, 0.0f);
            this.field_78116_c.func_78784_a(42, 10).func_228303_a_(-3.0f, -2.999f, -1.5f, 6.0f, 3.0f, 3.0f, 0.0f, false);
            this.field_78116_c.func_78784_a(45, 12).func_228303_a_(-2.0f, -2.999f, 1.5f, 4.0f, 3.0f, 1.0f, 0.0f, false);
            this.field_78116_c.func_78784_a(40, 16).func_228303_a_(-2.0f, 0.0f, -0.5f, 4.0f, 1.0f, 3.0f, 0.0f, false);
            this.field_78116_c.func_78784_a(40, 20).func_228303_a_(-1.0f, 1.0f, 0.5f, 2.0f, 1.0f, 2.0f, 0.0f, false);
            this.eyeRight.func_78784_a(30, 6).func_228303_a_(1.0f, 0.0f, -2.499f, 2.0f, 2.0f, 2.0f, 0.0f, false);
            this.eyeLeft.func_78784_a(30, 6).func_228303_a_(-3.0f, -1.0f, -2.499f, 2.0f, 2.0f, 2.0f, 0.0f, false);
            this.field_78116_c.func_78792_a(this.eyeLeft);
            this.field_78116_c.func_78792_a(this.eyeRight);
        }

        public void func_225599_a_(HandSide handSide, MatrixStack matrixStack) {
            matrixStack.func_227861_a_(0.0, 0.8, -0.5);
            matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(90.0f));
            matrixStack.func_227862_a_(0.5f, 0.5f, 0.5f);
            ModelRenderer modelrenderer = this.func_187074_a(handSide);
            float f = 1.0f * (float)(handSide == HandSide.RIGHT ? 1 : -1);
            modelrenderer.field_78800_c += f;
            modelrenderer.field_78797_d -= 1.0f;
            modelrenderer.field_78798_e += 1.0f;
            modelrenderer.field_78798_e -= 1.0f;
        }

        public void func_225598_a_(MatrixStack matrixStack, IVertexBuilder p_225598_2_, int p_225598_3_, int p_225598_4_, float p_225598_5_, float p_225598_6_, float p_225598_7_, float p_225598_8_) {
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_(0.0, this.field_217113_d ? -0.5 : 0.5, 0.0);
            super.func_225598_a_(matrixStack, p_225598_2_, p_225598_3_, p_225598_4_, p_225598_5_, p_225598_6_, p_225598_7_, p_225598_8_);
            matrixStack.func_227865_b_();
        }

        public void func_225597_a_(T player, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
            super.func_225597_a_(player, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
            if (this.field_205061_a > 0.0f && player.func_213314_bj()) {
                this.field_78115_e.field_78796_g = this.func_205060_a(limbSwing, this.field_78115_e.field_78796_g, -0.10471976f);
            }
            this.field_78116_c.field_78797_d = 6.0f + MathHelper.func_76126_a((float)(limbSwing / 3.0f)) / 2.0f;
            this.eyeRight.field_78800_c = MathHelper.func_76134_b((float)(ageInTicks / 16.0f)) / 4.0f;
            this.eyeRight.field_78797_d = MathHelper.func_76126_a((float)(ageInTicks / 7.0f)) / 4.0f;
            this.eyeLeft.field_78800_c = MathHelper.func_76134_b((float)(ageInTicks / 12.0f)) / 4.0f;
            this.eyeLeft.field_78797_d = MathHelper.func_76134_b((float)(ageInTicks / 7.0f)) / 4.0f;
        }
    }

    public static class JarredRenderer
    extends LivingRenderer<AbstractClientPlayerEntity, JarredModel<AbstractClientPlayerEntity>> {
        private float axisFacing = 0.0f;
        private boolean wasCrouching = false;

        public JarredRenderer(EntityRendererManager mgr) {
            super(mgr, new JarredModel(), 0.0125f);
            this.field_76987_f = 0.0f;
            this.field_76989_e = 0.0f;
            this.func_177094_a((LayerRenderer)new HeldItemLayer((IEntityRenderer)this));
            this.func_177094_a((LayerRenderer)new PickleArmor(this, new BipedModel(1.0f)));
            this.func_177094_a((LayerRenderer)new ArrowLayer((LivingRenderer)this));
            this.func_177094_a((LayerRenderer)new PickleElytra(this));
            this.func_177094_a((LayerRenderer)new BeeStingerLayer((LivingRenderer)this));
        }

        public ResourceLocation getTextureLocation(AbstractClientPlayerEntity player) {
            return Textures.JAR_MAN;
        }

        protected boolean shouldShowName(AbstractClientPlayerEntity player) {
            return !player.func_213453_ef() && super.func_177070_b((LivingEntity)player);
        }

        protected void scale(AbstractClientPlayerEntity player, MatrixStack stack, float partialTickTime) {
            stack.func_227862_a_(1.0f, 1.0f, 1.0f);
        }

        public void render(AbstractClientPlayerEntity player, float p_225623_2_, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer p_225623_5_, int p_225623_6_) {
            this.setModelProperties(player);
            if (this.wasCrouching) {
                float f = (MathHelper.func_219805_h((float)partialTicks, (float)player.field_70760_ar, (float)player.field_70761_aq) + this.axisFacing) % 360.0f;
                matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(f));
                matrixStack.func_227861_a_(0.0, -0.125, 0.0);
            }
            super.func_225623_a_((LivingEntity)player, p_225623_2_, partialTicks, matrixStack, p_225623_5_, p_225623_6_);
        }

        public Vector3d getRenderOffset(AbstractClientPlayerEntity player, float p_225627_2_) {
            return player.func_213453_ef() ? new Vector3d(0.0, -0.5, 0.0) : new Vector3d(0.0, -0.25, 0.0);
        }

        private void setModelProperties(AbstractClientPlayerEntity player) {
            PlayerModel playermodel = (PlayerModel)this.func_217764_d();
            playermodel.func_178719_a(false);
            boolean c = player.func_213453_ef();
            playermodel.field_78115_e.field_78806_j = true;
            playermodel.field_78116_c.field_78806_j = true;
            playermodel.field_178722_k.field_78806_j = !c;
            boolean bl = playermodel.field_178721_j.field_78806_j = !c;
            if (this.wasCrouching != c && c) {
                this.axisFacing = -player.func_174811_aO().func_185119_l();
            }
            this.wasCrouching = c;
            BipedModel.ArmPose poseRightArm = JarredRenderer.getArmPose(player, Hand.MAIN_HAND);
            BipedModel.ArmPose poseLeftArm = JarredRenderer.getArmPose(player, Hand.OFF_HAND);
            if (poseRightArm.func_241657_a_()) {
                BipedModel.ArmPose armPose = poseLeftArm = player.func_184592_cb().func_190926_b() ? BipedModel.ArmPose.EMPTY : BipedModel.ArmPose.ITEM;
            }
            if (player.func_184591_cq() == HandSide.RIGHT) {
                playermodel.field_187076_m = poseRightArm;
                playermodel.field_187075_l = poseLeftArm;
            } else {
                playermodel.field_187076_m = poseLeftArm;
                playermodel.field_187075_l = poseRightArm;
            }
        }

        private static BipedModel.ArmPose getArmPose(AbstractClientPlayerEntity player, Hand hand) {
            ItemStack itemstack = player.func_184586_b(hand);
            if (itemstack.func_190926_b()) {
                return BipedModel.ArmPose.EMPTY;
            }
            if (player.func_184600_cs() == hand && player.func_184605_cv() > 0) {
                UseAction useaction = itemstack.func_77975_n();
                if (useaction == UseAction.BLOCK) {
                    return BipedModel.ArmPose.BLOCK;
                }
                if (useaction == UseAction.BOW) {
                    return BipedModel.ArmPose.BOW_AND_ARROW;
                }
                if (useaction == UseAction.SPEAR) {
                    return BipedModel.ArmPose.THROW_SPEAR;
                }
                if (useaction == UseAction.CROSSBOW && hand == player.func_184600_cs()) {
                    return BipedModel.ArmPose.CROSSBOW_CHARGE;
                }
            } else if (!player.field_82175_bq && itemstack.func_77973_b() == Items.field_222114_py && CrossbowItem.func_220012_d((ItemStack)itemstack)) {
                return BipedModel.ArmPose.CROSSBOW_HOLD;
            }
            return BipedModel.ArmPose.ITEM;
        }

        protected void renderNameTag(AbstractClientPlayerEntity player, ITextComponent name, MatrixStack matrixStack, IRenderTypeBuffer buffer, int p_225629_5_) {
            Scoreboard scoreboard;
            ScoreObjective scoreobjective;
            double d0 = this.field_76990_c.func_229099_b_((Entity)player);
            matrixStack.func_227860_a_();
            if (d0 < 100.0 && (scoreobjective = (scoreboard = player.func_96123_co()).func_96539_a(2)) != null) {
                Score score = scoreboard.func_96529_a(player.func_195047_I_(), scoreobjective);
                super.func_225629_a_((Entity)player, (ITextComponent)new StringTextComponent(Integer.toString(score.func_96652_c())).func_240702_b_(" ").func_230529_a_(scoreobjective.func_96678_d()), matrixStack, buffer, p_225629_5_);
                matrixStack.func_227861_a_(0.0, (double)0.25875f, 0.0);
            }
            super.func_225629_a_((Entity)player, name, matrixStack, buffer, p_225629_5_);
            matrixStack.func_227865_b_();
        }

        public void renderRightHand(MatrixStack p_229144_1_, IRenderTypeBuffer p_229144_2_, int p_229144_3_, AbstractClientPlayerEntity p_229144_4_) {
            this.renderHand(p_229144_1_, p_229144_2_, p_229144_3_, p_229144_4_, ((JarredModel)this.field_77045_g).field_178723_h, ((JarredModel)this.field_77045_g).field_178732_b);
        }

        public void renderLeftHand(MatrixStack p_229146_1_, IRenderTypeBuffer p_229146_2_, int p_229146_3_, AbstractClientPlayerEntity p_229146_4_) {
            this.renderHand(p_229146_1_, p_229146_2_, p_229146_3_, p_229146_4_, ((JarredModel)this.field_77045_g).field_178724_i, ((JarredModel)this.field_77045_g).field_178734_a);
        }

        private void renderHand(MatrixStack matrixStack, IRenderTypeBuffer buffer, int p_229145_3_, AbstractClientPlayerEntity player, ModelRenderer p_229145_5_, ModelRenderer p_229145_6_) {
            PlayerModel playermodel = (PlayerModel)this.func_217764_d();
            this.setModelProperties(player);
            playermodel.field_217112_c = 0.0f;
            playermodel.field_228270_o_ = false;
            playermodel.field_205061_a = 0.0f;
            playermodel.func_225597_a_((LivingEntity)player, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f);
            p_229145_5_.field_78795_f = 0.0f;
            p_229145_5_.func_228308_a_(matrixStack, buffer.getBuffer(RenderType.func_228634_a_((ResourceLocation)player.func_110306_p())), p_229145_3_, OverlayTexture.field_229196_a_);
            p_229145_6_.field_78795_f = 0.0f;
            p_229145_6_.func_228308_a_(matrixStack, buffer.getBuffer(RenderType.func_228644_e_((ResourceLocation)player.func_110306_p())), p_229145_3_, OverlayTexture.field_229196_a_);
        }

        protected void setupRotations(AbstractClientPlayerEntity player, MatrixStack matrixStack, float p_225621_3_, float p_225621_4_, float p_225621_5_) {
            float f = player.func_205015_b(p_225621_5_);
            if (player.func_184613_cA()) {
                super.func_225621_a_((LivingEntity)player, matrixStack, p_225621_3_, p_225621_4_, p_225621_5_);
                float f1 = (float)player.func_184599_cB() + p_225621_5_;
                float f2 = MathHelper.func_76131_a((float)(f1 * f1 / 100.0f), (float)0.0f, (float)1.0f);
                if (!player.func_204805_cN()) {
                    matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(f2 * (-90.0f - player.field_70125_A)));
                }
                Vector3d vector3d = player.func_70676_i(p_225621_5_);
                Vector3d vector3d1 = player.func_213322_ci();
                double d0 = Entity.func_213296_b((Vector3d)vector3d1);
                double d1 = Entity.func_213296_b((Vector3d)vector3d);
                if (d0 > 0.0 && d1 > 0.0) {
                    double d2 = (vector3d1.field_72450_a * vector3d.field_72450_a + vector3d1.field_72449_c * vector3d.field_72449_c) / Math.sqrt(d0 * d1);
                    double d3 = vector3d1.field_72450_a * vector3d.field_72449_c - vector3d1.field_72449_c * vector3d.field_72450_a;
                    matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_((float)(Math.signum(d3) * Math.acos(d2))));
                }
            } else if (f > 0.0f) {
                super.func_225621_a_((LivingEntity)player, matrixStack, p_225621_3_, p_225621_4_, p_225621_5_);
                float f3 = player.func_70090_H() ? -90.0f - player.field_70125_A : -90.0f;
                float f4 = MathHelper.func_219799_g((float)f, (float)0.0f, (float)f3);
                matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(f4));
                if (player.func_213314_bj()) {
                    matrixStack.func_227861_a_(0.0, -0.25, 0.25);
                }
            } else {
                super.func_225621_a_((LivingEntity)player, matrixStack, p_225621_3_, p_225621_4_, p_225621_5_);
            }
        }
    }
}

