/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.client.renderers.tiles;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import com.mojang.blaze3d.vertex.VertexBuilderUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.mehvahdjukaar.selene.blocks.ItemDisplayTile;
import net.mehvahdjukaar.supplementaries.block.blocks.BookPileBlock;
import net.mehvahdjukaar.supplementaries.block.blocks.BookPileHorizontalBlock;
import net.mehvahdjukaar.supplementaries.block.tiles.BookPileBlockTile;
import net.mehvahdjukaar.supplementaries.client.Materials;
import net.mehvahdjukaar.supplementaries.client.renderers.Const;
import net.mehvahdjukaar.supplementaries.common.Textures;
import net.mehvahdjukaar.supplementaries.compat.CompatHandler;
import net.mehvahdjukaar.supplementaries.compat.enchantedbooks.EnchantedBookRedesignRenderer;
import net.mehvahdjukaar.supplementaries.compat.quark.QuarkPlugin;
import net.mehvahdjukaar.supplementaries.configs.ClientConfigs;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.tileentity.TileEntityRenderer;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;

public class BookPileBlockTileRenderer
extends TileEntityRenderer<BookPileBlockTile> {
    private final ModelRenderer book = new ModelRenderer(32, 32, 0, 0);
    private final ModelRenderer lock = new ModelRenderer(32, 32, 0, 0);
    private final boolean vertical;

    public BookPileBlockTileRenderer(TileEntityRendererDispatcher rendererDispatcherIn) {
        this(rendererDispatcherIn, false);
    }

    public BookPileBlockTileRenderer(TileEntityRendererDispatcher rendererDispatcherIn, boolean vertical) {
        super(rendererDispatcherIn);
        this.vertical = vertical;
        this.book.func_78784_a(0, 0).func_228303_a_(-2.0f, -5.0f, -4.0f, 4.0f, 10.0f, 7.0f, 0.0f, false);
        this.book.func_78784_a(28, 6).func_228303_a_(1.0f, -5.0f, 3.0f, 1.0f, 10.0f, 1.0f, 0.0f, false);
        this.book.func_78784_a(23, 6).func_228303_a_(-2.0f, -5.0f, 3.0f, 1.0f, 10.0f, 1.0f, 0.0f, false);
        this.lock.func_78784_a(0, 0).func_228303_a_(-1.0f, -1.0f, 3.0f, 2.0f, 2.0f, 1.0f, 0.0f, false);
        this.book.func_78792_a(this.lock);
    }

    public void render(BookPileBlockTile tile, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer bufferIn, int light, int overlay) {
        long r = tile.func_174877_v().func_218275_a();
        Random rand = new Random(r);
        BlockState state = tile.func_195044_w();
        matrixStack.func_227861_a_(0.5, 0.5, 0.5);
        if (tile.horizontal) {
            this.renderHorizontal(state, matrixStack, bufferIn, light, overlay, rand);
        } else {
            this.renderVertical(tile, state, matrixStack, bufferIn, light, overlay, rand);
        }
    }

    private void renderHorizontal(BlockState state, MatrixStack matrixStack, IRenderTypeBuffer buffer, int light, int overlay, Random random) {
        int books = (Integer)state.func_177229_b((Property)BookPileBlock.BOOKS);
        Direction dir = (Direction)state.func_177229_b((Property)BookPileHorizontalBlock.FACING);
        matrixStack.func_227863_a_(Const.rot(dir));
        matrixStack.func_227863_a_(Const.X90);
        matrixStack.func_227861_a_(0.0, 0.1875, 0.0);
        ArrayList<Textures.BookColor> colors = new ArrayList<Textures.BookColor>(Arrays.asList(Textures.BookColor.values()));
        this.lock.field_78806_j = false;
        float angle = -0.19634955f;
        switch (books) {
            default: {
                matrixStack.func_227861_a_(-0.375, 0.0, 0.0);
                this.renderBook(matrixStack, buffer, light, overlay, random, colors);
                matrixStack.func_227861_a_(0.25, 0.0, -0.0625);
                this.renderBook(matrixStack, buffer, light, overlay, random, colors);
                matrixStack.func_227861_a_(0.25, 0.0, 0.0625);
                this.renderBook(matrixStack, buffer, light, overlay, random, colors);
                matrixStack.func_227861_a_(0.25, 0.0, -0.0625);
                this.renderBook(matrixStack, buffer, light, overlay, random, colors);
                break;
            }
            case 3: {
                matrixStack.func_227861_a_(-0.3125, 0.0, 0.0);
                this.renderBook(matrixStack, buffer, light, overlay, random, colors);
                matrixStack.func_227861_a_(0.25, 0.0, -0.0625);
                this.renderBook(matrixStack, buffer, light, overlay, random, colors);
                matrixStack.func_227861_a_(0.3125, 0.0, 0.0625);
                this.book.field_78808_h = angle;
                this.renderBook(matrixStack, buffer, light, overlay, random, colors);
                this.book.field_78808_h = 0.0f;
                break;
            }
            case 2: {
                matrixStack.func_227861_a_(-0.1875, 0.0, 0.0);
                this.renderBook(matrixStack, buffer, light, overlay, random, colors);
                matrixStack.func_227861_a_(0.3125, 0.0, 0.0625);
                this.book.field_78808_h = angle;
                this.renderBook(matrixStack, buffer, light, overlay, random, colors);
                this.book.field_78808_h = 0.0f;
                break;
            }
            case 1: {
                this.renderBook(matrixStack, buffer, light, overlay, random, colors);
            }
        }
        this.lock.field_78806_j = true;
    }

    private void renderVertical(ItemDisplayTile inventory, BlockState state, MatrixStack matrixStack, IRenderTypeBuffer buffer, int light, int overlay, Random random) {
        int books = (Integer)state.func_177229_b((Property)BookPileBlock.BOOKS);
        boolean glint = ClientConfigs.cached.BOOK_GLINT;
        boolean coloredGlint = CompatHandler.enchantedbookredesign;
        matrixStack.func_227861_a_(0.0, -0.375, 0.0);
        this.book.field_78808_h = 1.5707964f;
        for (int i = 0; i < books; ++i) {
            this.book.field_78795_f = (float)((double)random.nextInt(32) * Math.PI / 16.0);
            IVertexBuilder builder = this.getBuilderWithFoil(inventory.func_70301_a(i), buffer, glint, coloredGlint);
            this.book.func_228308_a_(matrixStack, builder, light, overlay);
            matrixStack.func_227861_a_(0.0, 0.25, 0.0);
        }
        this.book.field_78795_f = 0.0f;
        this.book.field_78808_h = 0.0f;
    }

    private IVertexBuilder getBuilderWithFoil(ItemStack stack, IRenderTypeBuffer buffer, boolean glint, boolean color) {
        RenderMaterial mat;
        RenderMaterial renderMaterial = mat = CompatHandler.quark && QuarkPlugin.isTome(stack.func_77973_b()) ? Materials.BOOK_TOME_MATERIAL : Materials.BOOK_ENCHANTED_MATERIAL;
        if (glint) {
            IVertexBuilder foilBuilder = null;
            if (color) {
                foilBuilder = EnchantedBookRedesignRenderer.getColoredFoil(stack, buffer);
            }
            if (foilBuilder == null) {
                foilBuilder = buffer.getBuffer(RenderType.func_228655_k_());
            }
            return VertexBuilderUtils.func_227915_a_((IVertexBuilder)foilBuilder, (IVertexBuilder)mat.func_229311_a_(buffer, RenderType::func_228634_a_));
        }
        return mat.func_229311_a_(buffer, RenderType::func_228634_a_);
    }

    private void renderBook(MatrixStack matrixStack, IRenderTypeBuffer buffer, int light, int overlay, Random random, List<Textures.BookColor> colors) {
        int ind = random.nextInt(colors.size());
        Textures.BookColor color = colors.remove(ind);
        IVertexBuilder builder = Materials.BOOK_MATERIALS.get((Object)color).func_229311_a_(buffer, RenderType::func_228634_a_);
        this.book.func_228308_a_(matrixStack, builder, light, overlay);
    }
}

