/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.compat.create.behaviors;

import com.simibubi.create.content.contraptions.components.structureMovement.MovementBehaviour;
import com.simibubi.create.content.contraptions.components.structureMovement.MovementContext;
import com.simibubi.create.content.contraptions.components.structureMovement.render.ContraptionMatrices;
import com.simibubi.create.foundation.utility.worldWrappers.PlacementSimulationWorld;
import java.util.Map;
import java.util.function.UnaryOperator;
import net.mehvahdjukaar.supplementaries.block.blocks.HourGlassBlock;
import net.mehvahdjukaar.supplementaries.block.tiles.HourGlassBlockTile;
import net.mehvahdjukaar.supplementaries.client.renderers.tiles.HourGlassBlockTileRenderer;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.template.Template;

public class HourglassBehavior
extends MovementBehaviour {
    public static void changeState(MovementContext context, BlockState newState) {
        context.state = newState;
        Map blocks = context.contraption.getBlocks();
        if (blocks.containsKey(context.localPos)) {
            Template.BlockInfo info = (Template.BlockInfo)blocks.get(context.localPos);
            Template.BlockInfo newInfo = new Template.BlockInfo(info.field_186242_a, context.state, info.field_186244_c);
            blocks.remove(context.localPos);
            blocks.put(context.localPos, newInfo);
        }
    }

    public void tick(MovementContext context) {
        UnaryOperator rot = context.rotation;
        BlockState state = context.state;
        Direction dir = (Direction)state.func_177229_b((Property)HourGlassBlock.FACING);
        Vector3i in = dir.func_176730_m();
        Vector3d v = new Vector3d((double)in.func_177958_n(), (double)in.func_177956_o(), (double)in.func_177952_p());
        Vector3d v2 = (Vector3d)rot.apply(v);
        double dot = v2.func_72430_b(new Vector3d(0.0, 1.0, 0.0));
        CompoundNBT com = context.tileData;
        HourGlassBlockTile.HourGlassSandType sandType = HourGlassBlockTile.HourGlassSandType.values()[com.func_74762_e("SandType")];
        float progress = com.func_74760_g("Progress");
        float prevProgress = com.func_74760_g("PrevProgress");
        if (!sandType.isEmpty()) {
            prevProgress = progress;
            if (dot > 0.0 && progress != 1.0f) {
                progress = Math.min(progress + sandType.increment, 1.0f);
            } else if (dot < 0.0 && progress != 0.0f) {
                progress = Math.max(progress - sandType.increment, 0.0f);
            }
        }
        com.func_82580_o("Progress");
        com.func_82580_o("PrevProgress");
        com.func_74776_a("Progress", progress);
        com.func_74776_a("PrevProgress", prevProgress);
    }

    public void renderInContraption(MovementContext context, PlacementSimulationWorld renderWorld, ContraptionMatrices matrices, IRenderTypeBuffer buffer) {
        CompoundNBT com = context.tileData;
        HourGlassBlockTile.HourGlassSandType sandType = HourGlassBlockTile.HourGlassSandType.values()[com.func_74762_e("SandType")];
        float progress = com.func_74760_g("Progress");
        float prevProgress = com.func_74760_g("PrevProgress");
        NonNullList stacks = NonNullList.func_191197_a((int)1, (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((CompoundNBT)com, (NonNullList)stacks);
        float partialTicks = 1.0f;
        if (sandType.isEmpty()) {
            return;
        }
        Vector3d v = context.position;
        if (v == null) {
            v = new Vector3d(0.0, 0.0, 0.0);
        }
        BlockPos pos = new BlockPos(v);
        int light = WorldRenderer.func_228421_a_((IBlockDisplayReader)context.world, (BlockPos)pos);
        TextureAtlasSprite sprite = sandType.getSprite((ItemStack)stacks.get(0), (World)renderWorld);
        float h = MathHelper.func_219799_g((float)partialTicks, (float)prevProgress, (float)progress);
        Direction dir = (Direction)context.state.func_177229_b((Property)HourGlassBlock.FACING);
        HourGlassBlockTileRenderer.renderSand(matrices.getModelViewProjection(), buffer, light, 0, sprite, h, dir);
    }
}

