/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.inventories;

import net.mehvahdjukaar.supplementaries.configs.ServerConfigs;
import net.mehvahdjukaar.supplementaries.inventories.SackSlot;
import net.mehvahdjukaar.supplementaries.setup.ModRegistry;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;

public class SackContainer
extends Container {
    public final IInventory inventory;
    private static final int[][] TARGET_RATIOS = new int[][]{{1, 1}, {2, 2}, {3, 3}, {4, 2}, {5, 2}, {6, 2}, {7, 2}, {8, 2}, {8, 2}, {9, 2}, {10, 2}, {7, 3}, {8, 3}, {9, 3}};

    public SackContainer(int id, PlayerInventory playerInventory, PacketBuffer packetBuffer) {
        this(id, playerInventory);
    }

    public SackContainer(int id, PlayerInventory playerInventory) {
        this(id, playerInventory, (IInventory)new Inventory(27));
    }

    public SackContainer(int id, PlayerInventory playerInventory, IInventory inventory) {
        super((ContainerType)ModRegistry.SACK_CONTAINER.get(), id);
        int si;
        this.inventory = inventory;
        SackContainer.func_216962_a((IInventory)inventory, (int)27);
        inventory.func_174889_b(playerInventory.field_70458_d);
        int size = ServerConfigs.cached.SACK_SLOTS;
        int[] dims = SackContainer.getRatio(size);
        if (dims[0] > 9) {
            dims[0] = 9;
            dims[1] = (int)Math.ceil((float)size / 9.0f);
        }
        int yp = 44 - 9 * dims[1];
        for (int h = 0; h < dims[1]; ++h) {
            int dimx = Math.min(dims[0], size);
            int xp = 89 - dimx * 18 / 2;
            for (int j = 0; j < dimx; ++j) {
                this.func_75146_a(new SackSlot(inventory, j + h * dimx, xp + j * 18, yp + 18 * h));
            }
            size -= dims[0];
        }
        for (si = 0; si < 3; ++si) {
            for (int sj = 0; sj < 9; ++sj) {
                this.func_75146_a(new Slot((IInventory)playerInventory, sj + (si + 1) * 9, 8 + sj * 18, 84 + si * 18));
            }
        }
        for (si = 0; si < 9; ++si) {
            this.func_75146_a(new Slot((IInventory)playerInventory, si, 8 + si * 18, 142));
        }
    }

    public boolean func_75145_c(PlayerEntity playerIn) {
        return this.inventory.func_70300_a(playerIn);
    }

    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        ItemStack itemstack = ItemStack.field_190927_a;
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot != null && slot.func_75216_d()) {
            ItemStack itemstack1 = slot.func_75211_c();
            itemstack = itemstack1.func_77946_l();
            int activeSlots = 5 + ServerConfigs.cached.SACK_SLOTS * 2;
            if (index < activeSlots ? !this.func_75135_a(itemstack1, activeSlots, this.field_75151_b.size(), true) : !this.func_75135_a(itemstack1, 0, activeSlots, false)) {
                return ItemStack.field_190927_a;
            }
            if (itemstack1.func_190926_b()) {
                slot.func_75215_d(ItemStack.field_190927_a);
            } else {
                slot.func_75218_e();
            }
        }
        return itemstack;
    }

    public void func_75134_a(PlayerEntity playerIn) {
        super.func_75134_a(playerIn);
        this.inventory.func_174886_c(playerIn);
    }

    public static int[] getRatio(int size) {
        int[] dims = new int[]{Math.min(size, 23), Math.max(size / 23, 1)};
        for (int[] testAgainst : TARGET_RATIOS) {
            if (testAgainst[0] * testAgainst[1] != size) continue;
            dims = testAgainst;
            break;
        }
        return dims;
    }
}

