/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.network;

import java.util.Objects;
import java.util.function.Supplier;
import net.mehvahdjukaar.supplementaries.block.tiles.PresentBlockTile;
import net.minecraft.block.BlockState;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkEvent;

public class UpdateServerPresentPacket {
    private final BlockPos pos;
    private final boolean packed;
    private final String sender;
    private final String recipient;

    public UpdateServerPresentPacket(PacketBuffer buf) {
        this.pos = buf.func_179259_c();
        this.packed = buf.readBoolean();
        this.recipient = buf.func_218666_n();
        this.sender = buf.func_218666_n();
    }

    public UpdateServerPresentPacket(BlockPos pos, boolean packed, String recipient, String sender) {
        this.pos = pos;
        this.packed = packed;
        this.recipient = recipient;
        this.sender = sender;
    }

    public static void buffer(UpdateServerPresentPacket message, PacketBuffer buf) {
        buf.func_179255_a(message.pos);
        buf.writeBoolean(message.packed);
        buf.func_180714_a(message.recipient);
        buf.func_180714_a(message.sender);
    }

    public static void handler(UpdateServerPresentPacket message, Supplier<NetworkEvent.Context> ctx) {
        World world = Objects.requireNonNull(ctx.get().getSender()).field_70170_p;
        ctx.get().enqueueWork(() -> {
            if (world != null) {
                BlockPos pos = message.pos;
                TileEntity tileentity = world.func_175625_s(message.pos);
                if (tileentity instanceof PresentBlockTile) {
                    PresentBlockTile present = (PresentBlockTile)tileentity;
                    world.func_184133_a(null, message.pos, SoundEvents.field_219701_mI, SoundCategory.BLOCKS, 1.0f, 1.3f);
                    present.pack(message.recipient, message.sender, message.packed);
                    BlockState state = world.func_180495_p(pos);
                    world.func_184138_a(pos, state, state, 3);
                    tileentity.func_70296_d();
                }
            }
        });
        ctx.get().setPacketHandled(true);
    }
}

