/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.world.data.map.markers;

import java.util.Objects;
import javax.annotation.Nullable;
import net.mehvahdjukaar.selene.map.CustomDecoration;
import net.mehvahdjukaar.selene.map.markers.MapWorldMarker;
import net.mehvahdjukaar.supplementaries.world.data.map.CMDreg;
import net.minecraft.block.BedBlock;
import net.minecraft.item.DyeColor;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.BedTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;

public class BedMarker
extends MapWorldMarker<CustomDecoration> {
    private DyeColor color;

    public BedMarker() {
        super(CMDreg.BED_DECORATION_TYPE);
    }

    public BedMarker(BlockPos pos, DyeColor color) {
        this();
        this.setPos(pos);
        this.color = color;
    }

    public CompoundNBT saveToNBT(CompoundNBT compoundnbt) {
        super.saveToNBT(compoundnbt);
        compoundnbt.func_74778_a("Color", this.color.func_176762_d());
        return compoundnbt;
    }

    public void loadFromNBT(CompoundNBT compound) {
        super.loadFromNBT(compound);
        this.color = DyeColor.func_204271_a((String)compound.func_74779_i("Color"), (DyeColor)DyeColor.WHITE);
    }

    @Nullable
    public static BedMarker getFromWorld(IBlockReader world, BlockPos pos) {
        TileEntity tileentity = world.func_175625_s(pos);
        if (tileentity instanceof BedTileEntity) {
            DyeColor dyecolor = ((BedBlock)tileentity.func_195044_w().func_177230_c()).func_196350_d();
            return new BedMarker(pos, dyecolor);
        }
        return null;
    }

    @Nullable
    public CustomDecoration doCreateDecoration(byte mapX, byte mapY, byte rot) {
        return new CustomDecoration(this.getType(), mapX, mapY, rot, null);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other != null && ((Object)((Object)this)).getClass() == other.getClass()) {
            BedMarker marker = (BedMarker)((Object)other);
            return Objects.equals(this.getPos(), marker.getPos()) && this.color == marker.color;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.getPos(), this.color);
    }
}

