/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.entity.monster;

import cofh.thermal.core.ThermalCore;
import cofh.thermal.core.entity.projectile.BlitzProjectileEntity;
import cofh.thermal.core.init.TCoreSounds;
import cofh.thermal.lib.common.ThermalConfig;
import cofh.thermal.lib.common.ThermalFlags;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.FlyingMovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;

public class BlitzEntity
extends MonsterEntity {
    private static final DataParameter<Byte> ANGRY = EntityDataManager.func_187226_a(BlitzEntity.class, (IDataSerializer)DataSerializers.field_187191_a);

    public static boolean canSpawn(EntityType<BlitzEntity> entityType, IServerWorld world, SpawnReason reason, BlockPos pos, Random rand) {
        return ThermalFlags.getFlag(ThermalFlags.FLAG_MOB_BLITZ).getAsBoolean() && MonsterEntity.func_223325_c(entityType, (IServerWorld)world, (SpawnReason)reason, (BlockPos)pos, (Random)rand);
    }

    public BlitzEntity(EntityType<? extends BlitzEntity> type, World world) {
        super(type, world);
        this.field_70765_h = new FlyingMovementController((MobEntity)this, 20, true);
        this.func_184644_a(PathNodeType.WATER, -1.0f);
        this.func_184644_a(PathNodeType.LAVA, -1.0f);
        this.field_70728_aV = 10;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(4, (Goal)new BlitzAttackGoal(this));
        this.field_70714_bg.func_75776_a(5, (Goal)new MoveTowardsRestrictionGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0, 0.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(8, (Goal)new SwimGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233823_f_, 6.0).func_233815_a_(Attributes.field_233821_d_, (double)0.23f).func_233815_a_(Attributes.field_233822_e_, (double)0.6f).func_233815_a_(Attributes.field_233819_b_, 48.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ANGRY, (Object)0);
    }

    protected SoundEvent func_184639_G() {
        return ThermalConfig.mobAmbientSounds ? TCoreSounds.SOUND_BLITZ_AMBIENT : null;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return TCoreSounds.SOUND_BLITZ_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return TCoreSounds.SOUND_BLITZ_DEATH;
    }

    public void func_70636_d() {
        if (!this.field_70122_E && this.func_213322_ci().field_72448_b < 0.0) {
            this.func_213317_d(this.func_213322_ci().func_216372_d(1.0, 0.6, 1.0));
        }
        if (this.field_70170_p.field_72995_K && this.field_70146_Z.nextInt(2) == 0) {
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197613_f, this.func_226282_d_(0.5), this.func_226279_cv_(), this.func_226287_g_(0.5), 0.0, 0.0, 0.0);
        }
        super.func_70636_d();
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)ThermalCore.ITEMS.get("blitz_spawn_egg"));
    }

    public boolean func_180431_b(DamageSource source) {
        return source == DamageSource.field_180137_b || source.field_76373_n.equals("blitz") || super.func_180431_b(source);
    }

    public boolean isAngry() {
        return ((Byte)this.field_70180_af.func_187225_a(ANGRY) & 1) != 0;
    }

    protected void setAngry(boolean angry) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(ANGRY);
        b0 = angry ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.field_70180_af.func_187227_b(ANGRY, (Object)b0);
    }

    static class BlitzAttackGoal
    extends Goal {
        private final BlitzEntity blitz;
        private int attackTime;
        private int chaseStep;

        public BlitzAttackGoal(BlitzEntity blitzIn) {
            this.blitz = blitzIn;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            LivingEntity target = this.blitz.func_70638_az();
            return target != null && target.func_70089_S() && this.blitz.func_213336_c(target);
        }

        public void func_75249_e() {
        }

        public void func_75251_c() {
            this.blitz.setAngry(false);
            this.chaseStep = 0;
        }

        public void func_75246_d() {
            --this.attackTime;
            LivingEntity target = this.blitz.func_70638_az();
            if (target == null) {
                return;
            }
            Vector3d pos = this.blitz.func_174824_e(0.5f);
            Vector3d targetPos = target.func_213303_ch().func_72441_c(0.0, (double)(target.func_213302_cg() * 0.5f), 0.0);
            Vector3d diff = targetPos.func_178788_d(pos);
            double distSqr = this.blitz.func_70068_e((Entity)target);
            if (this.blitz.func_70635_at().func_75522_a((Entity)target) && distSqr < this.getFollowDistance() * this.getFollowDistance()) {
                this.chaseStep = 0;
                this.blitz.func_70671_ap().func_75651_a((Entity)target, 10.0f, 10.0f);
                if (distSqr < 4.0) {
                    if (this.attackTime <= 0) {
                        this.attackTime = 20;
                        this.blitz.func_70652_k((Entity)target);
                    }
                } else if (distSqr < 576.0) {
                    this.blitz.setAngry(true);
                    if (this.attackTime <= 0) {
                        this.attackTime = 20;
                        World world = this.blitz.field_70170_p;
                        world.func_184148_a(null, pos.field_72450_a + 0.5, pos.field_72448_b + 0.5, pos.field_72449_c + 0.5, TCoreSounds.SOUND_BLITZ_SHOOT, SoundCategory.HOSTILE, 1.0f, (this.blitz.field_70146_Z.nextFloat() - 0.5f) * 0.2f + 1.0f);
                        float gravity = 0.05f;
                        float horzSpeed = 0.8f;
                        double horzDist = MathHelper.func_76133_a((double)Entity.func_213296_b((Vector3d)diff));
                        double time = 1.25 * horzDist;
                        Vector3d horzVel = diff.func_186678_a((double)horzSpeed / horzDist);
                        BlitzProjectileEntity projectile = new BlitzProjectileEntity(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, 0.0, -gravity, 0.0, world);
                        projectile.func_213293_j(horzVel.field_72450_a, (double)gravity * time + diff.field_72448_b / time, horzVel.field_72449_c);
                        projectile.func_212361_a((Entity)this.blitz);
                        world.func_217376_c((Entity)projectile);
                    }
                    if (distSqr < 400.0) {
                        Vector3d want = new Vector3d(pos.field_72450_a - targetPos.field_72450_a, 0.0, pos.field_72449_c - targetPos.field_72449_c).func_72432_b().func_186678_a(30.0);
                        this.blitz.func_70605_aq().func_75642_a(pos.field_72450_a + want.field_72450_a, this.blitz.func_226278_cu_(), pos.field_72449_c + want.field_72449_c, 1.0);
                        this.blitz.func_70671_ap().func_75651_a((Entity)target, 10.0f, 10.0f);
                    }
                    return;
                }
            } else {
                this.blitz.setAngry(false);
            }
            if (this.chaseStep < 5) {
                ++this.chaseStep;
                this.blitz.func_70605_aq().func_75642_a(targetPos.field_72450_a, targetPos.field_72448_b, targetPos.field_72449_c, 1.0);
            }
            super.func_75246_d();
        }

        private double getFollowDistance() {
            return this.blitz.func_233637_b_(Attributes.field_233819_b_);
        }
    }
}

