/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.entity.monster;

import cofh.thermal.core.ThermalCore;
import cofh.thermal.core.entity.projectile.BlizzProjectileEntity;
import cofh.thermal.core.init.TCoreSounds;
import cofh.thermal.lib.common.ThermalConfig;
import cofh.thermal.lib.common.ThermalFlags;
import java.util.EnumSet;
import java.util.Random;
import net.minecraft.enchantment.FrostWalkerEnchantment;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.controller.FlyingMovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;

public class BlizzEntity
extends MonsterEntity {
    private static final DataParameter<Byte> ANGRY = EntityDataManager.func_187226_a(BlizzEntity.class, (IDataSerializer)DataSerializers.field_187191_a);

    public static boolean canSpawn(EntityType<BlizzEntity> entityType, IServerWorld world, SpawnReason reason, BlockPos pos, Random rand) {
        return ThermalFlags.getFlag(ThermalFlags.FLAG_MOB_BLIZZ).getAsBoolean() && MonsterEntity.func_223325_c(entityType, (IServerWorld)world, (SpawnReason)reason, (BlockPos)pos, (Random)rand);
    }

    public BlizzEntity(EntityType<? extends BlizzEntity> type, World world) {
        super(type, world);
        this.field_70765_h = new FlyingMovementController((MobEntity)this, 20, true);
        this.func_184644_a(PathNodeType.LAVA, -1.0f);
        this.field_70728_aV = 10;
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(4, (Goal)new BlizzAttackGoal(this));
        this.field_70714_bg.func_75776_a(5, (Goal)new MoveTowardsRestrictionGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MonsterEntity.func_234295_eP_().func_233815_a_(Attributes.field_233823_f_, 7.0).func_233815_a_(Attributes.field_233821_d_, (double)0.23f).func_233815_a_(Attributes.field_233822_e_, (double)0.6f).func_233815_a_(Attributes.field_233819_b_, 48.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(ANGRY, (Object)0);
    }

    protected SoundEvent func_184639_G() {
        return ThermalConfig.mobAmbientSounds ? TCoreSounds.SOUND_BLIZZ_AMBIENT : null;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return TCoreSounds.SOUND_BLIZZ_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return TCoreSounds.SOUND_BLIZZ_DEATH;
    }

    public void func_70636_d() {
        if (!this.field_70122_E && this.func_213322_ci().field_72448_b < 0.0) {
            this.func_213317_d(this.func_213322_ci().func_216372_d(1.0, 0.6, 1.0));
        }
        if (this.field_70170_p.field_72995_K && this.field_70146_Z.nextInt(2) == 0) {
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197593_D, this.func_226282_d_(0.5), this.func_226279_cv_(), this.func_226287_g_(0.5), 0.0, 0.0, 0.0);
        }
        super.func_70636_d();
    }

    protected void func_184594_b(BlockPos pos) {
        FrostWalkerEnchantment.func_185266_a((LivingEntity)this, (World)this.field_70170_p, (BlockPos)pos, (int)1);
        if (this.func_230295_b_(this.func_233568_aJ_())) {
            this.func_233641_cN_();
        }
        this.func_233642_cO_();
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        return super.func_70097_a(source, source.func_76347_k() ? amount + 3.0f : amount);
    }

    public boolean func_225503_b_(float distance, float damageMultiplier) {
        return false;
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack((IItemProvider)ThermalCore.ITEMS.get("blizz_spawn_egg"));
    }

    public boolean func_180431_b(DamageSource source) {
        return source.field_76373_n.equals("blizz") || super.func_180431_b(source);
    }

    public boolean isAngry() {
        return ((Byte)this.field_70180_af.func_187225_a(ANGRY) & 1) != 0;
    }

    protected void setAngry(boolean angry) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(ANGRY);
        b0 = angry ? (byte)(b0 | 1) : (byte)(b0 & 0xFFFFFFFE);
        this.field_70180_af.func_187227_b(ANGRY, (Object)b0);
    }

    static class BlizzAttackGoal
    extends Goal {
        private final BlizzEntity blizz;
        private final Vector3d[] hoverOffsets = BlizzAttackGoal.getHoverOffsets(new Vector3d(1.5, 2.25, 0.0), 16);
        private int attackTime;
        private int hoverStep;
        private int chaseStep;

        public BlizzAttackGoal(BlizzEntity blizzIn) {
            this.blizz = blizzIn;
            this.func_220684_a(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        }

        public boolean func_75250_a() {
            LivingEntity target = this.blizz.func_70638_az();
            return target != null && target.func_70089_S() && this.blizz.func_213336_c(target);
        }

        public void func_75249_e() {
        }

        public void func_75251_c() {
            this.blizz.setAngry(false);
            this.chaseStep = 0;
        }

        public void func_75246_d() {
            --this.attackTime;
            LivingEntity target = this.blizz.func_70638_az();
            if (target == null) {
                return;
            }
            Vector3d pos = this.blizz.func_213303_ch();
            Vector3d targetPos = target.func_174824_e(0.5f);
            Vector3d diff = pos.func_178788_d(targetPos);
            double distSqr = this.blizz.func_70068_e((Entity)target);
            double horzDistSqr = Entity.func_213296_b((Vector3d)diff);
            if (this.blizz.func_70635_at().func_75522_a((Entity)target) && distSqr < this.getFollowDistance() * this.getFollowDistance()) {
                this.chaseStep = 0;
                this.blizz.func_70671_ap().func_75651_a((Entity)target, 10.0f, 10.0f);
                if (distSqr < 4.0) {
                    if (this.attackTime <= 0) {
                        this.attackTime = 20;
                        this.blizz.func_70652_k((Entity)target);
                    }
                } else {
                    if (pos.field_72448_b > target.func_226278_cu_() + 2.0) {
                        this.blizz.setAngry(true);
                        if (this.attackTime <= 0) {
                            this.attackTime = 7;
                            Random rand = this.blizz.func_70681_au();
                            World world = this.blizz.field_70170_p;
                            BlizzProjectileEntity projectile = horzDistSqr < 9.0 ? new BlizzProjectileEntity(targetPos.field_72450_a + rand.nextGaussian() * (double)0.8f, pos.field_72448_b - (double)(rand.nextFloat() * 0.5f) - (double)0.2f, targetPos.field_72449_c + rand.nextGaussian() * (double)0.8f, 0.0, -1.0, 0.0, world) : new BlizzProjectileEntity(pos.field_72450_a + rand.nextGaussian() * (double)0.8f, pos.field_72448_b - (double)rand.nextFloat() - (double)0.2f, pos.field_72449_c + rand.nextGaussian() * (double)0.8f, 0.0, -1.0, 0.0, world);
                            projectile.func_212361_a((Entity)this.blizz);
                            world.func_217376_c((Entity)projectile);
                            ++this.hoverStep;
                            this.hoverStep %= this.hoverOffsets.length;
                        }
                        this.blizz.func_70605_aq().func_75642_a(targetPos.field_72450_a + this.hoverOffsets[this.hoverStep].field_72450_a, targetPos.field_72448_b + this.hoverOffsets[this.hoverStep].field_72448_b, targetPos.field_72449_c + this.hoverOffsets[this.hoverStep].field_72449_c, 1.0);
                        return;
                    }
                    this.blizz.setAngry(false);
                }
            } else {
                this.blizz.setAngry(false);
            }
            if (this.chaseStep < 5) {
                ++this.chaseStep;
                this.blizz.func_70605_aq().func_75642_a(targetPos.field_72450_a, targetPos.field_72448_b + this.hoverOffsets[0].field_72448_b, targetPos.field_72449_c, 1.0);
            }
            super.func_75246_d();
        }

        private double getFollowDistance() {
            return this.blizz.func_233637_b_(Attributes.field_233819_b_);
        }

        protected static Vector3d[] getHoverOffsets(Vector3d start, int steps) {
            float stepRad = (float)Math.PI * 2 / (float)steps;
            Vector3d[] offsets = new Vector3d[steps];
            for (int i = 0; i < steps; ++i) {
                offsets[i] = start.func_178785_b(stepRad * (float)i);
            }
            return offsets;
        }
    }
}

