/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.entity.projectile;

import cofh.lib.util.Utils;
import cofh.lib.util.references.CoreReferences;
import cofh.thermal.core.entity.monster.BasalzEntity;
import cofh.thermal.core.entity.projectile.ElementalProjectileEntity;
import cofh.thermal.core.init.TCoreReferences;
import cofh.thermal.lib.common.ThermalConfig;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.DamagingProjectileEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class BlitzProjectileEntity
extends ElementalProjectileEntity {
    public static float defaultDamage = 5.0f;
    public static int effectAmplifier = 0;
    public static int effectDuration = 100;

    public BlitzProjectileEntity(EntityType<? extends DamagingProjectileEntity> type, World world) {
        super(type, world);
    }

    public BlitzProjectileEntity(LivingEntity shooter, double accelX, double accelY, double accelZ, World world) {
        super(TCoreReferences.BLITZ_PROJECTILE_ENTITY, shooter, accelX, accelY, accelZ, world);
    }

    public BlitzProjectileEntity(double x, double y, double z, double accelX, double accelY, double accelZ, World world) {
        super(TCoreReferences.BLITZ_PROJECTILE_ENTITY, x, y, z, accelX, accelY, accelZ, world);
    }

    protected IParticleData func_195057_f() {
        return ParticleTypes.field_197590_A;
    }

    protected void func_70227_a(RayTraceResult result) {
        Entity entity;
        if (result.func_216346_c() == RayTraceResult.Type.ENTITY && (entity = ((EntityRayTraceResult)result).func_216348_a()).func_70097_a(BlitzDamageSource.causeDamage(this, this.func_234616_v_()), this.getDamage(entity)) && !entity.func_190530_aW() && entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            living.func_195064_c(new EffectInstance(CoreReferences.SHOCKED, this.getEffectDuration(entity), this.getEffectAmplifier(entity), false, false));
        }
        if (ThermalConfig.mobBlitzLightning && Utils.isServerWorld((World)this.field_70170_p)) {
            BlockPos pos = new BlockPos(result.func_216347_e());
            if (this.field_70170_p.func_226660_f_(pos)) {
                float f = this.field_70146_Z.nextFloat();
                float f2 = this.field_70170_p.func_175727_C(pos) ? (this.field_70170_p.func_72911_I() ? 0.2f : 0.1f) : 0.04f;
                if (f < f2) {
                    Utils.spawnLightningBolt((World)this.field_70170_p, (BlockPos)pos);
                }
            }
            this.func_70106_y();
        }
    }

    protected float func_82341_c() {
        return 1.0f;
    }

    @Override
    public float getDamage(Entity target) {
        return target.func_70026_G() || target instanceof BasalzEntity ? defaultDamage + 3.0f : defaultDamage;
    }

    @Override
    public int getEffectAmplifier(Entity target) {
        return effectAmplifier;
    }

    @Override
    public int getEffectDuration(Entity target) {
        return effectDuration;
    }

    protected static class BlitzDamageSource
    extends EntityDamageSource {
        public BlitzDamageSource(Entity source) {
            super("blitz", source);
        }

        public static DamageSource causeDamage(BlitzProjectileEntity entityProj, Entity entitySource) {
            return new IndirectEntityDamageSource("blitz", (Entity)entityProj, (Entity)(entitySource == null ? entityProj : entitySource)).func_76349_b();
        }
    }
}

