/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.util.recipes.device;

import cofh.lib.util.recipes.RecipeJsonUtils;
import cofh.thermal.core.util.recipes.device.HiveExtractorMapping;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class HiveExtractorMappingSerializer
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<HiveExtractorMapping> {
    public HiveExtractorMapping fromJson(ResourceLocation recipeId, JsonObject json) {
        Block hive = Blocks.field_150350_a;
        ItemStack item = ItemStack.field_190927_a;
        FluidStack fluid = FluidStack.EMPTY;
        if (json.has("hive")) {
            hive = RecipeJsonUtils.parseBlock((JsonElement)json.get("hive"));
        }
        if (json.has("item")) {
            item = RecipeJsonUtils.parseItemStack((JsonElement)json.get("item"));
        }
        if (json.has("fluid")) {
            fluid = RecipeJsonUtils.parseFluidStack((JsonElement)json.get("fluid"));
        }
        return new HiveExtractorMapping(recipeId, hive, item, fluid);
    }

    @Nullable
    public HiveExtractorMapping fromNetwork(ResourceLocation recipeId, PacketBuffer buffer) {
        Block hive = (Block)ForgeRegistries.BLOCKS.getValue(buffer.func_192575_l());
        ItemStack item = buffer.func_150791_c();
        FluidStack fluid = buffer.readFluidStack();
        return new HiveExtractorMapping(recipeId, hive, item, fluid);
    }

    public void toNetwork(PacketBuffer buffer, HiveExtractorMapping recipe) {
        buffer.func_192572_a(recipe.hive.getRegistryName());
        buffer.func_150788_a(recipe.item);
        buffer.writeFluidStack(recipe.fluid);
    }
}

