/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.core.util.recipes.device;

import cofh.lib.util.recipes.RecipeJsonUtils;
import cofh.thermal.core.util.managers.device.PotionDiffuserManager;
import cofh.thermal.core.util.recipes.device.PotionDiffuserBoost;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nullable;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class PotionDiffuserBoostSerializer
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<PotionDiffuserBoost> {
    public PotionDiffuserBoost fromJson(ResourceLocation recipeId, JsonObject json) {
        int amplifier = 0;
        float durationMod = 0.0f;
        int cycles = PotionDiffuserManager.instance().getDefaultEnergy();
        Ingredient ingredient = RecipeJsonUtils.parseIngredient((JsonElement)json.get("ingredient"));
        if (json.has("amplifier")) {
            amplifier = json.get("amplifier").getAsInt();
        }
        if (json.has("duration_mod")) {
            durationMod = json.get("duration_mod").getAsFloat();
        }
        if (json.has("cycles")) {
            cycles = json.get("cycles").getAsInt();
        }
        return new PotionDiffuserBoost(recipeId, ingredient, amplifier, durationMod, cycles);
    }

    @Nullable
    public PotionDiffuserBoost fromNetwork(ResourceLocation recipeId, PacketBuffer buffer) {
        Ingredient ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
        int amplifier = buffer.readInt();
        float durationMod = buffer.readFloat();
        int cycles = buffer.readInt();
        return new PotionDiffuserBoost(recipeId, ingredient, amplifier, durationMod, cycles);
    }

    public void toNetwork(PacketBuffer buffer, PotionDiffuserBoost recipe) {
        recipe.ingredient.func_199564_a(buffer);
        buffer.writeInt(recipe.amplifier);
        buffer.writeFloat(recipe.durationMod);
        buffer.writeInt(recipe.cycles);
    }
}

