/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermal.lib.util.recipes;

import cofh.lib.fluid.FluidIngredient;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.util.recipes.RecipeJsonUtils;
import cofh.thermal.lib.util.recipes.ThermalRecipe;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class MachineRecipeSerializer<T extends ThermalRecipe>
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<T> {
    protected final int defaultEnergy;
    protected final IFactory<T> factory;

    public MachineRecipeSerializer(IFactory<T> factory, int defaultEnergy) {
        this.factory = factory;
        this.defaultEnergy = defaultEnergy;
    }

    public T fromJson(ResourceLocation recipeId, JsonObject json) {
        int energy = this.defaultEnergy;
        float experience = 0.0f;
        ArrayList<Ingredient> inputItems = new ArrayList<Ingredient>();
        ArrayList<FluidIngredient> inputFluids = new ArrayList<FluidIngredient>();
        ArrayList<ItemStack> outputItems = new ArrayList<ItemStack>();
        ArrayList<Float> outputItemChances = new ArrayList<Float>();
        ArrayList<FluidStack> outputFluids = new ArrayList<FluidStack>();
        if (json.has("ingredient")) {
            RecipeJsonUtils.parseInputs(inputItems, inputFluids, (JsonElement)json.get("ingredient"));
        } else if (json.has("ingredients")) {
            RecipeJsonUtils.parseInputs(inputItems, inputFluids, (JsonElement)json.get("ingredients"));
        } else if (json.has("input")) {
            RecipeJsonUtils.parseInputs(inputItems, inputFluids, (JsonElement)json.get("input"));
        } else if (json.has("inputs")) {
            RecipeJsonUtils.parseInputs(inputItems, inputFluids, (JsonElement)json.get("inputs"));
        }
        if (json.has("result")) {
            RecipeJsonUtils.parseOutputs(outputItems, outputItemChances, outputFluids, (JsonElement)json.get("result"));
        } else if (json.has("results")) {
            RecipeJsonUtils.parseOutputs(outputItems, outputItemChances, outputFluids, (JsonElement)json.get("results"));
        } else if (json.has("output")) {
            RecipeJsonUtils.parseOutputs(outputItems, outputItemChances, outputFluids, (JsonElement)json.get("output"));
        } else if (json.has("outputs")) {
            RecipeJsonUtils.parseOutputs(outputItems, outputItemChances, outputFluids, (JsonElement)json.get("outputs"));
        }
        if (json.has("energy")) {
            energy = json.get("energy").getAsInt();
        }
        if (json.has("energy_mod")) {
            energy = (int)((float)energy * json.get("energy_mod").getAsFloat());
        }
        energy = MathHelper.clamp((int)energy, (int)0, (int)Integer.MAX_VALUE);
        if (json.has("experience")) {
            experience = json.get("experience").getAsFloat();
        } else if (json.has("xp")) {
            experience = json.get("xp").getAsFloat();
        }
        if (inputItems.isEmpty() && inputFluids.isEmpty() || outputItems.isEmpty() && outputFluids.isEmpty()) {
            throw new JsonSyntaxException("Invalid Thermal Series recipe: " + recipeId + "\nRefer to the recipe's ResourceLocation to find the mod responsible and let them know!");
        }
        return this.factory.create(recipeId, energy, experience, inputItems, inputFluids, outputItems, outputItemChances, outputFluids);
    }

    @Nullable
    public T fromNetwork(ResourceLocation recipeId, PacketBuffer buffer) {
        int energy = buffer.func_150792_a();
        float experience = buffer.readFloat();
        int numInputItems = buffer.func_150792_a();
        ArrayList<Ingredient> inputItems = new ArrayList<Ingredient>(numInputItems);
        for (int i = 0; i < numInputItems; ++i) {
            inputItems.add(Ingredient.func_199566_b((PacketBuffer)buffer));
        }
        int numInputFluids = buffer.func_150792_a();
        ArrayList<FluidIngredient> inputFluids = new ArrayList<FluidIngredient>(numInputFluids);
        for (int i = 0; i < numInputFluids; ++i) {
            inputFluids.add(FluidIngredient.fromNetwork((PacketBuffer)buffer));
        }
        int numOutputItems = buffer.func_150792_a();
        ArrayList<ItemStack> outputItems = new ArrayList<ItemStack>(numOutputItems);
        ArrayList<Float> outputItemChances = new ArrayList<Float>(numOutputItems);
        for (int i = 0; i < numOutputItems; ++i) {
            outputItems.add(buffer.func_150791_c());
            outputItemChances.add(Float.valueOf(buffer.readFloat()));
        }
        int numOutputFluids = buffer.func_150792_a();
        ArrayList<FluidStack> outputFluids = new ArrayList<FluidStack>(numOutputFluids);
        for (int i = 0; i < numOutputFluids; ++i) {
            outputFluids.add(buffer.readFluidStack());
        }
        if (inputItems.isEmpty() && inputFluids.isEmpty() || outputItems.isEmpty() && outputFluids.isEmpty()) {
            throw new JsonSyntaxException("Invalid Thermal Series recipe: " + recipeId + "\nRefer to the recipe's ResourceLocation to find the mod responsible and let them know!");
        }
        return this.factory.create(recipeId, energy, experience, inputItems, inputFluids, outputItems, outputItemChances, outputFluids);
    }

    public void toNetwork(PacketBuffer buffer, T recipe) {
        buffer.func_150787_b(((ThermalRecipe)((Object)recipe)).energy);
        buffer.writeFloat(((ThermalRecipe)((Object)recipe)).xp);
        int numInputItems = ((ThermalRecipe)((Object)recipe)).inputItems.size();
        buffer.func_150787_b(numInputItems);
        for (int i = 0; i < numInputItems; ++i) {
            ((ThermalRecipe)((Object)recipe)).inputItems.get(i).func_199564_a(buffer);
        }
        int numInputFluids = ((ThermalRecipe)((Object)recipe)).inputFluids.size();
        buffer.func_150787_b(numInputFluids);
        for (int i = 0; i < numInputFluids; ++i) {
            ((ThermalRecipe)((Object)recipe)).inputFluids.get(i).toNetwork(buffer);
        }
        int numOutputItems = ((ThermalRecipe)((Object)recipe)).outputItems.size();
        buffer.func_150787_b(numOutputItems);
        for (int i = 0; i < numOutputItems; ++i) {
            buffer.func_150788_a(((ThermalRecipe)((Object)recipe)).outputItems.get(i));
            buffer.writeFloat(((ThermalRecipe)((Object)recipe)).outputItemChances.get(i).floatValue());
        }
        int numOutputFluids = ((ThermalRecipe)((Object)recipe)).outputFluids.size();
        buffer.func_150787_b(numOutputFluids);
        for (int i = 0; i < numOutputFluids; ++i) {
            buffer.writeFluidStack(((ThermalRecipe)((Object)recipe)).outputFluids.get(i));
        }
    }

    public static interface IFactory<T extends ThermalRecipe> {
        public T create(ResourceLocation var1, int var2, float var3, List<Ingredient> var4, List<FluidIngredient> var5, List<ItemStack> var6, List<Float> var7, List<FluidStack> var8);
    }
}

